/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1;

import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.rest.adapter.job.v1.JobUtils;
import csbase.server.services.commandpersistenceservice.CommandStatusListener;
import ibase.rest.api.job.v1.adapter.JobDAO;
import ibase.rest.api.job.v1.adapter.JobMonitorListener;
import ibase.rest.model.job.v1.Job;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class JobStateListener
implements CommandStatusListener {
    private ExecutorService executor;
    private JobDAO jobDAO;
    private Collection<JobMonitorListener> jobsListener = Collections.synchronizedList(new ArrayList());

    public JobStateListener(JobDAO jobDAO) {
        this.executor = Executors.newSingleThreadExecutor();
        this.jobDAO = jobDAO;
    }

    public void statusChanged(CommandInfo commandInfo, CommandStatus newStatus) {
        this.executor.submit(() -> {
            Job job = null;
            String commandId = commandInfo.getId();
            if (this.jobDAO.containsJob(commandId)) {
                job = this.jobDAO.findJobById(commandId);
                this.jobDAO.updateJob(JobUtils.updateJob(job, commandInfo, newStatus));
            } else {
                job = JobUtils.createJob(commandInfo, newStatus);
                this.jobDAO.insertJob(job);
            }
            for (JobMonitorListener listener : this.jobsListener.toArray(new JobMonitorListener[0])) {
                listener.statusChanged(job);
            }
        });
    }

    public void removeJobMonitorLister(JobMonitorListener listener) {
        this.jobsListener.remove(listener);
    }

    public void addJobMonitorLister(JobMonitorListener listener) {
        this.jobsListener.add(listener);
    }
}

