/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1.util;

import br.pucrio.tecgraf.soma.job.Algorithm;
import br.pucrio.tecgraf.soma.job.AlgorithmParameter;
import br.pucrio.tecgraf.soma.job.ExitStatus;
import br.pucrio.tecgraf.soma.job.Flow;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.Node;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.serializer.FlowAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerException;
import csbase.server.plugin.service.commandpersistenceservice.ICommandInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CSBaseCommandUtil {
    public static AlgorithmParameter convertFromCSBaseParameter(SimpleParameter<?> p) {
        AlgorithmParameter param = new AlgorithmParameter();
        param.setParameterId(p.getName());
        param.setLabel(p.getLabel());
        param.setType(p.getType());
        param.setValue(p.getValueAsText());
        return param;
    }

    public static Flow createFlowFromConfig(FlowAlgorithmConfigurator flowConf) {
        Flow flow = new Flow();
        if (flowConf.getAlgorithmId() != null) {
            flow.setFlowId(flowConf.getAlgorithmId());
        } else {
            flow.setFlowId("");
        }
        if (flowConf.getAlgorithmVersion() != null) {
            flow.setFlowVersion(flowConf.getAlgorithmVersion().toString());
        } else {
            flow.setFlowVersion("");
        }
        if (flowConf.getAlgorithmName() != null) {
            flow.setFlowName(flowConf.getAlgorithmName());
        } else {
            flow.setFlowName("");
        }
        ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
        for (Node node : flowConf.getNodes()) {
            algorithms.add(CSBaseCommandUtil.createAlgorithmFromConfig(node.getConfigurator()));
        }
        flow.setAlgorithms(algorithms);
        FlowAlgorithmConfigurationSerializer serializer = new FlowAlgorithmConfigurationSerializer();
        try (ByteArrayOutputStream serializerOutput = new ByteArrayOutputStream();){
            serializer.write((AlgorithmConfigurator)flowConf, (OutputStream)serializerOutput);
            byte[] configuratorData = serializerOutput.toByteArray();
            flow.setRaw(ByteBuffer.wrap(configuratorData));
        }
        catch (AlgorithmConfigurationSerializerException | IOException e) {
            e.printStackTrace();
        }
        return flow;
    }

    public static Algorithm createAlgorithmFromConfig(AlgorithmConfigurator algoConf) {
        Algorithm algorithm = new Algorithm();
        algorithm.setAlgorithmId(algoConf.getAlgorithmId());
        algorithm.setAlgorithmVersion(algoConf.getAlgorithmVersion().toString());
        algorithm.setAlgorithmName(algoConf.getAlgorithmName());
        List params = ((SimpleAlgorithmConfigurator)algoConf).getSimpleParameters().stream().map(CSBaseCommandUtil::convertFromCSBaseParameter).collect(Collectors.toList());
        algorithm.setParameters(params);
        return algorithm;
    }

    public static ExitStatus getExitStatusFromInfo(CommandFinalizationInfo finalizationInfo) {
        switch (finalizationInfo.getFinalizationType()) {
            case SUCCESS: {
                return ExitStatus.SUCCESS;
            }
            case LOST: {
                return ExitStatus.LOST;
            }
            case EXECUTION_ERROR: {
                return ExitStatus.EXECUTION_ERROR;
            }
            case KILLED: {
                return ExitStatus.KILLED;
            }
            case FAILED: {
                switch (finalizationInfo.getFailureCause()) {
                    case UNKNOWN: {
                        return ExitStatus.UNKNOWN;
                    }
                    case COMMAND_IDENTIFIER_NOT_FOUND: {
                        return ExitStatus.COMMAND_IDENTIFIER_NOT_FOUND;
                    }
                    case SGA_EXECUTION_ERROR: {
                        return ExitStatus.UNEXPECTED_MACHINE_ERROR;
                    }
                    case FAILED_SETUP_EXECUTION_ENVIRONMENT: {
                        return ExitStatus.FAILED_SETUP_EXECUTION_ENVIRONMENT;
                    }
                    case PROJECT_NOT_FOUND: {
                        return ExitStatus.PROJECT_NOT_FOUND;
                    }
                    case NO_SGA_AVAILABLE_TO_ROOT_COMMAND: 
                    case SGA_IS_NOT_AVAILABLE: {
                        return ExitStatus.NO_MACHINE_AVAILABLE;
                    }
                    case USER_WITHOUT_PERMISSION_FOR_EXECUTION: {
                        return ExitStatus.NO_PERMISSION;
                    }
                }
                return ExitStatus.UNDEFINED;
            }
            case NO_EXIT_CODE: 
            case END: 
            case UNKNOWN: {
                return ExitStatus.UNKNOWN;
            }
        }
        return ExitStatus.UNDEFINED;
    }

    public static ICommandInfo buildIcommandInfo(final CommandInfo command) {
        return new ICommandInfo(){

            public String getCommandId() {
                return command.getId();
            }

            public String getDescription() {
                return command.getDescription();
            }

            public String getProjectId() {
                return (String)command.getProjectId();
            }

            public ICommandInfo.CommandStatus getStatus() {
                switch (command.getStatus()) {
                    case DOWNLOADING: {
                        return ICommandInfo.CommandStatus.DOWNLOADING;
                    }
                    case EXECUTING: {
                        return ICommandInfo.CommandStatus.EXECUTING;
                    }
                    case FINISHED: {
                        return ICommandInfo.CommandStatus.FINISHED;
                    }
                    case INIT: {
                        return ICommandInfo.CommandStatus.INIT;
                    }
                    case SCHEDULED: {
                        if (command.getSubmissionAttempts() > 1) {
                            return ICommandInfo.CommandStatus.RESCHEDULED;
                        }
                        return ICommandInfo.CommandStatus.SCHEDULED;
                    }
                    case SYSTEM_FAILURE: {
                        return ICommandInfo.CommandStatus.SYSTEM_FAILURE;
                    }
                    case UPLOADING: {
                        return ICommandInfo.CommandStatus.UPLOADING;
                    }
                }
                throw new IllegalArgumentException("Tipo do evento inv\u00e1lido: " + command.getStatus());
            }

            public ICommandInfo.FinalizationType getFinalizationType() {
                CommandFinalizationInfo finalizationInfo = command.getFinalizationInfo();
                CommandFinalizationType type = finalizationInfo.getFinalizationType();
                switch (type) {
                    case END: {
                        return ICommandInfo.FinalizationType.COMPLETED;
                    }
                    case EXECUTION_ERROR: {
                        return ICommandInfo.FinalizationType.ERROR;
                    }
                    case FAILED: {
                        return ICommandInfo.FinalizationType.INIT_FAILURE;
                    }
                    case KILLED: {
                        return ICommandInfo.FinalizationType.KILLED;
                    }
                    case LOST: {
                        return ICommandInfo.FinalizationType.LOST;
                    }
                    case NO_EXIT_CODE: {
                        return ICommandInfo.FinalizationType.NO_CODE;
                    }
                    case SUCCESS: {
                        return ICommandInfo.FinalizationType.SUCCESS;
                    }
                }
                throw new IllegalArgumentException("Tipo do evento inv\u00e1lido: " + type);
            }

            public Integer getExitCode() {
                CommandFinalizationInfo finalizationInfo = command.getFinalizationInfo();
                return finalizationInfo.getExitCode();
            }

            public Integer getGuiltyNodeId() {
                CommandFinalizationInfo finalizationInfo = command.getFinalizationInfo();
                CommandFinalizationInfo.FinalizationInfoType infoType = finalizationInfo.getInfoType();
                if (infoType.equals((Object)CommandFinalizationInfo.FinalizationInfoType.EXTENDED)) {
                    ExtendedCommandFinalizationInfo extendedInfo = (ExtendedCommandFinalizationInfo)finalizationInfo;
                    return extendedInfo.getGuiltyNodeId();
                }
                return null;
            }
        };
    }
}

