/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.project.v1;

import csbase.logic.CommonClientProject;
import csbase.logic.UserProjectInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import ibase.exception.InternalServiceException;
import ibase.rest.api.project.v1.adapter.ProjectInfo;

public class CSBaseProjectInfo
implements ProjectInfo {
    private UserProjectInfo info;

    CSBaseProjectInfo(UserProjectInfo info) {
        this.info = info;
    }

    public String getId() {
        return (String)this.info.getProjectId();
    }

    public String getName() {
        return this.info.getProjectName();
    }

    public String getDescription() {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            CommonClientProject ccp = service.openProject(this.info.getProjectId(), false);
            return ccp.getDescription();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public Boolean isWritableByUser(String userId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            return service.userCanWrite(this.info.getProjectId(), (Object)userId);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }
}

