package csbase.server.plugin.service.projectservice;

import csbase.server.plugin.service.ServiceException;

/**
 * Interface pblica do servio de Projetos.
 *
 * @author Tecgraf/PUC-Rio
 */
public interface IProjectService {
  /**
   * Obtm a caminho para o repositrio de projetos.
   *
   * @return o caminho para o repositrio de projetos.
   */
  public abstract String getProjectRepositoryPath();

  /**
   * Informa se um dado projeto existe.
   *
   * @param projectId Identificador do projeto.
   * @return Verdadeiro caso exista, falso caso contrrio.
   */
  public boolean existsProject(Object projectId);

  /**
   * Verifica se um arquivo existe no servidor.
   *
   * @param projectId Identificador do projeto.
   * @param path Caminho para o arquivo, a partir da raiz.
   * @return Verdadeiro se o arquivo existe no servidor, falso caso contrrio.
   */
  boolean existsFile(Object projectId, String[] path);

  /**
   * Cria um novo diretrio, ou uma nova rvore de diretrios, dentro de um
   * projeto.
   *
   * @param projectId Identificador do projeto.
   * @param path Caminho do diretrio a ser criado. Todos os elementos do array
   *        que ainda no existam sero criados no projeto como diretrios, a
   *        partir da raiz.
   */
  void createDirectory(Object projectId, String[] path);

  /**
   * Remove um arquivo de um projeto.
   *
   * @param projectId Identificador do projeto.
   * @param path Caminho do arquivo a ser removido, a partir da raiz.
   */
  void removeFile(Object projectId, String[] path) throws ServiceException;

  /**
   * Copia um arquivo de um projeto para outro diretrio.
   *
   * @param projectId Identificador do projeto.
   * @param filePath Caminho do arquivo a ser copiado, a partir da raiz.
   * @param dirPath Caminho do diretrio destino, a partir da raiz.
   */
  void copyFile(Object projectId, String[] filePath, String[] dirPath);

  /**
   * Copia um arquivo de um projeto para um diretrio de outro projeto.
   *
   * @param sourceProjectId Identificador do projeto Origem.
   * @param filePathSource Caminho do arquivo a ser copiado, a partir da raiz.
   * @param targetProjectId Identificador do projeto Destino.
   * @param dirPathTarget Caminho do diretrio destino, a partir da raiz.
   */
  void copyFile(Object sourceProjectId, String[] filePathSource,
    Object targetProjectId, String[] dirPathTarget);
}
