/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.logic.AdministrationEvent;
import csbase.logic.User;
import csbase.remote.ServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.plugin.service.IService;
import csbase.server.plugin.service.IServiceManager;
import csbase.server.services.ServiceInvocationHandler;
import csbase.server.services.httpservice.HttpService;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.loginservice.LogoutEvent;
import csbase.server.services.messageservice.MessageService;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import csbase.util.messages.filters.BodyTypeFilter;
import csbase.util.proxy.ProxyUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tecgraf.javautils.core.filter.IFilter;

public class ServiceManager
implements IServiceManager {
    private static ServiceManager instance;
    private final Map<String, Service> servicesMap = new LinkedHashMap<String, Service>();
    private List<Service> sortedServices;
    private final Map<Object, Map<String, ServiceInterface>> usersProxiesMap = new Hashtable<Object, Map<String, ServiceInterface>>();
    private Serializable consumerId;

    protected static void init() {
        if (instance != null) {
            return;
        }
        instance = new ServiceManager();
    }

    protected void initAllServices() throws ServerException {
        Server.logInfoMessage("Inicializando servi\u00e7os...");
        this.sortedServices = new LinkedList<Service>();
        List<Service> notInitializedServices = this.getEnabledServices();
        while (notInitializedServices.size() > 0) {
            this.tryInitServices(notInitializedServices);
            notInitializedServices.removeAll(this.sortedServices);
        }
        try {
            this.install();
        }
        catch (RemoteException re) {
            throw new ServerException(re);
        }
        Server.logInfoMessage("Servi\u00e7os inicializados");
    }

    private List<Service> getEnabledServices() {
        LinkedList<Service> enabledServices = new LinkedList<Service>();
        for (Service service : this.servicesMap.values()) {
            if (service.isEnabled()) {
                enabledServices.add(service);
                Server.logFineMessage(String.format("O servi\u00e7o %s est\u00e1 habilitado", service.getName()));
                continue;
            }
            Server.logInfoMessage(String.format("O servi\u00e7o %s est\u00e1 desabilitado", service.getName()));
        }
        return enabledServices;
    }

    private void tryInitServices(List<Service> services) throws ServerException {
        boolean anyServiceInitialized = false;
        for (Service service : services) {
            if (!service.tryInit()) continue;
            anyServiceInitialized = true;
            this.sortedServices.add(service);
        }
        if (!anyServiceInitialized) {
            StringBuilder errorMessage = new StringBuilder("Os seguintes servi\u00e7os n\u00e3o puderam ser inicializados, provavelmente por causa de uma depend\u00eancia c\u00edclica:");
            for (Service notInitedService : services) {
                errorMessage.append("\n" + notInitedService.getName());
            }
            Server.logSevereMessage(errorMessage.toString());
            throw new ServerException(errorMessage.toString());
        }
    }

    public void shutdownAllServices() throws ServerException {
        if (this.sortedServices == null) {
            return;
        }
        Server.logInfoMessage("Finalizando servi\u00e7os...");
        try {
            this.uninstall();
        }
        catch (RemoteException re) {
            throw new ServerException(re);
        }
        for (int i = this.sortedServices.size() - 1; i >= 0; --i) {
            Service service = this.sortedServices.get(i);
            service.shutdown();
        }
        this.sortedServices = null;
        Server.logInfoMessage("Servi\u00e7os finalizados");
    }

    public static ServiceManager getInstance() {
        return instance;
    }

    private ServiceManager() {
    }

    public void install() throws RemoteException {
        IMessageListener listener = new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    LogoutEvent event = (LogoutEvent)((Object)message.getBody());
                    Object sessionKey = event.getSessionKey();
                    ServiceManager.this.shutdownProxies(sessionKey);
                }
            }
        };
        this.consumerId = MessageService.getInstance().setServerMessageListener(listener, (IFilter<Message>)new BodyTypeFilter(AdministrationEvent.class));
    }

    public void uninstall() throws RemoteException {
        MessageService.getInstance().clearServerMessageListener(this.consumerId);
    }

    public void addService(Service service) {
        if (service == null) {
            throw new IllegalArgumentException("service == <<null>>");
        }
        this.servicesMap.put(service.getName(), service);
    }

    public Map<String, ServiceInterface> getRemoteServices(Object sessionKey, Set<String> servicesNames) {
        if (sessionKey == null || servicesNames == null) {
            throw new IllegalArgumentException("(sessionKey || servicesNames) == <<null>>");
        }
        if (!LoginService.getInstance().isValidSession(sessionKey)) {
            return null;
        }
        HashMap<String, ServiceInterface> remoteServices = new HashMap<String, ServiceInterface>();
        for (String serviceName : servicesNames) {
            ServiceInterface srv = this.getRemoteService(sessionKey, serviceName);
            if (srv == null) continue;
            remoteServices.put(serviceName, srv);
        }
        return Collections.unmodifiableMap(remoteServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInterface getRemoteService(Object sessionKey, String serviceName) {
        if (sessionKey == null || serviceName == null) {
            throw new IllegalArgumentException("(sessionKey || serviceName) == <<null>>");
        }
        if (!LoginService.getInstance().isValidSession(sessionKey)) {
            return null;
        }
        if (serviceName.equals("HttpService")) {
            return HttpService.getInstance();
        }
        Map<Object, Map<String, ServiceInterface>> map = this.usersProxiesMap;
        synchronized (map) {
            ServiceInterface proxy;
            Map<String, ServiceInterface> proxies = this.usersProxiesMap.get(sessionKey);
            if (proxies == null) {
                proxies = new HashMap<String, ServiceInterface>();
            }
            if ((proxy = proxies.get(serviceName)) != null) {
                return proxy;
            }
            proxy = this.newProxy(sessionKey, serviceName);
            if (proxy == null) {
                return null;
            }
            proxies.put(serviceName, proxy);
            this.usersProxiesMap.put(sessionKey, proxies);
            return proxy;
        }
    }

    private ServiceInterface newProxy(Object sessionKey, String serviceName) {
        try {
            IService service = Service.getInstance(serviceName);
            if (service == null) {
                return null;
            }
            InvocationHandler serviceHandler = ProxyUtils.createInvocationHandler((Object)service);
            serviceHandler = new ServiceInvocationHandler(sessionKey, serviceHandler);
            int port = Server.getInstance().getRMIExportPort();
            return (ServiceInterface)ProxyUtils.newRemoteProxyInstance((Object)service, (InvocationHandler)serviceHandler, (int)port);
        }
        catch (Exception e) {
            LoginService loginService = LoginService.getInstance();
            User key = loginService.getUserByKey(sessionKey);
            Server.logSevereMessage("Falha ao criar proxy de " + serviceName + " para " + key, e);
            return null;
        }
    }

    private void shutdownProxies(Object sessionKey) {
        Map<String, ServiceInterface> proxies = this.usersProxiesMap.remove(sessionKey);
        if (proxies == null) {
            return;
        }
        Set<Map.Entry<String, ServiceInterface>> entries = proxies.entrySet();
        for (Map.Entry<String, ServiceInterface> entry : entries) {
            ServiceInterface proxy = entry.getValue();
            try {
                ProxyUtils.unexportRemoteProxy((Object)proxy);
            }
            catch (Exception ex) {
                String serviceName = entry.getKey();
                String fmt = "Falha ao remover proxy de %s para %s";
                String message = String.format("Falha ao remover proxy de %s para %s", serviceName, sessionKey);
                Server.logSevereMessage(message);
            }
        }
    }

    public IService getService(String serviceName) {
        return this.servicesMap.get(serviceName);
    }

    public Map<String, Service> getServices() {
        return this.servicesMap;
    }
}

