/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.mailservice;

import csbase.logic.User;
import csbase.remote.MailServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailService
extends Service
implements MailServiceInterface {
    private static final String MAIL_SMTP_PORT_PROPERTY_NAME = "mail.smtp.port";
    private static final String MAIL_SMTP_HOST_PROPERTY_NAME = "mail.smtp.host";
    private static final Pattern _MAIL_PTTN = Pattern.compile("^[^\\s@]+@[^\\s@]+$");
    private Session session = null;
    private final String[] supportTo = new String[]{this.getStringProperty("support")};
    private final String defaultSender = this.getStringProperty("from");
    private final String mailHostName = this.getStringProperty("mail.smtp.host");
    private final int mailHostPort = this.getIntProperty("mail.smtp.port");

    private String[] getUserMails(Object userId) {
        try {
            if (userId == null) {
                Server.logSevereMessage("Detectado id de usu\u00e1rio nulo.");
                return null;
            }
            User user = User.getUser((Object)userId);
            if (user == null) {
                Server.logSevereMessage("Detectado usu\u00e1rio nulo para: " + userId);
                return null;
            }
            return user.getEmails();
        }
        catch (Exception ue) {
            Server.logSevereMessage("Falha na detec\u00e7\u00e3o de email do usu\u00e1rio " + userId + "!");
            return null;
        }
    }

    private boolean createSession() {
        String fmt = "Servidor de mail - %s:%d";
        String msg = String.format("Servidor de mail - %s:%d", this.mailHostName, this.mailHostPort);
        Server.logInfoMessage(msg);
        Properties props = new Properties();
        props.put(MAIL_SMTP_HOST_PROPERTY_NAME, this.mailHostName);
        String mailHostPortStr = String.format("%d", this.mailHostPort);
        props.put(MAIL_SMTP_PORT_PROPERTY_NAME, mailHostPortStr);
        this.session = Session.getDefaultInstance((Properties)props, null);
        if (this.session == null) {
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel instanciar uma sess\u00e3o de e-mail");
            return false;
        }
        return true;
    }

    private boolean accessMailServer(String from, String[] addressees, String subject, String textContent, String replyTo, String[] copyTo, File[] attachments) {
        if (this.session == null) {
            return false;
        }
        String sender = this.createValidSender(from);
        try {
            ArrayList<InternetAddress> addresseesList = new ArrayList<InternetAddress>();
            for (String address : addressees) {
                if (address == null || (address = address.trim()).length() == 0) continue;
                addresseesList.add(new InternetAddress(address));
            }
            if (addresseesList.size() == 0) {
                return false;
            }
            InternetAddress[] to = addresseesList.toArray(new InternetAddress[addresseesList.size()]);
            MimeMessage msg = new MimeMessage(this.session);
            msg.setFrom((Address)new InternetAddress(sender));
            msg.setRecipients(Message.RecipientType.TO, (Address[])to);
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            MimeBodyPart part = new MimeBodyPart();
            part.setText(textContent);
            MimeMultipart attachedContent = new MimeMultipart();
            attachedContent.addBodyPart((BodyPart)part);
            if (attachments != null) {
                for (File file : attachments) {
                    part = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(file);
                    part.setDataHandler(new DataHandler((DataSource)source));
                    part.setFileName(file.getName());
                    attachedContent.addBodyPart((BodyPart)part);
                }
            }
            msg.setContent((Multipart)attachedContent);
            if (replyTo != null && !replyTo.trim().isEmpty()) {
                InternetAddress[] replies = new InternetAddress[]{new InternetAddress(replyTo)};
                msg.setReplyTo((Address[])replies);
            }
            if (copyTo != null && copyTo.length > 0) {
                ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
                for (int i = 0; i < copyTo.length; ++i) {
                    if (copyTo[i].trim().isEmpty()) continue;
                    addresses.add(new InternetAddress(copyTo[i]));
                }
                InternetAddress[] copies = addresses.toArray(new InternetAddress[addresses.size()]);
                msg.setRecipients(Message.RecipientType.CC, (Address[])copies);
            }
            Transport.send((Message)msg);
        }
        catch (MessagingException mex) {
            String msg = "Falha no envio de email para [" + addressees + "]! ";
            String err = "Exce\u00e7\u00e3o no servidor: " + (Object)((Object)mex) + "!";
            Server.logSevereMessage(msg + err);
            return false;
        }
        return true;
    }

    private String createValidSender(String seedArg) {
        String seed = seedArg;
        if (null == seed) {
            seed = this.defaultSender;
        }
        if (_MAIL_PTTN.matcher(seed).matches()) {
            return seed;
        }
        return String.format("%1$s@no-reply.%2$s", seed.split("@")[0], this.defaultSender.split("@")[1]);
    }

    private String makeSubject(String sender) {
        if (sender == null) {
            return Server.getInstance().getSystemName() + " - " + this.defaultSender;
        }
        return Server.getInstance().getSystemName() + " - " + sender;
    }

    public final boolean sendMail(String sender, String[] addressees, String content) {
        String subject = this.makeSubject(sender);
        return this.sendMail(sender, addressees, content, subject, null, null);
    }

    public final boolean sendMail(String sender, String[] addressees, String content, String subject, String replyTo, String[] copyTo) {
        return this.sendMail(sender, addressees, content, subject, replyTo, copyTo, null);
    }

    public final boolean sendMail(String senderName, String[] to, String content, String subject, String replyTo, String[] copyTo, File[] attachments) {
        String cnt = content == null ? this.getString("no.content") : content;
        String snd = senderName == null ? this.defaultSender : senderName;
        String sub = subject == null ? this.makeSubject(senderName) : subject;
        return this.accessMailServer(snd, to, sub, cnt, replyTo, copyTo, attachments);
    }

    public final boolean mailTo(String sender, Object userId, String content) {
        return this.mailUser(sender, userId, content, new File[0]);
    }

    public boolean mailTo(String senderName, Object userId, String content, File[] attachments) {
        return this.mailUser(senderName, userId, content, attachments);
    }

    public final boolean mailSupport(String content) {
        String systemName = Server.getInstance().getSystemName();
        String nowText = new Date().toString();
        String timePrefix = "\n\n" + systemName + "\n" + nowText + "\n\n";
        String fmtContent = timePrefix + content;
        return this.sendMail(this.defaultSender, this.supportTo, fmtContent);
    }

    public final boolean mailSupport(String textContent, File[] attachments) {
        String systemName = Server.getInstance().getSystemName();
        String nowText = new Date().toString();
        String timePrefix = "\n\n" + systemName + "\n" + nowText + "\n\n";
        String fmtContent = timePrefix + textContent;
        return this.sendMail(this.defaultSender, this.supportTo, fmtContent, null, null, null, attachments);
    }

    private boolean mailUser(String sender, Object userId, String content, File ... attachments) {
        String[] addressee = this.getUserMails(userId);
        if (addressee == null || addressee.length == 0) {
            Server.logSevereMessage("Usu\u00e1rio [" + userId + "] n\u00e3o tem email relacionado!");
            return false;
        }
        return this.sendMail(sender, addressee, content, null, null, null, attachments);
    }

    public final boolean mailSomeUsers(String sender, Object[] usersId, String content) {
        boolean flag = true;
        if (usersId == null) {
            return true;
        }
        for (int i = 0; i < usersId.length; ++i) {
            Object id = usersId[i];
            flag &= this.mailUser(sender, id, content, new File[0]);
        }
        return flag;
    }

    public final boolean mailSomeUsers(String sender, Object[] usersId, String content, File[] attachments) {
        boolean flag = true;
        if (usersId == null) {
            return true;
        }
        for (int i = 0; i < usersId.length; ++i) {
            Object id = usersId[i];
            flag &= this.mailUser(sender, id, content, attachments);
        }
        return flag;
    }

    public final boolean mailSomeUsersFromService(Service service, Object[] usersId, String content) {
        if (service == null) {
            Server.logSevereMessage("Servi\u00e7o n\u00e3o identificado tentou enviar email!");
            return false;
        }
        String formatedContent = this.formatServiceMailContent(service, content);
        return this.mailSomeUsers(this.defaultSender, usersId, formatedContent);
    }

    public final boolean mailUserFromService(Service service, Object userId, String content) {
        if (service == null) {
            Server.logSevereMessage("Servi\u00e7o n\u00e3o identificado tentou enviar email!");
            return false;
        }
        String formatedContent = this.formatServiceMailContent(service, content);
        return this.mailUser(this.defaultSender, userId, formatedContent, new File[0]);
    }

    public final boolean mailFromService(Service service, String[] addressees, String content) {
        if (service == null) {
            String err = "Servi\u00e7o n\u00e3o identificado tentou enviar email!";
            Server.logSevereMessage(err);
            return false;
        }
        String formatedContent = this.formatServiceMailContent(service, content);
        return this.sendMail(this.defaultSender, addressees, formatedContent);
    }

    private String formatServiceMailContent(Service service, String content) {
        String fmt = this.getString("MailService.services.mail.content");
        String systemName = Server.getInstance().getSystemName();
        String serviceName = service.getName();
        String newContent = String.format(fmt, systemName, serviceName, content);
        String timePrefix = "\n\n" + new Date().toString() + "\n\n";
        return timePrefix + newContent;
    }

    protected final boolean has2Update(Object arg, Object event) {
        return true;
    }

    @Override
    public final void shutdownService() {
    }

    @Override
    public final void initService() throws ServerException {
        Server.logInfoMessage("Endere\u00e7o remetente: " + this.defaultSender);
        if (!this.createSession()) {
            throw new ServerException("Falha na constru\u00e7\u00e3o da sess\u00e3o de mail!");
        }
    }

    public static MailService getInstance() {
        return (MailService)MailService.getInstance("MailService");
    }

    public static final void createService() throws ServerException {
        new MailService();
    }

    protected MailService() throws ServerException {
        super("MailService");
    }
}

