/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice.v1_01;

import csbase.logic.ClientProjectFile;
import csbase.logic.SyncRemoteFileChannel;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.projectservice.UpdatableFileInfo;
import csbase.server.services.projectservice.v1_01.DataBridge;
import csbase.server.services.projectservice.v1_01.DataValidation;
import csbase.server.services.projectservice.v1_01.FindService;
import csbase.server.services.projectservice.v1_01.OpenBusProjectFileUpdater;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.omg.CORBA.Any;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.FileLockedException;
import tecgraf.ftc.common.exception.MaxClientsReachedException;
import tecgraf.ftc.common.exception.PermissionException;
import tecgraf.ftc.common.logic.RemoteFileChannel;
import tecgraf.openbus.data_service.core.v1_01.AbsentViews;
import tecgraf.openbus.data_service.core.v1_01.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_01.DataAlreadyExist;
import tecgraf.openbus.data_service.core.v1_01.DataDescription;
import tecgraf.openbus.data_service.core.v1_01.DataKeyWrapper;
import tecgraf.openbus.data_service.core.v1_01.DataNotFound;
import tecgraf.openbus.data_service.core.v1_01.DataView;
import tecgraf.openbus.data_service.core.v1_01.DefaultView;
import tecgraf.openbus.data_service.core.v1_01.IDataService;
import tecgraf.openbus.data_service.core.v1_01.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_01.Metadata;
import tecgraf.openbus.data_service.core.v1_01.ServiceFailure;
import tecgraf.openbus.data_service.core.v1_01.UnavailableDataService;
import tecgraf.openbus.data_service.core.v1_01.UnstructuredDataView;
import tecgraf.openbus.data_service.core.v1_01.UnstructuredDataViewHelper;
import tecgraf.openbus.data_service.core.v1_01.UnsupportedView;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalTransferDataServiceOperations;
import tecgraf.openbus.data_service.hierarchical.v1_01.InvalidPrototype;
import tecgraf.openbus.data_service.hierarchical.v1_02.InvalidContainer;
import tecgraf.openbus.data_service.hierarchical.v1_02.UnsupportedOperation;
import tecgraf.openbus.data_service.project.v1_01.ProjectDataViewFactory;
import tecgraf.openbus.data_service.project.v1_01.ProjectDataViewHelper;
import tecgraf.openbus.data_service.project.v1_01.ProjectItemDataView;
import tecgraf.openbus.data_service.project.v1_01.ProjectItemDataViewFactory;
import tecgraf.openbus.data_service.project.v1_01.ProjectItemDataViewHelper;
import tecgraf.openbus.data_service.project.v1_01.ProjectItemDataViewImpl;

public class ProjectDataService
implements IHierarchicalTransferDataServiceOperations {
    private static final DataDescription[] EMPTY_DATA_DESCRIPTION_ARRAY = new DataDescription[0];
    private static final String ABSOLUTE_PATH_METADATUM_NAME = "ABSOLUTE_PATH";
    protected String SourceId = ProjectService.getInstance().getSourceId();
    private static ProjectDataService instance;

    private ProjectDataService() {
        ORB orb = (ORB)OpenBusService.getInstance().getORB();
        orb.register_value_factory(ProjectDataViewHelper.id(), (ValueFactory)new ProjectDataViewFactory());
        orb.register_value_factory(ProjectItemDataViewHelper.id(), (ValueFactory)new ProjectItemDataViewFactory());
    }

    public static ProjectDataService getInstance() {
        if (instance == null) {
            instance = new ProjectDataService();
        }
        return instance;
    }

    public byte[] copyDataFrom(byte[] fSourceKey, byte[] fParentKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound, AbsentViews, UnavailableDataService, DataAlreadyExist, tecgraf.openbus.data_service.hierarchical.v1_01.UnsupportedOperation {
        DataKeyWrapper parentKey = new DataKeyWrapper(fParentKey);
        DataValidation.checkDataKey(parentKey);
        OpenBusService.getInstance().joinChain();
        try {
            DataDescription parentDescription;
            byte[] fParentKeyV1_02;
            try {
                fParentKeyV1_02 = DataBridge.convertDataKeyToV1_02(fParentKey);
            }
            catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
                throw new InvalidDataKey((byte[][])new byte[][]{fParentKey});
            }
            csbase.server.services.projectservice.v1_02.ProjectDataService dataServicev1_02 = csbase.server.services.projectservice.v1_02.ProjectDataService.getInstance();
            try {
                parentDescription = DataBridge.convertDataDescriptionToV1_01(dataServicev1_02.getDataDescription(fParentKeyV1_02));
            }
            catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e1) {
                throw new ServiceFailure(e1.fMessage);
            }
            catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e1) {
                throw new DataAccessDenied((byte[][])new byte[][]{fParentKey});
            }
            catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e1) {
                throw new DataNotFound((byte[][])new byte[][]{fParentKey});
            }
            catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
                throw new InvalidDataKey((byte[][])new byte[][]{fParentKey});
            }
            String parentAbsolutePath = null;
            for (int i = 0; i < parentDescription.fMetadata.length; ++i) {
                if (!parentDescription.fMetadata[i].fName.equals(ABSOLUTE_PATH_METADATUM_NAME)) continue;
                Any any = parentDescription.fMetadata[i].fValue;
                parentAbsolutePath = any.extract_string();
            }
            DataKeyWrapper sourceDataKey = new DataKeyWrapper(fSourceKey);
            IDataService sourceDataService = FindService.find(sourceDataKey);
            if (sourceDataService == null) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao copiar o dado: servi\u00e7o de dados da origem n\u00e3o dispon\u00edvel: {1} {2}", userLogin, sourceDataKey.getSystemDeploymentId(), sourceDataKey.getDataSourceId());
                Server.logSevereMessage(msg);
                throw new UnavailableDataService(msg);
            }
            DataDescription sourceDataDescription = sourceDataService.getDataDescription(fSourceKey);
            ProjectItemDataView sourceProjItemDataView = (ProjectItemDataView)ProjectItemDataView.class.cast(sourceDataService.getDataView(fSourceKey, ProjectItemDataViewHelper.id()));
            String absolutePath = parentAbsolutePath + "/" + sourceDataDescription.fName;
            Metadata[] metadata = ProjectDataService.createMetadataList(absolutePath);
            long date = System.currentTimeMillis();
            String userLogin = Service.getUser().getLogin();
            ProjectItemDataViewImpl prototypeProjItemDataView = new ProjectItemDataViewImpl(null, userLogin, sourceProjItemDataView.fDescription, absolutePath, sourceProjItemDataView.fType, 0L, sourceProjItemDataView.fIsContainer, sourceProjItemDataView.fCanRead, sourceProjItemDataView.fCanWrite, date, date);
            DefaultView defaultView = new DefaultView(ProjectItemDataViewHelper.id(), (DataView)prototypeProjItemDataView);
            DataDescription prototype = new DataDescription(null, sourceDataDescription.fName, defaultView, null, metadata);
            tecgraf.openbus.data_service.core.v1_02.DataDescription prototypeV1_02 = DataBridge.convertDataDescriptionToV1_02(prototype);
            csbase.server.services.projectservice.v1_02.ProjectDataService managementDataServiceV1_02 = csbase.server.services.projectservice.v1_02.ProjectDataService.getInstance();
            byte[] key = null;
            try {
                key = DataBridge.convertDataKeyToV1_01(managementDataServiceV1_02.createData(prototypeV1_02, fParentKeyV1_02));
            }
            catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
                throw new InvalidDataKey((byte[][])new byte[][]{fParentKey});
            }
            catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
                throw new ServiceFailure(e.fMessage);
            }
            catch (UnsupportedOperation e) {
                throw new tecgraf.openbus.data_service.hierarchical.v1_01.UnsupportedOperation();
            }
            catch (tecgraf.openbus.data_service.hierarchical.v1_02.InvalidPrototype e) {
                throw new InvalidPrototype();
            }
            catch (tecgraf.openbus.data_service.core.v1_02.DataAlreadyExist e) {
                throw new DataAlreadyExist();
            }
            catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
                throw new DataNotFound((byte[][])new byte[][]{fParentKey});
            }
            catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
                throw new DataAccessDenied((byte[][])new byte[][]{fParentKey});
            }
            this.updateDataFrom(key, fSourceKey);
            byte[] byArray = key;
            return byArray;
        }
        catch (ServiceFailure e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao copiar o dado: {1}", userLogin, e.fMessage);
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (InvalidContainer e) {
            throw new ServiceFailure("Dado pai n\u00e3o \u00e9 um diret\u00f3rio.");
        }
        catch (InvalidPrototype e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao copiar o dado: prot\u00f3tipo inv\u00e1lido.", userLogin);
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (UnsupportedView e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao copiar o dado: vis\u00e3o n\u00e3o suportada.", userLogin);
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        finally {
            OpenBusService.getInstance().exitChain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateDataFrom(byte[] fKey, byte[] fSourceKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound, UnavailableDataService, AbsentViews {
        SyncRemoteFileChannel sourceChannel;
        SyncRemoteFileChannel channel;
        UnstructuredDataView sourceView;
        ClientProjectFile file;
        byte[] fKeyV1_02;
        DataKeyWrapper dataKey = new DataKeyWrapper(fKey);
        DataValidation.checkDataKey(dataKey);
        tecgraf.openbus.data_service.core.v1_02.DataKeyWrapper dataKeyV1_02 = null;
        try {
            fKeyV1_02 = DataBridge.convertDataKeyToV1_02(fKey);
            dataKeyV1_02 = new tecgraf.openbus.data_service.core.v1_02.DataKeyWrapper(fKeyV1_02);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e2) {
            throw new InvalidDataKey((byte[][])new byte[][]{fKey});
        }
        try {
            file = csbase.server.services.projectservice.v1_02.ProjectDataService.getProjectFile(dataKeyV1_02);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
            throw new InvalidDataKey((byte[][])new byte[][]{fKey});
        }
        catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e1) {
            throw new ServiceFailure(e1.fMessage);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e1) {
            throw new DataNotFound((byte[][])new byte[][]{fKey});
        }
        catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e1) {
            throw new DataAccessDenied((byte[][])new byte[][]{fKey});
        }
        DataKeyWrapper sourceDataKey = new DataKeyWrapper(fSourceKey);
        OpenBusService.getInstance().joinChain();
        if (dataKey.getSystemDeploymentId().equals(sourceDataKey.getSystemDeploymentId()) && dataKey.getDataSourceId().equals(sourceDataKey.getDataSourceId()) && dataKey.getDataId().equals(sourceDataKey.getDataId())) {
            return;
        }
        IDataService sourceDataService = FindService.find(sourceDataKey);
        if (sourceDataService == null) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao copiar o dado: servi\u00e7o de dados da origem n\u00e3o dispon\u00edvel: {1} {2}", userLogin, sourceDataKey.getSystemDeploymentId(), sourceDataKey.getDataSourceId());
            Server.logSevereMessage(msg);
            throw new UnavailableDataService(msg);
        }
        try {
            sourceView = (UnstructuredDataView)UnstructuredDataView.class.cast(sourceDataService.getDataView(sourceDataKey.getKey(), UnstructuredDataViewHelper.id()));
        }
        catch (UnsupportedView e) {
            throw new AbsentViews(e.fKeys, new String[]{UnstructuredDataViewHelper.id()});
        }
        UnstructuredDataView view = null;
        try {
            csbase.server.services.projectservice.v1_02.ProjectDataService dataServicev1_02 = csbase.server.services.projectservice.v1_02.ProjectDataService.getInstance();
            tecgraf.openbus.data_service.core.v1_02.UnstructuredDataView viewV1_02 = null;
            try {
                viewV1_02 = (tecgraf.openbus.data_service.core.v1_02.UnstructuredDataView)tecgraf.openbus.data_service.core.v1_02.UnstructuredDataView.class.cast(dataServicev1_02.getDataView(fKeyV1_02, DataBridge.convertInterfaceNameToV1_02(UnstructuredDataViewHelper.id())));
            }
            catch (UnsupportedView e) {
                String userLogin = Service.getUser().getLogin();
                String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: erro ao converter UnstructuredDataView.", userLogin, dataKey.getDataId());
                Server.logSevereMessage(msg, e);
                throw new ServiceFailure(msg);
            }
            view = (UnstructuredDataView)UnstructuredDataView.class.cast(DataBridge.convertDataViewToV1_01((tecgraf.openbus.data_service.core.v1_02.DataView)viewV1_02));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.UnsupportedView e) {
            throw new AbsentViews((byte[][])new byte[][]{fKey}, new String[]{UnstructuredDataViewHelper.id()});
        }
        catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
            throw new ServiceFailure(e.fMessage);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
            throw new DataAccessDenied((byte[][])new byte[][]{fKey});
        }
        catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
            throw new DataNotFound((byte[][])new byte[][]{fKey});
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
            throw new InvalidDataKey((byte[][])new byte[][]{fKey});
        }
        try {
            channel = new SyncRemoteFileChannel(dataKey.getDataId().getBytes("UTF8"), view.fWritable, view.fHost, view.fPort, view.fAccessKey);
        }
        catch (UnsupportedEncodingException e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: erro ao converter o identificador do dado de destino ({1}) para bytes.", userLogin, dataKey.getDataId());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        try {
            sourceChannel = new SyncRemoteFileChannel(sourceDataKey.getDataId().getBytes("UTF8"), sourceView.fWritable, sourceView.fHost, sourceView.fPort, sourceView.fAccessKey);
        }
        catch (UnsupportedEncodingException e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: erro ao converter o identificador do dado de origem ({1}) para bytes.", userLogin, sourceDataKey.getDataId());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        try {
            channel.open(false);
        }
        catch (PermissionException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new DataAccessDenied((byte[][])new byte[][]{fKey});
        }
        catch (FileNotFoundException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new DataNotFound((byte[][])new byte[][]{fKey});
        }
        catch (FailureException e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: falha na transfer\u00eancia do arquivo: {1}", userLogin, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (MaxClientsReachedException e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: quantidade m\u00e1xima de clientes atingida: {1}", userLogin, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        try {
            sourceChannel.open(true);
        }
        catch (PermissionException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new DataAccessDenied((byte[][])new byte[][]{fSourceKey});
        }
        catch (FileNotFoundException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new DataNotFound((byte[][])new byte[][]{fSourceKey});
        }
        catch (FailureException e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: falha na transfer\u00eancia do arquivo: {1}", userLogin, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (MaxClientsReachedException e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: quantidade m\u00e1xima de clientes atingida: {1}", userLogin, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        try {
            ProjectItemDataView sourceProjectView = (ProjectItemDataView)sourceDataService.getDataView(sourceDataKey.getKey(), ProjectItemDataViewHelper.id());
            channel.syncTransferFrom((RemoteFileChannel)sourceChannel, 0L, sourceProjectView.fSize);
        }
        catch (PermissionException e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: arquivo aberto somente para escrita: {1}", userLogin, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (FailureException e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: falha na transfer\u00eancia do arquivo: {1}", userLogin, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (FileLockedException e) {
            String userLogin = Service.getUser().getLogin();
            String msg = MessageFormat.format("Ocorreu um erro na solicita\u00e7\u00e3o do usu\u00e1rio {0}: error ao atualizar o dado: arquivo bloqueado para escrita: {1}", userLogin, e.getMessage());
            Server.logSevereMessage(msg, e);
            throw new ServiceFailure(msg);
        }
        catch (UnsupportedView e) {
            throw new AbsentViews(e.fKeys, new String[]{ProjectItemDataViewHelper.id()});
        }
        finally {
            block63: {
                OpenBusService.getInstance().exitChain();
                channel.close();
                try {
                    sourceChannel.close();
                }
                catch (FailureException e) {}
                break block63;
                catch (FailureException e) {
                    try {
                        sourceChannel.close();
                    }
                    catch (FailureException e2) {}
                    catch (Throwable throwable) {
                        try {
                            sourceChannel.close();
                        }
                        catch (FailureException e3) {}
                        throw throwable;
                    }
                }
            }
        }
        if (!ProjectService.getInstance().setUpdatableFileInfo(file, new UpdatableFileInfo(OpenBusProjectFileUpdater.class, (Serializable)sourceDataKey.getKey()))) {
            Server.logWarningMessage(MessageFormat.format("A informa\u00e7\u00e3o sobre atualiza\u00e7\u00e3o do arquivo {0} n\u00e3o foi definida", file.getStringPath()));
        }
    }

    public void updateDataFrom(Object projectId, String[] pathArray, byte[] fSourceKey) throws ServiceFailure, DataAccessDenied, InvalidDataKey, DataNotFound, UnavailableDataService, AbsentViews {
        String dataId = ProjectDataService.generateDataId(projectId, pathArray);
        DataKeyWrapper dataKey = this.generateDataKey(dataId);
        this.updateDataFrom(dataKey.getKey(), fSourceKey);
    }

    private static Metadata[] createMetadataList(String absolutePath) {
        ArrayList<Metadata> metadataList = new ArrayList<Metadata>();
        org.omg.CORBA.ORB orb = OpenBusService.getInstance().getORB();
        if (absolutePath != null) {
            Any any = orb.create_any();
            any.insert_string(absolutePath);
            metadataList.add(new Metadata(ABSOLUTE_PATH_METADATUM_NAME, any));
        }
        return metadataList.toArray(new Metadata[0]);
    }

    private static String generateDataId(Object projectId, String[] pathArray) {
        String dataId = (String)projectId;
        for (String path : pathArray) {
            dataId = dataId + "@/@" + path;
        }
        return dataId;
    }

    private DataKeyWrapper generateDataKey(String dataId) throws InvalidDataKey {
        String systemDeploymentId = OpenBusService.getInstance().getEntityName();
        DataKeyWrapper dataKey = new DataKeyWrapper(systemDeploymentId, this.SourceId, dataId);
        return dataKey;
    }
}

