/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.logic.EncryptedPassword;
import csbase.logic.PreLoginData;
import csbase.logic.ServerURI;
import csbase.logic.Session;
import csbase.logic.UserOutline;
import csbase.logic.Version;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.remote.HttpServiceInterface;
import csbase.remote.ServerEntryPoint;
import csbase.remote.ServiceInterface;
import csbase.server.Server;
import csbase.server.ServiceManager;
import csbase.server.keystore.CSKeyStore;
import csbase.server.services.httpservice.HttpService;
import csbase.server.services.loginservice.LoginService;
import csbase.util.rmi.Pingable;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class ServerEntryPointImpl
extends Pingable
implements ServerEntryPoint {
    private static final String SERVER_PORT_PARAM = "server_port";
    private static final String PAGE_PARAM = "page";
    private static final String PAGE_SUFFIX = ".jnlp";

    public boolean canChangePasswords() {
        LoginService loginService = LoginService.getInstance();
        return loginService.canChangePasswords();
    }

    public HttpServiceInterface fetchHttpService() {
        HttpService httpService = HttpService.getInstance();
        return httpService;
    }

    public <T extends ServiceInterface> T fetchService(Object sessionKey, String serviceName) {
        ServiceManager serviceManager = ServiceManager.getInstance();
        return (T)serviceManager.getRemoteService(sessionKey, serviceName);
    }

    public Map<String, ServiceInterface> fetchServices(Object sessionKey, Set<String> servicesNames) {
        ServiceManager serviceManager = ServiceManager.getInstance();
        return serviceManager.getRemoteServices(sessionKey, servicesNames);
    }

    private String generateSystemURL(String token, Locale locale) {
        return this.generateSystemURL(token, locale, null);
    }

    private String generateSystemURL(String token, Locale locale, String systemName) {
        String LOCALE_PARAM = "locale";
        String TOKEN_PARAM = "token";
        String url = Server.getInstance().getSystemURL();
        String port = Integer.toString(Server.getInstance().getRegistryPort());
        url = MessageFormat.format("{0}?{1}={2}", url, SERVER_PORT_PARAM, port);
        url = MessageFormat.format("{0}&{1}={2}", url, "token", token);
        url = MessageFormat.format("{0}&{1}={2}", url, "locale", locale);
        if (systemName != null) {
            url = MessageFormat.format("{0}&{1}={2}{3}", url, PAGE_PARAM, systemName, PAGE_SUFFIX);
        }
        return url;
    }

    public UserOutline[] getLoggedUsers() {
        LoginService loginService = LoginService.getInstance();
        return loginService.getLoggedUsers();
    }

    public String getSystemName() {
        Server server = Server.getInstance();
        String serverName = server.getSystemName();
        return serverName;
    }

    public String getSystemURLWithRMIPort() {
        Server server = Server.getInstance();
        String url = server.getSystemURL();
        int port = server.getRegistryPort();
        String portTxt = Integer.toString(port);
        Object[] args = new Object[]{url, SERVER_PORT_PARAM, portTxt};
        url = MessageFormat.format("{0}?{1}={2}", args);
        return url;
    }

    public String getSystemURLWithRMIPort(String systemName) {
        if (systemName == null) {
            throw new IllegalArgumentException("systemName = null");
        }
        if (systemName.trim().equals("")) {
            throw new IllegalArgumentException("systemName vazio");
        }
        String url = this.getSystemURLWithRMIPort();
        url = MessageFormat.format("{0}&{1}={2}{3}", url, PAGE_PARAM, systemName, PAGE_SUFFIX);
        return url;
    }

    public String getVersionName() {
        Version version = Version.getInstance();
        return version.getName();
    }

    public boolean isLocalLogin() {
        LoginService loginService = LoginService.getInstance();
        return loginService.isLocalLogin();
    }

    public Map<String, Serializable> isValidSession(Object sessionKey, String serverName, byte[] signedServerName) {
        if (sessionKey == null || serverName == null || signedServerName == null) {
            throw new IllegalArgumentException("sessionKey == null || serverName == null || signedServerName == null");
        }
        try {
            CSKeyStore keyStore = CSKeyStore.getInstance();
            if (keyStore == null) {
                String msg = "O reposit\u00f3rio de chaves/certificados n\u00e3o existe. Sess\u00e3o n\u00e3o validada.";
                Server.logWarningMessage("O reposit\u00f3rio de chaves/certificados n\u00e3o existe. Sess\u00e3o n\u00e3o validada.");
                return null;
            }
            if (!keyStore.containsAlias(serverName)) {
                String fmt = "O servidor %s n\u00e3o possui certificado cadastrado. Sess\u00e3o n\u00e3o validada.";
                String message = String.format("O servidor %s n\u00e3o possui certificado cadastrado. Sess\u00e3o n\u00e3o validada.", serverName);
                Server.logWarningMessage(message);
                return null;
            }
            if (!keyStore.verify(serverName, serverName, signedServerName)) {
                String fmt = "A assinatura do servidor %s est\u00e1 inv\u00e1lida. Sess\u00e3o n\u00e3o validada.";
                String message = String.format("A assinatura do servidor %s est\u00e1 inv\u00e1lida. Sess\u00e3o n\u00e3o validada.", serverName);
                Server.logWarningMessage(message);
                return null;
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro validando sess\u00e3o .");
            return null;
        }
        LoginService loginService = LoginService.getInstance();
        if (loginService.isValidSession(sessionKey)) {
            return loginService.getSessionAttributes(sessionKey);
        }
        return null;
    }

    public Session login(ServerURI referedServerURI, Map<String, Serializable> attr, boolean copyServerSessionAttrs, Object sessionkey, String login, String delegatedLogin, Locale locale, TimeZone tz) {
        LoginService loginService = LoginService.getInstance();
        return loginService.login(referedServerURI, attr, copyServerSessionAttrs, sessionkey, login, delegatedLogin, locale, tz);
    }

    public Session login(String token) {
        LoginService loginService = LoginService.getInstance();
        return loginService.login(token);
    }

    public Session login(String localServerName, byte[] signedLocalServerName, Locale locale) {
        LoginService loginService = LoginService.getInstance();
        return loginService.login(localServerName, signedLocalServerName, locale);
    }

    public Session login(String login, EncryptedPassword encryptedPassword, Locale locale) {
        LoginService loginService = LoginService.getInstance();
        return loginService.login(login, encryptedPassword, locale);
    }

    public Session login(String login, EncryptedPassword encryptedPassword, Locale locale, String delegatedLogin) {
        LoginService loginService = LoginService.getInstance();
        return loginService.login(login, encryptedPassword, locale, delegatedLogin);
    }

    public Session login(String login, EncryptedPassword encryptedPassword, Locale locale, TimeZone timeZone) {
        LoginService loginService = LoginService.getInstance();
        return loginService.login(login, encryptedPassword, locale, timeZone);
    }

    public Session login(String login, EncryptedPassword encryptedPassword, Locale locale, TimeZone tz, String delegatedLogin) {
        LoginService loginService = LoginService.getInstance();
        return loginService.login(login, encryptedPassword, locale, delegatedLogin, tz, null);
    }

    public Session login(String login, EncryptedPassword encryptedPassword, Locale locale, TimeZone tz, String delegatedLogin, Map<String, Serializable> params) {
        LoginService loginService = LoginService.getInstance();
        return loginService.login(login, encryptedPassword, locale, delegatedLogin, tz, params);
    }

    public Session login(String token, TimeZone timeZone) {
        LoginService loginService = LoginService.getInstance();
        return loginService.login(token, timeZone);
    }

    public Session login(OpenBusLoginToken token, Locale locale, TimeZone timeZone) {
        LoginService loginService = LoginService.getInstance();
        return loginService.login(token, locale, timeZone);
    }

    public void logout(Object sessionKey) {
        LoginService loginService = LoginService.getInstance();
        loginService.logout(sessionKey);
    }

    public PreLoginData preLogin(String login, String password, Locale locale) {
        LoginService loginService = LoginService.getInstance();
        PreLoginData data = loginService.preLogin(login, password, locale);
        if (data == null) {
            return null;
        }
        String token = data.getToken();
        try {
            String urlText = this.generateSystemURL(token, locale);
            URL url = new URL(urlText);
            data.setUrl2Login(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        return data;
    }

    public PreLoginData preLogin(String login, String password, Locale locale, Map<String, Serializable> attributes) {
        LoginService loginService = LoginService.getInstance();
        PreLoginData data = loginService.preLogin(login, password, locale, attributes);
        if (data == null) {
            return null;
        }
        String token = data.getToken();
        try {
            String urlText = this.generateSystemURL(token, locale);
            URL url = new URL(urlText);
            data.setUrl2Login(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        return data;
    }

    public PreLoginData preLogin(String login, String password, Locale locale, String delegatedLogin, Remote control, Serializable userData) {
        LoginService loginService = LoginService.getInstance();
        PreLoginData data = loginService.preLogin(login, password, locale, delegatedLogin, control, userData);
        if (data == null) {
            return null;
        }
        String token = data.getToken();
        try {
            String urlText = this.generateSystemURL(token, locale);
            URL url = new URL(urlText);
            data.setUrl2Login(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        return data;
    }

    public String preLogin2Web(String login, String password, Locale locale) {
        LoginService loginService = LoginService.getInstance();
        PreLoginData data = loginService.preLogin(login, password, locale);
        if (data == null) {
            return null;
        }
        String token = data.getToken();
        return this.generateSystemURL(token, locale);
    }

    public String preLogin2Web(String login, String password, Locale locale, Map<String, Serializable> attributes) {
        LoginService loginService = LoginService.getInstance();
        PreLoginData data = loginService.preLogin(login, password, locale, attributes);
        if (data == null) {
            return null;
        }
        String token = data.getToken();
        return this.generateSystemURL(token, locale);
    }

    public String preLogin2Web(String login, String password, Locale locale, String systemName) {
        LoginService loginService = LoginService.getInstance();
        PreLoginData data = loginService.preLogin(login, password, locale);
        if (data == null) {
            return null;
        }
        String token = data.getToken();
        return this.generateSystemURL(token, locale, systemName);
    }

    public String preLogin2Web(String login, String password, Locale locale, String delegatedLogin, String systemName) {
        LoginService loginService = LoginService.getInstance();
        PreLoginData data = loginService.preLogin(login, password, locale, delegatedLogin);
        if (data == null) {
            return null;
        }
        String token = data.getToken();
        return this.generateSystemURL(token, locale, systemName);
    }

    public void setServerSessionProperty(Object sessionKey, String propertyName, Serializable propertyValue) {
        LoginService loginService = LoginService.getInstance();
        if (propertyValue == null) {
            loginService.removeSessionProperty(sessionKey, propertyName);
        } else {
            loginService.setSessionProperty(sessionKey, propertyName, propertyValue);
        }
    }

    public void setSystemName(Object sessionKey, String systemName) {
        LoginService loginService = LoginService.getInstance();
        loginService.setSystemName(sessionKey, systemName);
    }

    public final String getSystemDefaultCharsetName() {
        Server server = Server.getInstance();
        return server.getSystemDefaultCharsetName();
    }

    public PublicKey getPublicKey() {
        return LoginService.getInstance().getPublicKey();
    }
}

