/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.filetransferservice.ftp;

import csbase.exception.ServiceFailureException;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferElement;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.server.services.filetransferservice.FileTransferJob;
import csbase.server.services.filetransferservice.FileTransferProtocolStub;
import csbase.server.services.filetransferservice.ftp.FTPDownloadJob;
import csbase.server.services.filetransferservice.ftp.FTPUploadJob;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;

public class FTPStub
implements FileTransferProtocolStub {
    @Override
    public boolean checkConnection(FileTransferConnection connection) throws ServiceFailureException {
        FTPClient ftp = new FTPClient();
        try {
            String server = connection.getServerName();
            String user = connection.getUserName();
            String password = connection.getPassword();
            ftp.connect(server);
            boolean loginOk = ftp.login(user, password);
            return loginOk;
        }
        catch (Exception e) {
            try {
                if (ftp.isConnected()) {
                    ftp.disconnect();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new ServiceFailureException(e.getMessage());
        }
    }

    @Override
    public FileTransferJob createDownloadJob(FileTransferRequest request) throws ServiceFailureException {
        FTPDownloadJob job = new FTPDownloadJob(request);
        return job;
    }

    @Override
    public List<FileTransferElement> listContent(FileTransferConnection connection, String remoteDirPath) throws ServiceFailureException {
        FTPClient ftp = new FTPClient();
        try {
            FTPFile[] content;
            String server = connection.getServerName();
            String user = connection.getUserName();
            String password = connection.getPassword();
            ftp.connect(server);
            boolean loginOk = ftp.login(user, password);
            if (!loginOk) {
                throw new Exception("Bad login");
            }
            ftp.enterLocalPassiveMode();
            ftp.setFileType(0);
            String systemName = ftp.getSystemName();
            if (systemName == null) {
                String UNIX = "UNIX";
                FTPClientConfig config = new FTPClientConfig("UNIX");
                ftp.configure(config);
            }
            String rDir = remoteDirPath;
            if (remoteDirPath.equals("/")) {
                ftp.changeWorkingDirectory("/");
                content = ftp.listFiles();
            } else {
                content = remoteDirPath.equals("") ? ftp.listFiles() : ftp.listFiles(rDir);
            }
            ArrayList<FileTransferElement> list = new ArrayList<FileTransferElement>();
            for (FTPFile f : content) {
                String name;
                if (f == null || (name = f.getName()).equals("..") || name.equals(".")) continue;
                boolean isDir = f.isDirectory();
                long size = f.getSize();
                boolean isLink = f.isSymbolicLink();
                FileTransferElement ftpFile = new FileTransferElement(name, isDir, size, isLink);
                list.add(ftpFile);
            }
            ftp.logout();
            ftp.disconnect();
            return list;
        }
        catch (Exception e) {
            try {
                if (ftp.isConnected()) {
                    ftp.disconnect();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new ServiceFailureException(e.getMessage());
        }
    }

    @Override
    public FileTransferJob createUploadJob(FileTransferRequest request) throws ServiceFailureException {
        FTPUploadJob job = new FTPUploadJob(request);
        return job;
    }
}

