/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.server.Server;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ServerUtilities {
    public static void removeFile(File file, boolean removeRoot) throws Exception {
        File[] children;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (children = file.listFiles()) != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                ServerUtilities.removeFile(children[i], true);
                ++i;
            }
        }
        if (removeRoot && !file.delete()) {
            throw new Exception("Falha na remo\u00e7\u00e3o de " + file.getPath());
        }
    }

    public static boolean copyStream(InputStream in, OutputStream out, boolean closeInput, boolean closeOutput) {
        BufferedInputStream bin = new BufferedInputStream(in);
        BufferedOutputStream bout = new BufferedOutputStream(out);
        byte[] data = new byte[1024];
        try {
            int num;
            while ((num = bin.read(data, 0, 1024)) != -1) {
                bout.write(data, 0, num);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (closeInput) {
                try {
                    bin.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (closeOutput) {
                try {
                    bout.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public static void removeNull(String[][] minfo) {
        int i = 0;
        while (i < minfo.length) {
            if (minfo[i][1] == null || minfo[i][1].equals("")) {
                minfo[i][1] = "-";
            }
            ++i;
        }
    }

    public static String format(String[] items) {
        StringBuffer result = new StringBuffer();
        result.append(items[0]);
        int execCount = items.length;
        int i = 1;
        while (i < execCount - 1) {
            result.append(", ");
            result.append(items[i]);
            ++i;
        }
        if (execCount > 1) {
            result.append(" " + Server.getInstance().getString("server.util.and") + " ");
            result.append(items[execCount - 1]);
        }
        return result.toString();
    }
}

