/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.logic.MDigest;
import csbase.logic.Permission;
import csbase.logic.Role;
import csbase.logic.User;
import csbase.logic.UserInfo;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.services.administrationservice.AdministrationService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tecgraf.javautils.core.io.FileUtils;

public class UserIO {
    private static String USERS_EXTENSION = ".dat";
    private volatile boolean isReadingAll = false;

    public UserIO() {
        this.createAdmin();
    }

    private final String getPersistencyUsersDirectoryName() {
        Server server = Server.getInstance();
        String persistDirPath = server.getPersistencyRootDirectoryName();
        String userDirPath = String.valueOf(persistDirPath) + File.separator + "users";
        try {
            Server.checkDirectory(userDirPath);
        }
        catch (ServerException e) {
            String err = "Falha de cria\u00e7\u00e3o de diret\u00f3rio: " + userDirPath;
            throw new IllegalStateException(err);
        }
        return userDirPath;
    }

    private void createAdmin() {
        String usersDirPath = this.getPersistencyUsersDirectoryName();
        String adminFileName = String.valueOf(usersDirPath) + File.separator + User.getAdminId() + USERS_EXTENSION;
        if (new File(adminFileName).exists()) {
            return;
        }
        UserInfo info = new UserInfo((String)User.getAdminId(), "Administrador", new String[0], null, null, 0L);
        try {
            info.setAttribute("password", (Object)"1234");
            this.write(info);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro criando conta admin!");
            Server.getInstance().shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new UserIO().printDataFile();
    }

    public void printDataFile() throws Exception {
        Vector<User> users = this.readAll();
        Enumeration<User> e = users.elements();
        while (e.hasMoreElements()) {
            User user = e.nextElement();
            System.out.println(user);
        }
    }

    private void checkPassword(UserInfo info) throws Exception {
        String password = (String)info.getAttribute("password");
        if (info.getAttribute("passwordDigest") == null && password == null) {
            throw new Exception("senha n\u00e3o pode ser vazia");
        }
        if (password != null) {
            info.setAttribute("passwordDigest", (Object)MDigest.getDigest((String)password));
            info.removeAttribute("password");
        }
    }

    public synchronized User write(UserInfo info) throws Exception {
        this.checkPassword(info);
        String login = info.getLogin();
        long current = Calendar.getInstance().getTimeInMillis();
        info.setAttribute("lastUpdate", (Object)new Long(current));
        User user = new User((Object)login, info);
        Hashtable attributes = info.getAttributes();
        String usersDirPath = this.getPersistencyUsersDirectoryName();
        String fileName = String.valueOf(usersDirPath) + File.separator + login + USERS_EXTENSION;
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName))));
            out.writeObject(attributes);
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close((Closeable)out);
        return user;
    }

    public synchronized void delete(Object id) throws Exception {
        User user = User.getUser((Object)id);
        if (user == null) {
            return;
        }
        String usersDirPath = this.getPersistencyUsersDirectoryName();
        File file = new File(String.valueOf(usersDirPath) + File.separator + id + USERS_EXTENSION);
        if (!file.exists()) {
            throw new Exception("N\u00e3o existe o arquivo do usu\u00e1rio " + id);
        }
        if (!file.delete()) {
            throw new Exception("N\u00e3o foi poss\u00edvel remover o arquivo do usu\u00e1rio " + id);
        }
    }

    public synchronized User read(Object id) throws Exception {
        for (User user : User.getAllUsers()) {
            if (!user.getId().equals(id)) continue;
            return user;
        }
        return null;
    }

    public synchronized Vector<User> readAll() throws Exception {
        String usersDirPath = this.getPersistencyUsersDirectoryName();
        if (this.isReadingAll) {
            return null;
        }
        this.isReadingAll = true;
        Vector<User> users = new Vector<User>();
        try {
            File[] userFiles;
            File usersDirectory = new File(usersDirPath);
            File[] fileArray = userFiles = usersDirectory.listFiles();
            int n = userFiles.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    File userFile = fileArray[n2];
                    ObjectInputStream in = null;
                    try {
                        try {
                            in = new ObjectInputStream(new DataInputStream(new BufferedInputStream(new FileInputStream(userFile))));
                            Hashtable attributes = (Hashtable)in.readObject();
                            in.close();
                            UserInfo info = new UserInfo(attributes);
                            this.checkPermissions(info);
                            this.checkRoles(info);
                            User user = new User((Object)info.getLogin(), info);
                            users.add(user);
                        }
                        catch (Exception e) {
                            AdministrationService srv = AdministrationService.getInstance();
                            Server.logSevereMessage("Erro na leitura do arquivo do usu\u00e1rio " + userFile.getName());
                            FileUtils.close((Closeable)in);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(in);
                        throw throwable;
                    }
                    FileUtils.close((Closeable)in);
                }
                ++n2;
            }
        }
        finally {
            this.isReadingAll = false;
        }
        return users;
    }

    private void checkPermissions(UserInfo info) {
        Object[] ids = (Object[])info.getAttribute("permissionIds");
        int lostPermissions = 0;
        int i = 0;
        while (i < ids.length) {
            Permission p = null;
            try {
                p = Permission.getPermission((Object)ids[i]);
            }
            catch (Exception e) {
                Server.logSevereMessage("Erro ao obter permiss\u00e3o " + ids[i], e);
            }
            if (p == null) {
                Server.logSevereMessage("Permiss\u00e3o inexistente sendo removida do usu\u00e1rio " + info.getLogin() + ": " + ids[i]);
                ids[i] = null;
                ++lostPermissions;
            }
            ++i;
        }
        if (lostPermissions > 0) {
            Object[] newIds = new Object[ids.length - lostPermissions];
            int n = 0;
            int i2 = 0;
            while (i2 < ids.length) {
                if (ids[i2] != null) {
                    newIds[n++] = ids[i2];
                }
                ++i2;
            }
            info.setAttribute("permissionIds", (Object)newIds);
            try {
                Server.logInfoMessage("Usu\u00e1rio " + info.getLogin() + " sendo persistido " + "apenas com as permiss\u00f5es v\u00e1lidas");
                this.write(info);
            }
            catch (Exception e) {
                Server.logSevereMessage("O usu\u00e1rio " + info.getLogin() + " possui permiss\u00e3o inexistente. N\u00e3o foi poss\u00edvel persist\u00ed-lo " + " com apenas as permiss\u00f5es v\u00e1lidas.");
            }
        }
    }

    private void checkRoles(UserInfo info) {
        Object[] ids = (Object[])info.getAttribute("roleIds");
        int lostRoles = 0;
        int i = 0;
        while (i < ids.length) {
            Role r = null;
            try {
                r = Role.getRole((Object)ids[i]);
            }
            catch (Exception e) {
                Server.logSevereMessage("Erro ao obter perfil " + ids[i], e);
            }
            if (r == null) {
                Server.logSevereMessage("Perfil inexistente sendo removido do usu\u00e1rio " + info.getLogin() + ": " + ids[i]);
                ids[i] = null;
                ++lostRoles;
            }
            ++i;
        }
        if (lostRoles > 0) {
            Object[] newIds = new Object[ids.length - lostRoles];
            int n = 0;
            int i2 = 0;
            while (i2 < ids.length) {
                if (ids[i2] != null) {
                    newIds[n++] = ids[i2];
                }
                ++i2;
            }
            info.setAttribute("roleIds", (Object)newIds);
            try {
                Server.logInfoMessage("Usu\u00e1rio sendo persistido apenas com os perfis v\u00e1lidos");
                this.write(info);
            }
            catch (Exception e) {
                Server.logSevereMessage("O usu\u00e1rio " + info.getAttribute("login") + " possui perfil inexistente. N\u00e3o foi poss\u00edvel persist\u00ed-lo " + " com apenas os perfis v\u00e1lidos.");
            }
        }
    }
}

