/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.commandpersistenceservice;

import csbase.logic.ClientProjectFile;
import csbase.logic.UserProjectInfo;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.projectservice.ProjectService;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;

class CommandPersistenceCleanupThread
extends Thread {
    private static final String CLEANUP_HOUR_PROPERTY = "cleanup.hour";
    private static final String EXPIRATION_MAX_DAYS = "cleanup.maxDays";
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private final String CMDS_DIR_NAME;
    private int maxDays = 0;
    private int cleanupHour = 0;
    private volatile boolean quit = false;

    CommandPersistenceCleanupThread() throws ServerException {
        super(CommandPersistenceCleanupThread.class.getSimpleName());
        CommandPersistenceService cmdPersService = CommandPersistenceService.getInstance();
        this.CMDS_DIR_NAME = cmdPersService.getCommandsDirectoryName();
        this.maxDays = cmdPersService.getIntProperty(EXPIRATION_MAX_DAYS);
        if (this.maxDays < 0) {
            throw new ServerException(String.format("%s deve ser >= 0 [%d].", EXPIRATION_MAX_DAYS, this.maxDays));
        }
        if (this.maxDays > 0) {
            this.cleanupHour = cmdPersService.getIntProperty(CLEANUP_HOUR_PROPERTY);
            if (this.cleanupHour < 0 || this.cleanupHour > 23) {
                throw new ServerException("cleanup.hour deve estar no intervalo [0, 23].");
            }
        } else {
            Server.logInfoMessage(String.format("Thread de limpeza desativada (%s.%s = 0)", "CommandPersistenceService", EXPIRATION_MAX_DAYS));
        }
    }

    @Override
    public void run() {
        if (this.maxDays == 0) {
            return;
        }
        Server.logInfoMessage("Thread de limpeza iniciada.");
        Server.logInfoMessage(String.format("Hora para cleanup: %dh.", this.cleanupHour));
        Server.logInfoMessage("Comandos com mais de " + this.maxDays + " dias ser\u00e3o removidos.");
        this.doCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup() {
        try {
            while (!this.quit) {
                CommandPersistenceCleanupThread commandPersistenceCleanupThread = this;
                synchronized (commandPersistenceCleanupThread) {
                    this.wait(this.getWaitDelta());
                    this.removeExpiredFiles();
                }
            }
        }
        catch (InterruptedException e) {
            Server.logInfoMessage("Thread de limpeza interrompida.");
        }
        Server.logInfoMessage("Thread de limpeza encerrada.");
    }

    private void removeExpiredFiles() {
        Server.logInfoMessage("Iniciando limpeza de comandos expirados.");
        ProjectService projectService = ProjectService.getInstance();
        AdministrationService adminService = AdministrationService.getInstance();
        Set<Object> usersId = adminService.getAllUserIds();
        String[] filePath = new String[]{this.CMDS_DIR_NAME};
        try {
            for (Object userId : usersId) {
                Service.setUserId(userId);
                List<UserProjectInfo> projects = projectService.getProjectsFromUser(userId);
                for (UserProjectInfo project : projects) {
                    Object projectId = project.getProjectId();
                    this.cleanupCmdsDir(projectId, filePath, userId);
                }
            }
        }
        finally {
            Service.setUserId(null);
        }
        Server.logInfoMessage("Limpeza de comandos expirados terminada.");
    }

    private void cleanupCmdsDir(Object projectId, String[] cmdsPath, Object userId) {
        ClientProjectFile[] cmds;
        ProjectService projectService = ProjectService.getInstance();
        if (!projectService.existsFile(projectId, cmdsPath)) {
            return;
        }
        long maxMillis = (long)this.maxDays * 86400000L;
        long expirationDate = Calendar.getInstance().getTimeInMillis() - maxMillis;
        ClientProjectFile[] clientProjectFileArray = cmds = projectService.getChildren(projectId, cmdsPath);
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            ClientProjectFile cmd = clientProjectFileArray[n2];
            if (cmd.getModificationDate() < expirationDate) {
                projectService.removeFile(projectId, cmd.getPath());
                Server.logInfoMessage("Diret\u00f3rio " + cmd.getName() + " do usu\u00e1rio " + userId + " removido.");
            }
            ++n2;
        }
    }

    synchronized void shutdown() {
        this.quit = true;
        Server.logInfoMessage("Shutdown da thread de limpeza solicitado.");
        this.interrupt();
    }

    private long getWaitDelta() {
        Calendar now = Calendar.getInstance();
        Calendar cleanupTime = Calendar.getInstance();
        cleanupTime.set(11, this.cleanupHour);
        cleanupTime.set(12, 0);
        cleanupTime.set(13, 0);
        if (now.after(cleanupTime)) {
            int day = cleanupTime.get(5);
            cleanupTime.set(5, day + 1);
        }
        return cleanupTime.getTimeInMillis() - now.getTimeInMillis();
    }

    public static void main(String[] args) {
        File dir = new File("/tmp/sgacleanup");
        Date lastModified = new Date(dir.lastModified());
        System.out.println(lastModified.toString());
    }
}

