/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.dbmanagerservice;

import csbase.remote.DBManagerServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.dbmanagerservice.DBPool;
import csbase.server.services.dbmanagerservice.Pool;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.WeakHashMap;

public class DBManagerService
extends Service
implements DBManagerServiceInterface {
    private final Hashtable<String, Pool> pools = new Hashtable();
    private final WeakHashMap<Connection, Pool> connMap = new WeakHashMap();
    private boolean moduleClosing = false;

    private String createKey(Class<?> clazz, String driver, String url, String user) {
        return String.format("%s:%s:%s:%s", clazz.getSimpleName(), driver, user, url);
    }

    private Pool createPool(Class<?> clazz, String driver, String url, String user, String password) {
        Pool p = null;
        try {
            Constructor<?> constructor = clazz.getConstructor(String.class);
            p = (Pool)constructor.newInstance(this.createKey(clazz, driver, url, user));
            if (driver != null) {
                p.setDriver(driver);
            }
            p.setUrl(url);
            p.setUser(user);
            p.setPassword(password);
            if (!p.init()) {
                Server.logSevereMessage("Erro ao inicializar o pool de conex\u00f5es : " + clazz.getName());
                return null;
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro instanciando pool.", e);
        }
        return p;
    }

    private void destroy() {
        Enumeration<Pool> elem = this.pools.elements();
        while (elem.hasMoreElements()) {
            Pool pool = elem.nextElement();
            pool.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection getConnection(Class<?> clazz, String driver, String url, String user, String password) {
        if (this.moduleClosing) {
            return null;
        }
        Pool pool = null;
        String key = this.createKey(clazz, driver, url, user);
        Hashtable<String, Pool> hashtable = this.pools;
        synchronized (hashtable) {
            pool = this.pools.get(key);
            if (pool == null) {
                Server.logInfoMessage("DBManagerService: criando Pool - " + clazz.getName() + " - " + key);
                pool = this.createPool(clazz, driver, url, user, password);
                if (pool == null) return null;
                this.pools.put(key, pool);
            }
        }
        pool.checkPassword(password);
        Connection c = pool.getConnection();
        WeakHashMap<Connection, Pool> weakHashMap = this.connMap;
        synchronized (weakHashMap) {
            if (c == null) return c;
            this.connMap.put(c, pool);
            return c;
        }
    }

    public Connection getConnection(String driver, String url, String user, String password) {
        return this.getConnection(DBPool.class, driver, url, user, password);
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    @Override
    public void initService() {
        this.moduleClosing = false;
    }

    public void releaseConnection(Connection conn) {
        this.releaseConnection(conn, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Connection conn, Statement stmt, ResultSet rset) {
        if (conn == null) {
            Server.logWarningMessage("Conex\u00e3o nula devolvida!");
            return;
        }
        Pool pool = null;
        WeakHashMap<Connection, Pool> weakHashMap = this.connMap;
        synchronized (weakHashMap) {
            pool = this.connMap.remove(conn);
        }
        if (pool != null) {
            pool.releaseConnection(conn, stmt, rset);
        } else {
            Server.logSevereMessage("Conex\u00e3o devolvida n\u00e3o pertence a nenhum pool!");
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void shutdownService() throws ServerException {
        this.moduleClosing = true;
        this.destroy();
    }

    public static void createService() throws ServerException {
        new DBManagerService();
    }

    public static DBManagerService getInstance() {
        String serviceName = "DBManagerService";
        return (DBManagerService)Service.getInstance("DBManagerService");
    }

    protected DBManagerService() throws ServerException {
        super("DBManagerService");
    }
}

