/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.dbmanagerservice;

import csbase.server.Server;
import csbase.server.ServerException;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Pool {
    protected String name;
    protected String url;
    protected String user;
    protected String password;
    protected String driver;
    private Properties properties = null;
    public Logger logger;

    public abstract void checkPassword(String var1);

    public abstract void destroy();

    public abstract Connection getConnection();

    public final String getDriver() {
        return this.driver;
    }

    public final int getIntProperty(String key) throws ServerException {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Erro lendo propriedade: " + key);
            throw new ServerException(e);
        }
    }

    public final Logger getLogger() {
        return this.logger;
    }

    public final long getLongProperty(String key) throws ServerException {
        try {
            return Long.parseLong(this.getProperty(key));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Erro lendo propriedade: " + key, e);
            throw new ServerException(e);
        }
    }

    public final String getName() {
        return this.name;
    }

    public final String getPassword() {
        return this.password;
    }

    public final Properties getProperties() {
        return this.properties;
    }

    public final String getProperty(String key) throws ServerException {
        String v = this.properties.getProperty(key);
        if (v == null) {
            this.logger.log(Level.SEVERE, "Erro lendo propriedade: " + key);
            throw new ServerException("Propriedade n\u00e3o encontrada: " + key);
        }
        return v;
    }

    public final String getUrl() {
        return this.url;
    }

    public final String getUser() {
        return this.user;
    }

    public abstract boolean init();

    public void initServiceLog() throws ServerException {
        try {
            this.logger = Logger.getLogger(this.getClass().getName());
        }
        catch (Exception e) {
            throw new ServerException(e);
        }
    }

    private void loadProperties(String propertyFileName) throws ServerException {
        this.properties = new Properties();
        try {
            FileInputStream in = new FileInputStream(propertyFileName);
            this.properties.load(in);
            in.close();
            Properties trimmedProps = new Properties();
            for (String string : this.properties.keySet()) {
                String v = this.properties.getProperty(string);
                trimmedProps.setProperty(string, v.trim());
            }
            this.properties = trimmedProps;
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro lendo " + propertyFileName, e);
            throw new ServerException(e);
        }
    }

    public abstract void releaseConnection(Connection var1, Statement var2, ResultSet var3);

    public abstract void releaseConnection(Connection var1, Statement var2, ResultSet var3, boolean var4);

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final void setUrl(String url) {
        this.url = url;
    }

    public final void setUser(String user) {
        this.user = user;
    }

    public Pool(String name) throws ServerException {
        this.name = name;
        this.initServiceLog();
        String propertyFileName = String.valueOf(Server.getPropertiesRootDirectoryName()) + File.separator + this.getClass().getSimpleName() + ".properties";
        this.loadProperties(propertyFileName);
        Server.logInfoMessage(this.properties.toString());
    }
}

