/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.eventlogservice;

import csbase.logic.User;
import csbase.logic.eventlogservice.LogsInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import tecgraf.javautils.parsers.csv.CsvParser;
import tecgraf.javautils.parsers.exception.MalformedInputException;

public class EventLogParser {
    private CsvParser csvParser;
    private LogsInfo info;
    protected static final DateFormat dateWriteFormat = new SimpleDateFormat("yyyy/MM/dd");

    public EventLogParser(Date startDate, Date endDate) {
        this.info = new LogsInfo(startDate, endDate);
        this.csvParser = new CsvParser();
    }

    public void parse(FileInputStream stream, Charset charset) throws IOException, MalformedInputException {
        String[][] lines = this.csvParser.parse((InputStream)stream, charset);
        if (lines == null) {
            return;
        }
        int i = 0;
        while (i < lines.length) {
            String[] line = lines[i];
            if (!line[0].startsWith("#") && line[0].trim().length() != 0) {
                try {
                    String user = line[2].trim();
                    if (!User.isAdmin((Object)user)) {
                        long time = Long.parseLong(line[0].trim());
                        String strDate = dateWriteFormat.format(time);
                        String operation = line[3].trim();
                        if (operation.equals("Aplicativo nativo lan\u00e7ado")) {
                            this.info.addLineApplication(strDate, line[6].trim(), line[4].trim());
                        } else if (operation.equals("login")) {
                            this.info.addLineLogin(strDate, line[2].trim());
                        } else if (operation.startsWith(String.valueOf(user) + "@")) {
                            this.info.addLineExecution(strDate, line[4].trim(), user);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public LogsInfo getInfo() {
        return this.info;
    }
}

