/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v1_06;

import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandNotification;
import csbase.logic.CommandSuccessNotification;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.server.Server;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import tecgraf.openbus.DRMAA.v1_06.ExitTimeoutException;
import tecgraf.openbus.DRMAA.v1_06.InvalidJobException;
import tecgraf.openbus.DRMAA.v1_06.JobInfo;
import tecgraf.openbus.opendreams.v1_06.FinalizationType;
import tecgraf.openbus.opendreams.v1_06.OpenDreamsJobInfo;
import tecgraf.openbus.opendreams.v1_06.OpenDreamsJobInfoImpl;

public class JobInfoQueue {
    public static final int NO_EXIT_CODE = 256;
    public static final long WAITING_TIMEOUT = 100L;
    private Map<String, OpenDreamsJobInfo> jobsSubmited = new Hashtable<String, OpenDreamsJobInfo>();

    public synchronized void jobSubmited(String jobId) {
        OpenDreamsJobInfo jobInfo = this.jobsSubmited.get(jobId);
        if (jobInfo == null) {
            jobInfo = new OpenDreamsJobInfoImpl();
            jobInfo.jobId = jobId;
            this.jobsSubmited.put(jobId, jobInfo);
        }
    }

    public synchronized void jobExit(CommandNotification cmdEvent) {
        ExtendedCommandFinalizationInfo finalizationInfo;
        String jobId = cmdEvent.getCommandId().toString();
        OpenDreamsJobInfo jobInfo = this.jobsSubmited.get(jobId);
        if (jobInfo == null) {
            jobInfo = new OpenDreamsJobInfoImpl();
            jobInfo.jobId = jobId;
            this.jobsSubmited.put(jobId, jobInfo);
        }
        ArrayList<String[]> resourceUsage = new ArrayList<String[]>();
        if (cmdEvent.getFinalizationInfo().getFinalizationType() == CommandFinalizationType.SUCCESS) {
            CommandSuccessNotification endNotification = (CommandSuccessNotification)cmdEvent;
            if (endNotification.getCPUTime() != null) {
                resourceUsage.add(new String[]{"cpu_time", endNotification.getCPUTime().toString()});
            }
            if (endNotification.getElapsedTime() != null) {
                resourceUsage.add(new String[]{"elapsed_time", endNotification.getElapsedTime().toString()});
            }
            if (endNotification.getUserTime() != null) {
                resourceUsage.add(new String[]{"user_time", endNotification.getUserTime().toString()});
            }
        }
        if (resourceUsage.size() > 0) {
            jobInfo.resourceUsage = (String[][])resourceUsage.toArray((T[])new String[resourceUsage.size()][]);
        }
        if (cmdEvent.getFinalizationInfo().getInfoType() == CommandFinalizationInfo.FinalizationInfoType.EXTENDED) {
            finalizationInfo = (ExtendedCommandFinalizationInfo)cmdEvent.getFinalizationInfo();
            jobInfo.guiltyNodeId = String.valueOf(finalizationInfo.getGuiltyNodeId());
        }
        jobInfo.hasExited = true;
        finalizationInfo = cmdEvent.getFinalizationInfo();
        if (finalizationInfo == null) {
            Server.logSevereMessage("A informa\u00e7\u00e3o de finalizacao do comando " + jobId + " n\u00e3o existe (null)");
            jobInfo.exitStatus = 256;
            jobInfo.finalizationType = FinalizationType.NO_FINALIZATION_INFO;
        } else {
            Integer exitCode = finalizationInfo.getExitCode();
            Server.logInfoMessage("A informa\u00e7\u00e3o de finalizacao do comando " + jobId + " possui exitCode=" + exitCode);
            jobInfo.exitStatus = exitCode == null ? 256 : exitCode;
            jobInfo.finalizationType = this.getFinalizationType(finalizationInfo.getFinalizationType());
        }
        jobInfo.wasAborted = cmdEvent.getFinalizationInfo().getFinalizationType().equals((Object)FinalizationType.KILLED);
        jobInfo.hasSignaled = false;
        jobInfo.terminatingSignal = "";
        jobInfo.hasCoreDump = false;
        this.notifyAll();
    }

    private FinalizationType getFinalizationType(CommandFinalizationType type) {
        switch (type) {
            case NOT_FINISHED: {
                return FinalizationType.NOT_FINISHED;
            }
            case UNKNOWN: {
                return FinalizationType.UNKNOWN;
            }
            case END: {
                return FinalizationType.END;
            }
            case SUCCESS: {
                return FinalizationType.SUCCESS;
            }
            case EXECUTION_ERROR: {
                return FinalizationType.EXECUTION_ERROR;
            }
            case FAILED: {
                return FinalizationType.FAILED;
            }
            case KILLED: {
                return FinalizationType.KILLED;
            }
            case LOST: {
                return FinalizationType.LOST;
            }
            case NO_EXIT_CODE: {
                return FinalizationType.NO_EXIT_CODE;
            }
        }
        return FinalizationType.UNDEFINED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo waitFor(String jobId, long timeout) throws InvalidJobException, ExitTimeoutException {
        JobInfoQueue jobInfoQueue = this;
        synchronized (jobInfoQueue) {
            JobInfo info = (JobInfo)this.jobsSubmited.get(jobId);
            if (info == null) {
                throw new InvalidJobException("N\u00e3o foi encontrado um job com o nome especificado: " + jobId);
            }
            if (timeout == 0L) {
                this.jobsSubmited.remove(jobId);
                return info;
            }
        }
        long limit = System.currentTimeMillis() * 1000L + timeout;
        long timeToGo = limit - System.currentTimeMillis() * 1000L;
        boolean waitForever = timeout == -1L;
        while (waitForever || timeToGo > 0L) {
            try {
                JobInfoQueue jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    this.wait(100L);
                }
                if (!waitForever) {
                    timeToGo = limit - System.currentTimeMillis() * 1000L;
                }
                jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    JobInfo info = (JobInfo)this.jobsSubmited.get(jobId);
                    if (info == null) {
                        throw new InvalidJobException("Outra requisi\u00e7\u00e3o j\u00e1 recebeu a informa\u00e7\u00e3o de t\u00e9rmino dessemesmo job: " + jobId);
                    }
                    if (info.hasExited) {
                        this.jobsSubmited.remove(jobId);
                        return info;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new ExitTimeoutException("O timeout esgotou e o job n\u00e3o terminou: " + jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo waitForAnyJob(long timeout) throws ExitTimeoutException, InvalidJobException {
        Set<String> jobsAvailable = this.jobsSubmited.keySet();
        JobInfoQueue jobInfoQueue = this;
        synchronized (jobInfoQueue) {
            if (this.jobsSubmited.size() == 0) {
                throw new InvalidJobException("N\u00e3o h\u00e1 mais jobs submetidos na sess\u00e3o que ainda n\u00e3o tenham terminado sua execu\u00e7\u00e3o");
            }
            if (timeout == 0L) {
                for (String jobId : jobsAvailable) {
                    JobInfo info = (JobInfo)this.jobsSubmited.get(jobId);
                    if (!info.hasExited) continue;
                    this.jobsSubmited.remove(jobId);
                    return info;
                }
                throw new ExitTimeoutException("O timeout esgotou e o job n\u00e3o terminou");
            }
        }
        long limit = System.currentTimeMillis() * 1000L + timeout;
        long timeToGo = limit - System.currentTimeMillis() * 1000L;
        boolean waitForever = timeout == -1L;
        while (waitForever || timeToGo > 0L) {
            try {
                JobInfoQueue jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    this.wait(100L);
                }
                if (!waitForever) {
                    timeToGo = limit - System.currentTimeMillis() * 1000L;
                }
                jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    JobInfo info = null;
                    for (String jobId : jobsAvailable) {
                        info = (JobInfo)this.jobsSubmited.get(jobId);
                        if (!info.hasExited) continue;
                        this.jobsSubmited.remove(jobId);
                        return info;
                    }
                    if (info == null) {
                        throw new InvalidJobException("N\u00e3o h\u00e1 mais jobs submetidos na sess\u00e3o que ainda n\u00e3o tenham terminado sua execu\u00e7\u00e3o");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new ExitTimeoutException("O timeout esgotou e o job n\u00e3o terminou");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo getJobInfo(String jobId) throws InvalidJobException {
        JobInfoQueue jobInfoQueue = this;
        synchronized (jobInfoQueue) {
            JobInfo info = (JobInfo)this.jobsSubmited.get(jobId);
            if (info == null) {
                throw new InvalidJobException("N\u00e3o foi encontrado um job com o nome especificado: " + jobId);
            }
            return info;
        }
    }
}

