/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.exception.InfoException;
import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.logic.CloseProjectNotification;
import csbase.logic.CommonProjectInfo;
import csbase.logic.Notification;
import csbase.logic.OpenProjectNotification;
import csbase.logic.ProjectAttribute;
import csbase.logic.ProjectEvent;
import csbase.logic.ProjectPermissions;
import csbase.logic.ProjectRecoveryFailureNotification;
import csbase.logic.ProjectRecoverySuccessNotification;
import csbase.logic.User;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.mailservice.MailService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.projectservice.ServerProjectFile;
import csbase.util.messages.Message;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import tecgraf.javautils.core.io.FileUtils;

public class ServerProject {
    public static final String INFO_EXTENSION = ".csbase_project_info";
    private static Hashtable<Object, ServerProject> projects = new Hashtable();
    private CommonProjectInfo info;
    private ServerProjectFile tree;
    private File dir;
    private int count;
    private String[] path;

    public Object getId() {
        return this.info.projectId;
    }

    public String[] getPath() {
        User user;
        if (this.path != null) {
            return this.path;
        }
        try {
            user = User.getUser((Object)this.getUserId());
        }
        catch (Exception e) {
            return this.path;
        }
        this.path = new String[2];
        this.path[0] = user.getLogin();
        this.path[1] = this.getName();
        return this.path;
    }

    public String getAbsolutePath() {
        return this.tree.getAbsolutePath();
    }

    public static Object getId(Object userId, String projectName) {
        try {
            User user = User.getUser((Object)userId);
            String sep = File.separator;
            return String.valueOf(user.getLogin()) + sep + projectName;
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getAbsolutePath(Object projectId) {
        ProjectService projectService = ProjectService.getInstance();
        return FileUtils.joinPath((String[])new String[]{projectService.getProjectRepositoryPath(), (String)projectId});
    }

    public static String getProjectName(Object projectId) {
        String[] elements = ServerProject.splitProjectId(projectId);
        return elements[1];
    }

    public static String getOwnerLogin(Object projectId) {
        String[] elements = ServerProject.splitProjectId(projectId);
        return elements[0];
    }

    private static String[] splitProjectId(Object projectId) {
        String[] elements = FileUtils.splitPath((String)((String)projectId));
        if (elements.length < 2) {
            String message = String.format("O texto informado (%s) n\u00e3o est\u00e1 no formato esperado para um identificador de projeto.", projectId);
            throw new ServiceFailureException(message);
        }
        return elements;
    }

    public static Object getOwnerId(Object projectId) {
        return ServerProject.getOwner(projectId).getId();
    }

    public static String getOwnerName(Object projectId) {
        return ServerProject.getOwner(projectId).getName();
    }

    public static User getOwner(Object projectId) {
        User user;
        String userLogin = ServerProject.getOwnerLogin(projectId);
        try {
            user = User.getUserByLogin((String)userLogin);
        }
        catch (Exception e) {
            String message = String.format("Erro ao obter o usu\u00e1rio cujo login \u00e9 %s.\n", userLogin);
            throw new ServiceFailureException(message, (Throwable)e);
        }
        if (user == null) {
            throw new ServiceFailureException("Usu\u00e1rio inv\u00e1lido: " + userLogin);
        }
        return user;
    }

    public String getOwnerServerName() {
        String ownerServerName = (String)this.info.getAttribute(ProjectAttribute.SERVER_NAME.getAttributeKey());
        if (ownerServerName == null) {
            return "";
        }
        return ownerServerName;
    }

    protected static File getConfigFile(File dir) {
        File configFile = new File(dir.getParentFile(), String.valueOf(dir.getName()) + INFO_EXTENSION);
        return configFile;
    }

    static boolean isValidBaseDirectory(File file) {
        return file.isDirectory() && !file.isHidden();
    }

    public static List<Object> getAllProjectIds(final Object userId) {
        String dirPath = ServerProject.getBasePrjDirForUser(userId);
        File dir = new File(dirPath);
        File[] prjs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!ServerProject.isValidBaseDirectory(file)) {
                    return false;
                }
                File configFile = ServerProject.getConfigFile(file);
                CommonProjectInfo cpi = ServerProject.readProjectInfoFromConfigFile(configFile, userId);
                return cpi != null;
            }
        });
        ArrayList<Object> ids = new ArrayList<Object>();
        if (prjs != null) {
            int i = 0;
            while (i < prjs.length) {
                ids.add(ServerProject.getId(userId, prjs[i].getName()));
                ++i;
            }
        }
        return ids;
    }

    public static boolean userHasHisOwnProjects(Object userId) {
        String dirPath = ServerProject.getBasePrjDirForUser(userId);
        File dir = new File(dirPath);
        File[] prjDirs = dir.listFiles(new FileFilter(){
            boolean foundOne = false;

            @Override
            public boolean accept(File file) {
                if (!this.foundOne && file.isDirectory()) {
                    this.foundOne = true;
                    return true;
                }
                return false;
            }
        });
        return prjDirs != null && prjDirs.length > 0;
    }

    private static String getBasePrjDirForUser(Object userId) {
        try {
            User user = User.getUser((Object)userId);
            ProjectService projectService = ProjectService.getInstance();
            String projectRepositoryPath = projectService.getProjectRepositoryPath();
            return FileUtils.joinPath((String[])new String[]{projectRepositoryPath, user.getLogin()});
        }
        catch (RemoteException e) {
            String err = "Diret\u00f3rio do usu\u00e1rio " + userId + " n\u00e3o foi encontrado.";
            throw new ServiceFailureException(err, (Throwable)e);
        }
    }

    public static boolean removeBasePrjDirForUser(Object userId) {
        String userProjectPath = ServerProject.getBasePrjDirForUser(userId);
        File dir = new File(userProjectPath);
        if (dir.exists()) {
            return dir.delete();
        }
        return true;
    }

    public static boolean existsProject(Object projectId) {
        String absolutePath = ServerProject.getAbsolutePath(projectId);
        File projectDir = new File(absolutePath);
        boolean exists = projectDir.exists();
        boolean directory = projectDir.isDirectory();
        return exists && directory;
    }

    public static synchronized ServerProject openProject(Object projectId, boolean notify) {
        ProjectService prjService = ProjectService.getInstance();
        ServerProject sp = ServerProject.openProject(projectId);
        if (ProjectService.isInternalServerRequest()) {
            return sp;
        }
        if (!sp.userHasAccess(Service.getUser().getId())) {
            throw new PermissionException("Usuario n\u00e3o participa do projeto");
        }
        ++sp.count;
        if (notify) {
            ServerProject.notifyProjectUsers(sp, (Notification)new OpenProjectNotification(prjService.getSenderName(), sp.getName()));
        }
        return sp;
    }

    public static synchronized ServerProject openServerProject(Object projectId) {
        return ServerProject.openProject(projectId);
    }

    private static synchronized ServerProject openProject(Object projectId) {
        Object ownerId = ServerProject.getOwnerId(projectId);
        String path = ServerProject.getAbsolutePath(projectId);
        ServerProject sp = ServerProject.getProject(projectId);
        if (sp == null) {
            File dir = new File(path);
            if (!dir.exists() || !dir.isDirectory()) {
                throw new ServiceFailureException(String.format("projeto '%s' n\u00e3o existe para o usu\u00e1rio '%s'", ServerProject.getProjectName(projectId), ServerProject.getOwnerLogin(projectId)));
            }
            File configFile = ServerProject.getConfigFile(dir);
            if (!configFile.isFile()) {
                return null;
            }
            CommonProjectInfo info = ServerProject.readProjectInfoFromConfigFile(configFile, ownerId);
            if (info == null) {
                String err = "O arquivo de configura\u00e7\u00e3o do projeto est\u00e1 inconsistente.";
                throw new ServiceFailureException(err);
            }
            sp = new ServerProject(projectId, info, dir);
            sp.getTree().createdBy = ownerId;
            projects.put(projectId, sp);
            Server.logInfoMessage("Projeto " + projectId + " aberto no servidor. Numero de projetos abertos: " + projects.size());
        }
        return sp;
    }

    private static void notifyProjectUsers(ServerProject project, Notification data) {
        User loggedUser = Service.getUser();
        if (loggedUser == null || project.getSharingType() != ProjectPermissions.SharingType.PARTIAL) {
            return;
        }
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(project.getId());
            MessageService.getInstance().send(new Message((Serializable)data), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rio do projeto " + project.getId() + ".", e);
        }
    }

    public static ServerProject getProject(Object id) {
        ServerProject sp = projects.get(id);
        return sp;
    }

    public static ServerProject createProject(CommonProjectInfo info) {
        String id;
        String projectPath;
        ProjectService projectService = ProjectService.getInstance();
        try {
            Object projectId = ServerProject.getId(info.userId, info.name);
            projectPath = ServerProject.getAbsolutePath(projectId);
        }
        catch (Exception e) {
            throw new ServiceFailureException("ServerProject.createProject:\n userId: " + info.userId + "\n name: " + info.name + "Falha na constru\u00e7\u00e3o da caminho para o projeto.", (Throwable)e);
        }
        File dir = new File(projectPath);
        if (dir.exists()) {
            String infoMsg = projectService.getFormattedString("ServerProject.info.project.exists", new Object[]{info.name});
            throw new InfoException(infoMsg);
        }
        if (!dir.mkdirs()) {
            String infoMsg = projectService.getFormattedString("ServerProject.info.create.dir", new Object[]{info.name});
            throw new InfoException(infoMsg);
        }
        long now = System.currentTimeMillis();
        info.setAttribute(ProjectAttribute.CREATION_DATE.getAttributeKey(), (Object)now);
        ProjectPermissions.setSharingType((CommonProjectInfo)info, (ProjectPermissions.SharingType)ProjectPermissions.SharingType.PRIVATE);
        try {
            id = (String)ServerProject.getId(info.userId, info.name);
        }
        catch (Exception e) {
            throw new ServiceFailureException("ServerProject.createProject:\n userId: " + info.userId + "\n name: " + info.name + "Falha na constru\u00e7\u00e3o do identificador do projeto.", (Throwable)e);
        }
        Server server = Server.getInstance();
        info.setAttribute(ProjectAttribute.SERVER_NAME.getAttributeKey(), (Object)server.getSystemName());
        ServerProject sp = new ServerProject(id, info, dir);
        File configFile = ServerProject.getConfigFile(dir);
        sp.writeProjectInfo(configFile);
        projects.put(id, sp);
        Server.logInfoMessage("Projeto " + id + " criado no servidor. Numero de projetos abertos: " + projects.size());
        ++sp.count;
        return sp;
    }

    private static String getProjectNameFromConfigFile(File configFile) {
        String configFileName = configFile.getName();
        int idx = configFileName.lastIndexOf(".");
        String projectName = configFileName.substring(0, idx);
        return projectName;
    }

    private static Object getOwnerIdFromConfigFile(File configFile) {
        User owner;
        block4: {
            File parentDir = configFile.getParentFile();
            if (!parentDir.exists()) {
                return null;
            }
            try {
                String parentFileName = parentDir.getName();
                owner = User.getUserByLogin((String)parentFileName);
                if (owner != null) break block4;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        Object ownerId = owner.getId();
        return ownerId;
    }

    public static boolean generateConfigFile(File configFile, Object ownerId, String projectName) {
        CommonProjectInfo cpi = new CommonProjectInfo();
        cpi.name = projectName;
        cpi.userId = ownerId;
        ProjectPermissions.setSharingType((CommonProjectInfo)cpi, (ProjectPermissions.SharingType)ProjectPermissions.SharingType.PRIVATE);
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(configFile));
            out.writeObject(cpi);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            try {
                String pth = configFile.getAbsolutePath();
                String fmt = "Falha na recup. de arq. de controle de projeto: %s";
                String err = String.format(fmt, pth);
                Server.logSevereMessage(err, e);
            }
            catch (Throwable throwable) {
                boolean closed = FileUtils.close(out);
                if (!closed) {
                    String pth = configFile.getAbsolutePath();
                    String fmt = "Falha no fechamento de arq. de controle de projeto: %s";
                    String err = String.format(fmt, pth);
                    Server.logSevereMessage(err);
                }
                throw throwable;
            }
            boolean closed = FileUtils.close((Closeable)out);
            if (!closed) {
                String pth = configFile.getAbsolutePath();
                String fmt = "Falha no fechamento de arq. de controle de projeto: %s";
                String err = String.format(fmt, pth);
                Server.logSevereMessage(err);
            }
            return false;
        }
        boolean closed = FileUtils.close((Closeable)out);
        if (!closed) {
            String pth = configFile.getAbsolutePath();
            String fmt = "Falha no fechamento de arq. de controle de projeto: %s";
            String err = String.format(fmt, pth);
            Server.logSevereMessage(err);
        }
        return true;
    }

    public static CommonProjectInfo createProjectInfo(File configFile) {
        boolean closed;
        CommonProjectInfo commonProjectInfo;
        ObjectInputStream in = null;
        try {
            CommonProjectInfo cpi;
            in = new ObjectInputStream(new DataInputStream(new BufferedInputStream(new FileInputStream(configFile))));
            commonProjectInfo = cpi = (CommonProjectInfo)in.readObject();
        }
        catch (Exception e) {
            boolean closed2;
            try {
                String configFilePath = configFile.getAbsolutePath();
                String fmt = "Falha na carga do arquivo de controle de projeto: %s.";
                String err = String.format(fmt, configFilePath);
                Server.logSevereMessage(err, e);
            }
            catch (Throwable throwable) {
                boolean closed3;
                if (in != null && !(closed3 = FileUtils.close(in))) {
                    String configFilePath = configFile.getAbsolutePath();
                    String fmt = "Falha no fechamento de arq. de contole de projeto: %s";
                    String msg = String.format(fmt, configFilePath);
                    Server.logSevereMessage(msg);
                }
                throw throwable;
            }
            if (in != null && !(closed2 = FileUtils.close((Closeable)in))) {
                String configFilePath = configFile.getAbsolutePath();
                String fmt = "Falha no fechamento de arq. de contole de projeto: %s";
                String msg = String.format(fmt, configFilePath);
                Server.logSevereMessage(msg);
            }
            return null;
        }
        if (in != null && !(closed = FileUtils.close((Closeable)in))) {
            String configFilePath = configFile.getAbsolutePath();
            String fmt = "Falha no fechamento de arq. de contole de projeto: %s";
            String msg = String.format(fmt, configFilePath);
            Server.logSevereMessage(msg);
        }
        return commonProjectInfo;
    }

    private static boolean isConfigFileConsistent(File configFile, CommonProjectInfo cpi) {
        String configProjectName = ServerProject.getProjectNameFromConfigFile(configFile);
        if (!configProjectName.equals(cpi.name)) {
            String fmt = "O nome do projeto (%s) \u00e9 inconsistente com o path: %s.";
            String err = String.format(fmt, cpi.name, configProjectName);
            Server.logSevereMessage(err);
            return false;
        }
        Object configOwnerId = ServerProject.getOwnerIdFromConfigFile(configFile);
        if (configOwnerId == null) {
            String fmt = "O dono do projeto n\u00e3o existe com o path: %s.";
            String err = String.format(fmt, cpi.userId, configOwnerId);
            Server.logSevereMessage(err);
            return false;
        }
        if (!configOwnerId.equals(cpi.userId)) {
            String fmt = "O dono do projeto (%s) \u00e9 inconsistente com o path: %s.";
            String err = String.format(fmt, cpi.userId, configOwnerId);
            Server.logSevereMessage(err);
            return false;
        }
        return true;
    }

    private static void notifyRecuperation(Object userId, Notification notification) {
        Vector<Object> ids = new Vector<Object>();
        try {
            ids.addAll(User.getAdminIds());
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao obter a lista de usu\u00e1rios adminstradores.", e);
        }
        Object[] usersIds = null;
        if (!User.isAdmin((Object)userId)) {
            ids.add(userId);
        }
        try {
            usersIds = ids.toArray(new String[0]);
            MessageService.getInstance().send(new Message((Serializable)notification), (String[])usersIds);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao enviar notific\u00e3o de problema.", e);
        }
        MailService mailService = MailService.getInstance();
        ProjectService projectService = ProjectService.getInstance();
        String mailText = notification.toString();
        mailService.mailSomeUsersFromService(projectService, usersIds, mailText);
    }

    public static CommonProjectInfo readProjectInfoFromConfigFile(File configFile, Object ownerId) {
        if (configFile == null) {
            String err = "O arquivo de configura\u00e7\u00e3o n\u00e3o pode ser nulo.";
            throw new IllegalArgumentException(err);
        }
        String configFilePath = configFile.getAbsolutePath();
        CommonProjectInfo cpi = ServerProject.createProjectInfo(configFile);
        if (cpi == null) {
            String projectName = ServerProject.getProjectNameFromConfigFile(configFile);
            boolean recup = ServerProject.generateConfigFile(configFile, ownerId, projectName);
            if (!recup) {
                String fmt = "Falha de recup. de arq. de contole de projeto: %s";
                String msg = String.format(fmt, configFilePath);
                Server.logSevereMessage(msg);
                ProjectService prjService = ProjectService.getInstance();
                String senderName = prjService.getSenderName();
                ServerProject.notifyRecuperation(ownerId, (Notification)new ProjectRecoveryFailureNotification(senderName, ownerId, projectName));
                return null;
            }
            String fmt = "Arq. de controle de projeto recuperado: %s";
            String msg = String.format(fmt, configFilePath);
            ProjectService prjService = ProjectService.getInstance();
            String senderName = prjService.getSenderName();
            ServerProject.notifyRecuperation(ownerId, (Notification)new ProjectRecoverySuccessNotification(senderName, ownerId, projectName));
            Server.logSevereMessage(msg);
            cpi = ServerProject.createProjectInfo(configFile);
            if (cpi == null) {
                String err = "Falha grave ap\u00f3s recupera\u00e7\u00e3o de projeto: ";
                Server.logSevereMessage(String.valueOf(err) + configFilePath);
                return null;
            }
        }
        if (!ServerProject.isConfigFileConsistent(configFile, cpi)) {
            String err = "Inconsist\u00eancia grave ap\u00f3s recupera\u00e7\u00e3o de projeto: ";
            Server.logSevereMessage(String.valueOf(err) + configFilePath);
            return null;
        }
        return cpi;
    }

    public CommonProjectInfo getInfo() {
        return this.info;
    }

    public Object getUserId() {
        return this.info.userId;
    }

    public String getName() {
        return this.info.name;
    }

    public void setName(String name) {
    }

    public String getDescription() {
        return this.info.description;
    }

    public void setDescription(String description) {
        this.info.description = description;
    }

    public Hashtable<String, Object> getAttributes() {
        return this.info.getAttributes();
    }

    public void setAttributes(Hashtable<String, Object> attributes) {
        this.info.setAttributes(attributes);
    }

    public ServerProjectFile getTree() {
        return this.tree;
    }

    public void setUsersRO(Set<Object> usersRO) {
        ProjectPermissions.setUsersRO((CommonProjectInfo)this.info, usersRO);
    }

    public void setUsersRW(Set<Object> usersRW) {
        ProjectPermissions.setUsersRW((CommonProjectInfo)this.info, usersRW);
    }

    public Boolean isPublic() {
        return ProjectPermissions.isPublic((CommonProjectInfo)this.info);
    }

    public void setSharingType(ProjectPermissions.SharingType type) {
        ProjectPermissions.setSharingType((CommonProjectInfo)this.info, (ProjectPermissions.SharingType)type);
    }

    public ProjectPermissions.SharingType getSharingType() {
        return ProjectPermissions.getSharingType((CommonProjectInfo)this.info);
    }

    public Set<Object> getUsersRO() {
        return ProjectPermissions.getUsersRO((CommonProjectInfo)this.info);
    }

    public Set<Object> getUsersRW() {
        return ProjectPermissions.getUsersRW((CommonProjectInfo)this.info);
    }

    public boolean userHasAccess(Object userID) {
        return ProjectPermissions.userHasAccess((CommonProjectInfo)this.info, (Object)userID);
    }

    public boolean userHasAccessRO(Object userID) {
        return ProjectPermissions.userHasAccessRO((CommonProjectInfo)this.info, (Object)userID);
    }

    public boolean userHasAccessRW(Object userID) {
        return ProjectPermissions.userHasAccessRW((CommonProjectInfo)this.info, (Object)userID);
    }

    public boolean userHasSelectiveAccessRO(Object userID) {
        return ProjectPermissions.userHasSelectiveAccessRO((CommonProjectInfo)this.info, (Object)userID);
    }

    public boolean userHasSelectiveAccessRW(Object userID) {
        return ProjectPermissions.userHasSelectiveAccessRW((CommonProjectInfo)this.info, (Object)userID);
    }

    public boolean userIsOwner(Object userID) {
        return this.info.userId.equals(userID);
    }

    public void modify() {
        File configFile = ServerProject.getConfigFile(this.dir);
        if (!configFile.isFile()) {
            return;
        }
        this.writeProjectInfo(configFile);
        Object[] arg = new Object[]{this.info};
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(this.info.projectId);
            MessageService.getInstance().send(new Message((Serializable)ProjectEvent.makeEvent((Object)this.info.projectId, (int)1, (Object[])arg)), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + this.info.projectId + ".", e);
        }
    }

    private void writeProjectInfo(File configFile) {
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(configFile))));
                out.writeObject(this.info);
            }
            catch (IOException e) {
                String errMsg = "Error ao gerar " + configFile.getAbsolutePath();
                throw new ServiceFailureException(errMsg, (Throwable)e);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new ServiceFailureException("Erro fechando stream.", (Throwable)e);
            }
        }
    }

    public void refreshTree() {
        this.tree.makeSureExists();
        ProjectService projectService = ProjectService.getInstance();
        Object[] arg = new Object[]{projectService.buildSingleClientProjectFile(this.tree)};
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(this.info.projectId);
            MessageService.getInstance().send(new Message((Serializable)ProjectEvent.makeEvent((Object)this.info.projectId, (int)8, (Object[])arg)), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + this.info.projectId + ".", e);
        }
    }

    public void rebuildTree() {
        this.tree.makeSureExists();
        ProjectService projectService = ProjectService.getInstance();
        Object[] arg = new Object[]{projectService.buildClientProjectSubtree(this.tree)};
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(this.info.projectId);
            MessageService.getInstance().send(new Message((Serializable)ProjectEvent.makeEvent((Object)this.info.projectId, (int)8, (Object[])arg)), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + this.info.projectId + ".", e);
        }
    }

    public void remove() {
        this.tree.remove();
        File configFile = ServerProject.getConfigFile(this.dir);
        if (!configFile.delete()) {
            throw new ServiceFailureException("ServerProject:remove: erro na remo\u00e7\u00e3o do arquivo " + configFile.getAbsolutePath());
        }
        this.tree = null;
        HashSet<Object> users = new HashSet<Object>();
        users.add(this.getUserId());
        users.addAll(this.getUsersRO());
        users.addAll(this.getUsersRW());
        if (projects.remove(this.info.projectId) == this) {
            Object[] arg = new Object[]{this.info.projectId};
            try {
                MessageService.getInstance().send(new Message((Serializable)ProjectEvent.makeEvent((Object)this.info.projectId, (int)2, (Object[])arg)), users.toArray(new String[0]));
            }
            catch (RemoteException e) {
                Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + this.info.projectId + ".", e);
            }
        } else {
            String errMsg = "ServerProject:remove: erro na remo\u00e7\u00e3o do projeto " + this.info.projectId + " da hashtable";
            throw new ServiceFailureException(errMsg);
        }
    }

    public void close(boolean notify) {
        if (notify) {
            ProjectService projectService = ProjectService.getInstance();
            ServerProject.notifyProjectUsers(this, (Notification)new CloseProjectNotification(projectService.getSenderName(), this.getName()));
        }
        --this.count;
    }

    public String toString() {
        String text = "";
        text = String.valueOf(text) + "Id: " + this.info.projectId + "\n";
        text = String.valueOf(text) + "Userid: " + this.info.userId + "\n";
        text = String.valueOf(text) + "Name: " + this.info.name + "\n";
        text = String.valueOf(text) + "Descricao: " + this.info.description + "\n";
        text = String.valueOf(text) + "Arvore: " + this.tree + "\n";
        text = String.valueOf(text) + "Diretorio: " + this.dir + "\n";
        text = String.valueOf(text) + "No clientes usando: " + this.count + "\n";
        return text;
    }

    private ServerProject(Object id, CommonProjectInfo info, File dir) {
        info.projectId = id;
        this.info = info;
        this.dir = dir;
        this.tree = ServerProjectFile.createRoot(dir, id);
        this.count = 0;
    }
}

