/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.SGASetCPUCapacityComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.sgaservice.SGAService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CPUCapacityPolicy
implements SchedulerPolicyInterface {
    @Override
    public String chooseServer(CommandInfo command, List<String> serversNames) {
        List<String> sgasNames = this.getSortedSGAByCPUCapacity(serversNames);
        if (sgasNames.size() != 0) {
            return sgasNames.get(0);
        }
        return null;
    }

    @Override
    public List<String> chooseServers(CommandInfo command, List<String> serversNames, int numServers) {
        List<String> sgasNames = this.getSortedSGAByCPUCapacity(serversNames);
        if (sgasNames.size() >= numServers) {
            return sgasNames.subList(0, numServers);
        }
        return null;
    }

    private List<String> getSortedSGAByCPUCapacity(List<String> serversNames) {
        ArrayList<SGASet> sgasSets = new ArrayList<SGASet>();
        ArrayList<String> sgasNames = new ArrayList<String>();
        SGAService sgaService = SGAService.getInstance();
        int i = 0;
        while (i < serversNames.size()) {
            SGASet sgaSet = sgaService.getSGASet(serversNames.get(i));
            if (sgaSet != null) {
                sgasSets.add(sgaSet);
            }
            ++i;
        }
        Collections.sort(sgasSets, new SGASetCPUCapacityComparator());
        for (SGASet sga : sgasSets) {
            sgasNames.add(sga.getName());
        }
        return sgasNames;
    }
}

