/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.FileParameterValue;
import csbase.server.Server;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.schedulerservice.SGASetIOComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.sgaservice.SGAService;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import tecgraf.javautils.core.io.FileUtils;

public class IOCapacityPolicy
implements SchedulerPolicyInterface {
    private SGAService sgaService = SGAService.getInstance();

    @Override
    public String chooseServer(CommandInfo command, List<String> serversNames) {
        List<String> sgasNames = this.getSortedSGASetByIOCapacity(command, serversNames);
        if (sgasNames != null && sgasNames.size() != 0) {
            return sgasNames.get(0);
        }
        return null;
    }

    @Override
    public List<String> chooseServers(CommandInfo command, List<String> serversNames, int numServers) {
        List<String> sgasNames = this.getSortedSGASetByIOCapacity(command, serversNames);
        if (sgasNames != null && sgasNames.size() >= numServers) {
            return sgasNames.subList(0, numServers);
        }
        return null;
    }

    private List<String> getSortedSGASetByIOCapacity(CommandInfo command, List<String> serversNames) {
        AlgorithmConfigurator algorithmConfigurator;
        ArrayList<SGASet> sgasSets = new ArrayList<SGASet>();
        ArrayList<String> sgasNames = new ArrayList<String>();
        try {
            algorithmConfigurator = command.getConfigurator();
        }
        catch (RemoteException e) {
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel obter o configurador do comando " + command.getId(), e);
            return null;
        }
        long inputFilesLength = this.getInputFilesLength(algorithmConfigurator, command.getId());
        Hashtable<String, Long> platfBinFilesLengthList = this.getExecFilesLength(algorithmConfigurator, serversNames);
        int i = 0;
        while (i < serversNames.size()) {
            SGASet sgaSet = this.sgaService.getSGASet(serversNames.get(i));
            if (sgaSet != null) {
                sgasSets.add(sgaSet);
            }
            ++i;
        }
        Collections.sort(sgasSets, new SGASetIOComparator(inputFilesLength, platfBinFilesLengthList));
        for (SGASet sga : sgasSets) {
            sgasNames.add(sga.getName());
        }
        return sgasNames;
    }

    private long getInputFilesLength(AlgorithmConfigurator algorithmConfigurator, String commandId) {
        Set inputFiles = algorithmConfigurator.getInputFiles();
        Iterator inputFileIterator = inputFiles.iterator();
        long filesLength = 0L;
        ProjectService projectService = ProjectService.getInstance();
        int i = 0;
        while (i < inputFiles.size()) {
            String[] path = FileUtils.splitPath((String)((FileParameterValue)inputFileIterator.next()).getPath());
            if (projectService.existsFile(commandId, path)) {
                filesLength += projectService.fileSize(commandId, path);
            }
            ++i;
        }
        return filesLength /= 1024L;
    }

    private Hashtable<String, Long> getExecFilesLength(AlgorithmConfigurator algoConfigurator, List<String> serversNames) {
        Hashtable<String, Long> platformsList = new Hashtable<String, Long>();
        AlgorithmVersionInfo algoVersionInfo = algoConfigurator.getAlgorithmVersion();
        this.sgaService = SGAService.getInstance();
        int i = 0;
        while (i < serversNames.size()) {
            SGASet sgaSet = this.sgaService.getSGASet(serversNames.get(i));
            if (sgaSet != null && !platformsList.containsKey(sgaSet.getPlatformId())) {
                long filesLength = 0L;
                String binDirPath = String.valueOf(algoVersionInfo.getDirPath()) + File.separator + algoVersionInfo.getBinDirName() + File.separator + sgaSet.getPlatformId();
                File binDir = new File(binDirPath);
                File[] binFiles = binDir.listFiles();
                int j = 0;
                while (j < binFiles.length) {
                    filesLength += binFiles[j].length();
                    ++j;
                }
                platformsList.put(sgaSet.getPlatformId(), new Long(filesLength /= 1024L));
            }
            ++i;
        }
        return platformsList;
    }
}

