/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.exception.PermissionException;
import csbase.logic.CommandInfo;
import csbase.logic.FailureFinalizationType;
import csbase.logic.Priority;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.schedulerservice.PercCPUPolicy;
import csbase.server.services.schedulerservice.PriorityQueue;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.SchedulerResourcesController;
import csbase.server.services.schedulerservice.SchedulerService;
import csbase.server.services.sgaservice.ProjectNotFoundException;
import csbase.server.services.sgaservice.SGANotAvailableException;
import csbase.server.services.sgaservice.SGAService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class Scheduler {
    private Thread schedulerThread;
    private boolean exitSchedulerThread;
    private final PriorityQueue commandQueue;
    private final SchedulerService service;
    private final SGAService sgaService;
    private final HashMap<String, Long> recentUsedServers;
    private final int sgaQuarantine;
    private final long queueProcessingInterval;
    private SchedulerPolicyInterface schedPolicyInterface;
    private final String schedPolicyName;
    private SchedulerResourcesController schedulerResourcesController;

    protected Scheduler(PriorityQueue commandQueue, long queueProcessingInterval, int sgaQuarantine, String schedPolicyName, boolean resourcesControl, String backupFilePath) {
        this.commandQueue = commandQueue;
        this.queueProcessingInterval = queueProcessingInterval;
        this.sgaQuarantine = sgaQuarantine;
        this.schedPolicyName = schedPolicyName;
        this.sgaService = SGAService.getInstance();
        this.service = SchedulerService.getInstance();
        this.recentUsedServers = new HashMap();
        this.schedulerResourcesController = new SchedulerResourcesController(resourcesControl, backupFilePath);
    }

    protected void startScheduler() {
        this.loadSchedulerPolicy();
        this.schedulerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                while (!Scheduler.this.exitSchedulerThread) {
                    Server.logFineMessage("In\u00edcio do processamento, se houver comandos");
                    CommandInfo[] cmds = Scheduler.this.commandQueue.getAndWaitForCommands();
                    Vector<String> sgasNames = null;
                    sgasNames = Scheduler.this.sgaService.getAllSGANames();
                    Scheduler.this.clearQuarantine();
                    int numOfCommandsToSchedule = cmds.length;
                    try {
                        int i = 0;
                        while (i < cmds.length && !Scheduler.this.exitSchedulerThread) {
                            CommandInfo cmd = cmds[i];
                            Service.setUserId(cmd.getUserId());
                            List serversChoosed = Scheduler.this.chooseServers(cmd, sgasNames);
                            if (serversChoosed == null) {
                                if (cmd.getPriority() == Priority.ROOT) {
                                    Scheduler.this.commandQueue.remove(cmd.getId());
                                    --numOfCommandsToSchedule;
                                    Server.logWarningMessage("Falha ao disparar comando com prioridade ROOT. N\u00e3o foi encontrado um SGA dispon\u00edvel para atender a plataforma " + cmd.getPlatformFilter() + " do algoritmo usado no comando: " + cmd.getId());
                                    Scheduler.this.service.failCommand(cmd, FailureFinalizationType.NO_SGA_AVAILABLE_TO_ROOT_COMMAND);
                                }
                            } else {
                                String serverChoosed = (String)serversChoosed.get(0);
                                Server.logFineMessage("Servidor aprovado: " + serverChoosed);
                                try {
                                    cmd.setSGAName(serverChoosed);
                                    Scheduler.this.schedulerResourcesController.makeReservation(cmd);
                                    PriorityQueue priorityQueue = Scheduler.this.commandQueue;
                                    synchronized (priorityQueue) {
                                        if (Scheduler.this.commandQueue.getCommand(cmd.getId()) == null) {
                                            Server.logWarningMessage("O comando " + cmd.getId() + " n\u00e3o vai ser disparado porque j\u00e1 foi removido da fila");
                                        } else {
                                            Scheduler.this.sgaService.executeCommand(cmd);
                                            Scheduler.this.commandQueue.remove(cmd.getId());
                                            for (String server : serversChoosed) {
                                                Scheduler.this.recentUsedServers.put(server, System.currentTimeMillis());
                                            }
                                        }
                                    }
                                    --numOfCommandsToSchedule;
                                }
                                catch (SGANotAvailableException e) {
                                    Server.logSevereMessage(String.format("Erro ao submeter o comando %s - %s.", cmd.getId(), cmd.getTip()), (Throwable)((Object)e));
                                    Scheduler.this.commandQueue.remove(cmd.getId());
                                    --numOfCommandsToSchedule;
                                    Scheduler.this.service.failCommand(cmd, FailureFinalizationType.SGA_IS_NOT_AVAILABLE);
                                }
                                catch (ProjectNotFoundException e) {
                                    Server.logSevereMessage(String.format("Erro ao submeter o comando %s - %s.", cmd.getId(), cmd.getTip()), (Throwable)((Object)e));
                                    Scheduler.this.commandQueue.remove(cmd.getId());
                                    --numOfCommandsToSchedule;
                                    Scheduler.this.service.failCommand(cmd, FailureFinalizationType.PROJECT_NOT_FOUND);
                                }
                                catch (PermissionException e) {
                                    Server.logSevereMessage(String.format("Erro ao submeter o comando %s - %s.", cmd.getId(), cmd.getTip()), e);
                                    Scheduler.this.commandQueue.remove(cmd.getId());
                                    --numOfCommandsToSchedule;
                                    Scheduler.this.service.failCommand(cmd, FailureFinalizationType.USER_WITHOUT_PERMISSION_FOR_EXECUTION);
                                }
                                catch (Exception e) {
                                    Server.logSevereMessage(String.format("Erro ao submeter o comando %s - %s.", cmd.getId(), cmd.getTip()), e);
                                    Scheduler.this.commandQueue.remove(cmd.getId());
                                    --numOfCommandsToSchedule;
                                    FailureFinalizationType.UNKNOWN.changeDescription(e.getMessage());
                                    Scheduler.this.service.failCommand(cmd, FailureFinalizationType.UNKNOWN);
                                }
                            }
                            ++i;
                        }
                    }
                    finally {
                        Service.setUserId(null);
                    }
                    if (Scheduler.this.commandQueue.size() <= 0 || Scheduler.this.commandQueue.size() != numOfCommandsToSchedule) continue;
                    Server.logFineMessage("Ainda h\u00e1 comandos para processar. Fila em sleep.");
                    Scheduler.this.commandQueue.sleep(Scheduler.this.queueProcessingInterval);
                }
            }
        });
        this.schedulerThread.setName(String.valueOf(this.getClass().getSimpleName()) + "::" + "SchedulerThread");
        this.schedulerThread.start();
    }

    protected void stopScheduler() {
        this.exitSchedulerThread = true;
    }

    private SchedulerPolicyInterface loadSchedulerPolicy() {
        try {
            Class<?> c = Class.forName(this.schedPolicyName);
            this.schedPolicyInterface = (SchedulerPolicyInterface)c.newInstance();
        }
        catch (Exception e) {
            this.schedPolicyInterface = new PercCPUPolicy();
            Server.logSevereMessage(String.format("Erro ao ativar a pol\u00edtica de escalonamento %s.", this.schedPolicyName), e);
        }
        Server.logInfoMessage("Classe de escalonamento instanciada: " + this.schedPolicyInterface.getClass().getName() + ".java.");
        return this.schedPolicyInterface;
    }

    private List<String> chooseServers(CommandInfo command, List<String> serversNames) {
        Vector<String> platforms;
        AlgorithmConfigurator configurator;
        block9: {
            configurator = command.getConfigurator();
            configurator.updateAlgorithmVersion();
            Set platformsSet = configurator.getPlatforms();
            String platformRestriction = command.getPlatformFilter();
            platforms = new Vector<String>();
            if (platformRestriction == null) {
                platforms.addAll(platformsSet);
                break block9;
            }
            if (platformsSet.contains(platformRestriction)) {
                platforms.add(platformRestriction);
                break block9;
            }
            return null;
        }
        try {
            float cpuAmount = configurator.getCpuAmount();
            float memoryAmount = configurator.getMemoryAmount();
            Set requirements = configurator.getRequirements();
            Server.logFineMessage("Processando o comando: " + command);
            Server.logFineMessage("Tipo do comando: " + configurator.getExecutionType());
            Server.logFineMessage("Unidade de processamento necess\u00e1ria: " + cpuAmount);
            Server.logFineMessage("Mem\u00f3ria necess\u00e1ria: " + memoryAmount);
            for (String requirement : requirements) {
                Server.logFineMessage("Requisito necess\u00e1rio: " + requirement);
            }
            if (command.isAutomatic()) {
                Server.logFineMessage("Sele\u00e7\u00e3o autom\u00e1tica de servidores");
            } else {
                Server.logFineMessage("Sele\u00e7\u00e3o manual. Servidor escolhido: " + command.getSGAName());
            }
            ArrayList<String> serversChoosed = null;
            String serverChoosed = this.chooseServerForSimpleCommand(command, serversNames, platforms, cpuAmount, memoryAmount, requirements);
            if (serverChoosed != null) {
                serversChoosed = new ArrayList<String>();
                serversChoosed.add(serverChoosed);
            }
            return serversChoosed;
        }
        catch (Exception e) {
            Server.logSevereMessage(String.format("Erro ao processar o comando %s - %s.", command.getId(), command.getTip()), e);
            return null;
        }
    }

    private String chooseServerForSimpleCommand(CommandInfo command, List<String> servers, Vector<String> platforms, float cpuAmount, float memoryAmount, Set<String> requirements) {
        if (command.isAutomatic()) {
            ArrayList<String> candidateServers = new ArrayList<String>();
            for (String serverName : servers) {
                Server.logFineMessage("Tentando sga: " + serverName);
                if (!this.checkServer(serverName, platforms, cpuAmount, memoryAmount, requirements)) continue;
                candidateServers.add(serverName);
            }
            return this.schedPolicyInterface.chooseServer(command, candidateServers);
        }
        String serverName = command.getSGAName();
        Server.logFineMessage("Verificando sga: " + serverName);
        if (this.checkServer(serverName, platforms, cpuAmount, memoryAmount, requirements)) {
            return serverName;
        }
        return null;
    }

    private SGASet getSGASet(String serverName) {
        SGASet sgaSet = null;
        sgaSet = this.sgaService.getSGASet(serverName);
        if (sgaSet == null) {
            Server.logSevereMessage("Falha na obten\u00e7\u00e3o do sga " + serverName);
        }
        return sgaSet;
    }

    private boolean checkServer(String server, Vector<String> platforms, float cpuAmount, float memoryAmount, Set<String> requirements) {
        Server.logFineMessage("SGA[" + server + "] Obtendo SGASet.");
        SGASet sgaSet = this.getSGASet(server);
        if (sgaSet == null) {
            Server.logFineMessage("SGA[" + server + "] SGASet == null");
            return false;
        }
        Server.logFineMessage("SGA[" + server + "] SGASet obtido " + (sgaSet.getAlive() ? "vivo" : "morto"));
        boolean inQuarantine = this.isInQuarantine(server);
        Server.logFineMessage("SGA[" + server + "] isInQuarantine: " + inQuarantine);
        if (inQuarantine) {
            return false;
        }
        boolean checkServerRestrictions = this.checkServerRestrictions(sgaSet, platforms);
        Server.logFineMessage("SGA[" + server + "] checkServerRestrictions: " + checkServerRestrictions);
        if (!checkServerRestrictions) {
            return false;
        }
        boolean checkServerResources = this.checkServerResources(sgaSet, cpuAmount, memoryAmount, requirements);
        Server.logFineMessage("SGA[" + server + "] checkServerResources: " + checkServerResources);
        if (!checkServerResources) {
            return false;
        }
        boolean checkResourcesController = this.schedulerResourcesController.checkControllerResources(sgaSet, cpuAmount, memoryAmount);
        Server.logFineMessage("SGA[" + server + "] checkResourcesController: " + checkResourcesController);
        return checkResourcesController;
    }

    private void clearQuarantine() {
        Iterator<Long> iterator = this.recentUsedServers.values().iterator();
        while (iterator.hasNext()) {
            Long quarantineExpirationTime = iterator.next();
            long now = System.currentTimeMillis();
            if (now - quarantineExpirationTime <= (long)this.sgaQuarantine) continue;
            iterator.remove();
        }
    }

    private boolean isInQuarantine(String sgaName) {
        if (!this.recentUsedServers.containsKey(sgaName)) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.sgaQuarantine > 0 && now - this.recentUsedServers.get(sgaName) <= (long)this.sgaQuarantine) {
            return true;
        }
        this.recentUsedServers.remove(sgaName);
        return false;
    }

    private boolean checkServerRestrictions(SGASet sgaSet, Vector<String> platforms) {
        return sgaSet.isPlatformSupported(platforms) && sgaSet.mayExecuteCommand();
    }

    private boolean checkServerResources(SGASet sgaSet, float cpuAmount, float memoryAmount, Set<String> requirements) {
        if (cpuAmount <= 0.0f && memoryAmount <= 0.0f && requirements.size() == 0) {
            return true;
        }
        double localNumProcessors = (double)sgaSet.getNumProcessors() - sgaSet.getCPULoad1() * (double)sgaSet.getNumProcessors() / 100.0;
        Server.logFineMessage("CPU livre: " + localNumProcessors);
        Server.logFineMessage("Mem\u00f3ria (Mb) livre: " + sgaSet.getRAMFreeMemoryMb());
        boolean hasAllRequirements = true;
        for (String requirement : requirements) {
            boolean hasRequirement = sgaSet.hasRequirement(requirement);
            hasAllRequirements = hasAllRequirements && hasRequirement;
            Server.logFineMessage("Requisito " + requirement + ": " + hasRequirement);
        }
        return localNumProcessors >= (double)cpuAmount && sgaSet.getRAMFreeMemoryMb() >= (double)memoryAmount && hasAllRequirements;
    }
}

