/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sgaservice;

import csbase.exception.OperationFailureException;
import csbase.exception.PermissionException;
import csbase.logic.AccessSGAPathPermission;
import csbase.logic.AttributesPermission;
import csbase.logic.ClientSGAFile;
import csbase.logic.CommandEndNotification;
import csbase.logic.CommandErrorNotification;
import csbase.logic.CommandEvent;
import csbase.logic.CommandFailedNotification;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandKilledNotification;
import csbase.logic.CommandLostNotification;
import csbase.logic.CommandStatus;
import csbase.logic.CommandSuccessNotification;
import csbase.logic.CommandWithNoExitCodeNotification;
import csbase.logic.FailureFinalizationType;
import csbase.logic.SGAAdminPermission;
import csbase.logic.SGAInfo;
import csbase.logic.SGANotification;
import csbase.logic.SGANotificationPermission;
import csbase.logic.SGASet;
import csbase.logic.ServerExecutionPermission;
import csbase.logic.ServerGroupInfo;
import csbase.logic.SimpleCommandFinalizationInfo;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.Column;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.csfsservice.CSFSService;
import csbase.server.services.mailservice.MailService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.sgaservice.Command;
import csbase.server.services.sgaservice.FindTransferRate;
import csbase.server.services.sgaservice.ORBException;
import csbase.server.services.sgaservice.ORBHandler;
import csbase.server.services.sgaservice.ProjectNotFoundException;
import csbase.server.services.sgaservice.SGA;
import csbase.server.services.sgaservice.SGAHandler;
import csbase.server.services.sgaservice.SGANotAvailableException;
import csbase.util.messages.Message;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import org.omg.CORBA.IntHolder;
import org.omg.PortableServer.Servant;
import sgaidl.CompletedCommandInfo;
import sgaidl.RetrievedInfo;
import sgaidl.SGACommand;
import sgaidl.SGADynamicInfo;
import sgaidl.SGAServer;
import sgaidl.StaticNodeInfo;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.FormatUtils;

public class SGAService
extends Service
implements SGAServiceInterface {
    private static final String[] CSFS_ALGORITHMS_ROOT_DIR = new String[]{"algorithms"};
    private static final String[] CSFS_SANDBOX_ROOT_DIR = new String[]{"sandbox"};
    public static final String SGA_GROUPS_SUBDIR_NAME = "sga-groups";
    private static final int MILLIS = 1000;
    private static final String COMMANDS_DIR = "commands";
    private static int sgaWatchdogInterval;
    private static int sgaUpdateInterval;
    private static int sgaCommandUpdateInterval;
    private static int sgaHistoricUpdateIntervalSeconds;
    private static int iperfTimeout;
    private static boolean executeNetBenchmark;
    private static int netBenchDuration;
    private static int updateDataTransferRate;
    private boolean exitAuditThread = false;
    private Thread auditThread = null;
    private boolean exitAcquisitionDataThread = false;
    private Thread acquisitionDataThread = null;
    private TransferRateAcquisitionThread acquisitionNetDataThread = null;
    private boolean exitHistoricThread = false;
    private Thread historicThread = null;
    private Hashtable<String, SGA> registeredSGAs = null;
    private Set<String> lockSGAs = null;
    private SGAHandler sgaHandler = null;
    private ORBHandler orbHandler = null;
    private MessageService messageService;
    private boolean doSGALog;
    private long timeout;
    private int numberHostsLog;
    private long cmdExpirationInfoDelay;
    private boolean executeCommandAsScript;
    private boolean logCommandLineInfo;
    private long csfsUpdateProjectAreaDelay;
    private final Map<CommandFinalizationType, Integer> exeResultCounter = new TreeMap<CommandFinalizationType, Integer>();
    private final Map<CommandFinalizationType, Integer> flowResultCounter = new TreeMap<CommandFinalizationType, Integer>();
    private final Map<String, Integer> sgasCounter = new TreeMap<String, Integer>();
    private Map<CommandEvent.EventType, AtomicLong> finishedCmdsCount = new HashMap<CommandEvent.EventType, AtomicLong>();

    public static final SGAService getInstance() {
        return (SGAService)SGAService.getInstance("SGAService");
    }

    public final Vector<String> getAllSGANames() {
        Vector<String> sgas = new Vector<String>();
        Enumeration<String> names = this.registeredSGAs.keys();
        while (names.hasMoreElements()) {
            sgas.add(names.nextElement());
        }
        Collections.sort(sgas);
        return sgas;
    }

    public final SGAInfo[] getAllInfo(String sgaName) {
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null) {
            return null;
        }
        SGAInfo[] info = sga.getAllInfo();
        this.logSGAInfo(info, "(Enviado para o cliente)");
        return info;
    }

    public final CommandInfo getSGACommand(String sgaName, String cmdId) {
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null) {
            return null;
        }
        Command cmd = sga.getCommand(cmdId);
        if (cmd == null) {
            return null;
        }
        return cmd.createCommandInfo();
    }

    public Set<CommandInfo> getSGACommands(String sgaName) {
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null) {
            return null;
        }
        Object userId = Service.getUser().getId();
        boolean isAdmin = Service.getUser().isAdmin();
        HashSet<CommandInfo> commands = new HashSet<CommandInfo>();
        Command[] sgaCmds = sga.getAllCommands();
        ProjectService projectService = ProjectService.getInstance();
        Command[] commandArray = sgaCmds;
        int n = sgaCmds.length;
        int n2 = 0;
        while (n2 < n) {
            Command cmd = commandArray[n2];
            Object projectId = cmd.getProjectId();
            if (isAdmin || projectService.userHasAccess(projectId, userId)) {
                CommandInfo cmdInfo = cmd.createCommandInfo();
                commands.add(cmdInfo);
            }
            ++n2;
        }
        return Collections.unmodifiableSet(commands);
    }

    public final Vector<CommandInfo> getAllSGACommands() {
        Vector<CommandInfo> cmds = new Vector<CommandInfo>();
        Enumeration<SGA> sgas = this.registeredSGAs.elements();
        Object userId = Service.getUser().getId();
        boolean isAdmin = Service.getUser().isAdmin();
        ProjectService projectService = ProjectService.getInstance();
        while (sgas.hasMoreElements()) {
            Command[] sgaCmds;
            SGA sga = sgas.nextElement();
            Command[] commandArray = sgaCmds = sga.getAllCommands();
            int n = sgaCmds.length;
            int n2 = 0;
            while (n2 < n) {
                Command cmd = commandArray[n2];
                Object projectId = cmd.getProjectId();
                if (isAdmin || projectService.userHasAccess(projectId, userId)) {
                    CommandInfo cmdInfo = cmd.createCommandInfo();
                    cmds.add(cmdInfo);
                }
                ++n2;
            }
        }
        return cmds;
    }

    private Command getCommand(Object cmdId) {
        Enumeration<SGA> sgas = this.registeredSGAs.elements();
        while (sgas.hasMoreElements()) {
            Command[] sgaCmds;
            SGA sga = sgas.nextElement();
            Command[] commandArray = sgaCmds = sga.getAllCommands();
            int n = sgaCmds.length;
            int n2 = 0;
            while (n2 < n) {
                Command cmd = commandArray[n2];
                if (cmdId.equals(cmd.getId())) {
                    return cmd;
                }
                ++n2;
            }
        }
        return null;
    }

    public final SGAInfo getInfo(String sgaName, int index) {
        if (sgaName == null) {
            return null;
        }
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null) {
            return null;
        }
        SGAInfo info = sga.getInfo(index);
        this.logSGAInfo(info, "(Enviado para o cliente)");
        return info;
    }

    public List<ClientSGAFile> getChildren(String sgaName, String path) {
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null || !sga.isAlive()) {
            return null;
        }
        List<ClientSGAFile> allChildren = sga.getChildren(path);
        User user = Service.getUser();
        if (user == null) {
            return new ArrayList<ClientSGAFile>();
        }
        for (ClientSGAFile child : allChildren) {
            if (AccessSGAPathPermission.canReadPath((User)user, (String)sgaName, (String)child.getStringPath())) continue;
            child.setCanRead(false);
            child.setCanExecute(false);
            child.setCanWrite(false);
        }
        return allChildren;
    }

    public ClientSGAFile getFile(String sgaName, String path) {
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null || !sga.isAlive()) {
            return null;
        }
        ClientSGAFile file = sga.getFile(path);
        User user = Service.getUser();
        if (user == null || file == null) {
            return null;
        }
        if (!AccessSGAPathPermission.canReadPath((User)user, (String)sgaName, (String)path)) {
            file.setCanRead(false);
            file.setCanExecute(false);
            file.setCanWrite(false);
        }
        return file;
    }

    public final boolean updateSGAInfo(SGAServer sgaReference, String sgaName, SGADynamicInfo dynamicInfo) {
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null || sga.getRemoteReference() == null || !sgaReference.equals(sga.getRemoteReference())) {
            return false;
        }
        sga.updateSGAInfo(dynamicInfo);
        return true;
    }

    public final boolean isRegistered(SGAServer sgaReference, String sgaName) {
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null || sga.getRemoteReference() == null || !sgaReference.equals(sga.getRemoteReference())) {
            return false;
        }
        sga.patWatchDog();
        return true;
    }

    public final void setSGADisabled(String sgaName) {
        Server.logInfoMessage("Notifica\u00e7\u00e3o de desabilita\u00e7\u00e3o de SGA: " + sgaName);
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga != null) {
            sga.setEnabled(false);
        } else {
            Server.logWarningMessage("Desabilita\u00e7\u00e3o de SGA n\u00e3o registrado: " + sgaName);
        }
    }

    public final void setSGAEnabled(String sgaName) {
        SGA sga = this.registeredSGAs.get(sgaName);
        Server.logInfoMessage("Notifica\u00e7\u00e3o de habilita\u00e7\u00e3o de SGA: " + sgaName);
        if (sga != null) {
            sga.setEnabled(true);
        } else {
            Server.logWarningMessage("Habilita\u00e7\u00e3o de SGA n\u00e3o registrado: " + sgaName);
        }
    }

    public final SGASet getSGASet(String sgaName) {
        if (sgaName == null) {
            return null;
        }
        Server.logFineMessage("SGA[" + sgaName + "] Obtendo SGA.");
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null) {
            Server.logFineMessage("SGA[" + sgaName + "] SGA == null");
            return null;
        }
        Server.logFineMessage("SGA[" + sgaName + "] SGA obtido.");
        boolean denySelection = false;
        try {
            denySelection = sga.meetsRequirement("deny_node_selection");
            Server.logFineMessage("SGA[" + sgaName + "] sga.meetsRequirement(\"deny_node_selection\") = " + denySelection);
        }
        catch (Exception e) {
            denySelection = true;
            Server.logFineMessage("SGA[" + sgaName + "] sga.meetsRequirement(\"deny_node_selection\") = true devido a exce\u00e7\u00e3o. Exce\u00e7\u00e3o: " + e.getMessage());
        }
        boolean hasPermission = this.hasExecutionPermission(sgaName);
        Server.logFineMessage("SGA[" + sgaName + "] hasExecutionPermission(" + sgaName + ") = " + hasPermission);
        Object[] info = sga.getAllInfo();
        Server.logFineMessage("SGA[" + sgaName + "] Informa\u00e7\u00f5es do SGA obtidas " + Arrays.toString(info) + ".");
        this.logSGAInfo((SGAInfo[])info, "(Enviado para o cliente)");
        Server.logFineMessage("SGA[" + sgaName + "] Informa\u00e7\u00f5es logadas");
        boolean enabled = sga.getEnabled();
        Server.logFineMessage("SGA[" + sgaName + "] sga.getEnabled() = " + enabled);
        boolean alive = sga.isAlive();
        Server.logFineMessage("SGA[" + sgaName + "] sga.isAlive() = " + alive);
        boolean diskaccess = sga.hasDiskAccess();
        Server.logFineMessage("SGA[" + sgaName + "] sga.hasDiskAccess() = " + diskaccess);
        String jobsInfo = sga.getJobsInfo();
        Server.logFineMessage("SGA[" + sgaName + "] sga.getJobsInfo() = " + jobsInfo);
        boolean CSFSEnabled = sga.getCSFSHost() != null && sga.getCSFSRootDir() != null;
        SGASet sgaSet = new SGASet((SGAInfo[])info, sgaName, hasPermission && enabled, alive, diskaccess, jobsInfo, CSFSEnabled, !denySelection);
        Server.logFineMessage("SGA[" + sgaName + "] SGASet criado.");
        return sgaSet;
    }

    public final boolean setServerGroups(ServerGroupInfo[] groups) {
        try {
            String groupsFilePath = this.getUserSGAGroupFilePath();
            this.writeGroupsInfo(groupsFilePath, groups);
            return true;
        }
        catch (ServerException se) {
            Server.logSevereMessage("Falha atualizando grupos de servidores para " + Service.getUser().getId() + ": " + se.getMessage());
            return false;
        }
    }

    public boolean updateCommandDescription(String commandId, String description) {
        Command sgaCommand = this.getCommand(commandId);
        if (sgaCommand == null) {
            Server.logSevereMessage("Comando n\u00e3o encontrado: " + commandId);
            return false;
        }
        sgaCommand.getCommandInfo().setDescription(description);
        return true;
    }

    public final ServerGroupInfo[] getServerGroups() {
        try {
            String groupsFilePath = this.getUserSGAGroupFilePath();
            ServerGroupInfo[] info = this.readGroupsInfo(groupsFilePath);
            return info;
        }
        catch (ServerException se) {
            Server.logSevereMessage("Falha obtendo grupos de servidores para " + Service.getUser().getId() + ": " + se.getMessage());
            return null;
        }
    }

    public final int getUpdateInterval() {
        return sgaUpdateInterval;
    }

    public final int getCommandsUpdateInterval() {
        return sgaCommandUpdateInterval;
    }

    private void logAllAuditEvents() {
        Enumeration<SGA> sgas = this.registeredSGAs.elements();
        while (sgas.hasMoreElements()) {
            SGA sga = sgas.nextElement();
            if (!sga.isAlive() || !sga.getEnabled()) continue;
            sga.logAuditEvents();
        }
    }

    private void logAllAlgorithmHistoricEvents() {
        Enumeration<SGA> sgas = this.registeredSGAs.elements();
        while (sgas.hasMoreElements()) {
            boolean enableHistoric;
            SGA sga = sgas.nextElement();
            try {
                enableHistoric = sga.meetsRequirement("enable_historic");
            }
            catch (ServerException e) {
                enableHistoric = false;
            }
            if (!enableHistoric || !sga.isAlive() || !sga.getEnabled()) continue;
            sga.logAlgorithmHistoryEvents();
        }
    }

    public final boolean commandCompleted(String sgaName, SGACommand cmdReference, String cmdId, CompletedCommandInfo cmdInfo) {
        CommandEvent event;
        Command cmd;
        SGA sga;
        block16: {
            block15: {
                block14: {
                    block13: {
                        try {
                            sga = this.registeredSGAs.get(sgaName);
                            if (sga != null) break block13;
                            Server.logSevereMessage("Informa\u00e7\u00e3o de comando terminado em um SGA n\u00e3o cadastrado! [" + sgaName + "]");
                            return false;
                        }
                        catch (RuntimeException e) {
                            String errorMessage = "Erro na chamada do SGA ao completar o comando " + cmdId;
                            Server.logSevereMessage(errorMessage, e);
                            return false;
                        }
                    }
                    if (cmdReference != null) break block14;
                    Server.logSevereMessage("Comando nulo vindo como terminado no servidor [" + sgaName + "]!");
                    return true;
                }
                if (cmdInfo != null) break block15;
                Server.logSevereMessage("Informa\u00e7\u00e3o nula de fim de comando vinda do servidor [" + sgaName + "]!");
                return true;
            }
            cmd = sga.getCommand(cmdId);
            event = null;
            if (cmd != null) break block16;
            String errorMessage = "N\u00e3o foi encontrado no servidor um comando identificado como finalizado pelo SGA.\n";
            Server.logSevereMessage(String.valueOf(errorMessage) + "\tCausa: " + errorMessage + "\n\tId: " + cmdId + "\n\n");
            event = new CommandEvent((Object)cmdId, CommandEvent.EventType.INIT_FAILURE, (CommandFinalizationInfo)new SimpleCommandFinalizationInfo(CommandFinalizationType.FAILED, FailureFinalizationType.COMMAND_IDENTIFIER_NOT_FOUND));
            this.notifyCommandEnd(null, event);
            return true;
        }
        sga.finishCommand(cmdId);
        Integer elapsedTimeSec = cmdInfo.elapsedTimeSec < 0 ? null : Integer.valueOf(cmdInfo.elapsedTimeSec);
        Integer userTimeSec = cmdInfo.userTimeSec < 0 ? null : Integer.valueOf(cmdInfo.userTimeSec);
        Integer cpuTimeSec = cmdInfo.cpuTimeSec < 0 ? null : Integer.valueOf(cmdInfo.cpuTimeSec);
        CommandInfo commandInfo = cmd.getCommandInfo();
        commandInfo.setWallTimeSec(elapsedTimeSec);
        if (cmd.finish(cmdInfo)) {
            CommandEvent.EventType type;
            switch (commandInfo.getFinalizationType()) {
                case SUCCESS: {
                    type = CommandEvent.EventType.SUCCESS;
                    break;
                }
                case EXECUTION_ERROR: {
                    type = CommandEvent.EventType.ERROR;
                    break;
                }
                case NO_EXIT_CODE: {
                    type = CommandEvent.EventType.NO_CODE;
                    break;
                }
                default: {
                    type = CommandEvent.EventType.COMPLETED;
                }
            }
            event = new CommandEvent((Object)cmdId, type, commandInfo.getFinalizationInfo(), elapsedTimeSec, userTimeSec, cpuTimeSec);
        } else {
            event = new CommandEvent((Object)cmdId, CommandEvent.EventType.INIT_FAILURE, commandInfo.getFinalizationInfo());
        }
        this.notifyCommandEnd(cmd, event);
        return true;
    }

    public final boolean commandLost(String sgaName, String cmdId) {
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null) {
            Server.logSevereMessage("Informa\u00e7\u00e3o de comando n\u00e3o recuperado em um SGA n\u00e3o cadastrado! [" + sgaName + "]");
            return false;
        }
        Server.logWarningMessage("Informa\u00e7\u00e3o de comando n\u00e3o recuperado vinda do servidor [" + sgaName + "]!");
        Command cmd = sga.getCommand(cmdId);
        sga.lostCommand(cmdId);
        if (cmd == null) {
            Server.logSevereMessage("Informa\u00e7\u00e3o de comando n\u00e3o existente vinda do servidor [" + sgaName + "]!");
            return true;
        }
        CommandEvent event = new CommandEvent((Object)cmdId, CommandEvent.EventType.LOST, cmd.getFinalizationInfo());
        this.notifyCommandEnd(cmd, event);
        return true;
    }

    public final void executeCommand(CommandInfo command) throws PermissionException, SGANotAvailableException, ProjectNotFoundException {
        String sgaName = command.getSGAName();
        this.checkExecutionPermission(sgaName);
        String tip = command.getTip();
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null) {
            String err = "O SGA selecionado para execu\u00e7\u00e3o n\u00e3o est\u00e1 registrado: " + sgaName;
            String algoStr = "Algoritmo: " + tip;
            throw new SGANotAvailableException(String.valueOf(err) + "\n\t" + algoStr + "\n");
        }
        if (!sga.mayExecuteCommand()) {
            String err = "O SGA selecionado para execu\u00e7\u00e3o n\u00e3o est\u00e1 ativo/habilitado: " + sgaName;
            String algoStr = "Algoritmo: " + tip;
            throw new SGANotAvailableException(String.valueOf(err) + "\n\t" + algoStr + "\n");
        }
        try {
            sga.executeCommand(null, command, this.cmdExpirationInfoDelay, this.executeCommandAsScript, this.logCommandLineInfo);
        }
        finally {
            this.collectSGAStats(command);
        }
    }

    private final void initORB() throws ServerException {
        try {
            Server.logInfoMessage("Acessando ambiente ORB...");
            Properties props = this.getExternalPropertyFile("ORB.file");
            if (!this.isPropertyNull("ORB.port")) {
                int port = this.getIntProperty("ORB.port");
                String portStr = Integer.toString(port);
                props.setProperty("OAPort", portStr);
            }
            if (!this.isPropertyNull("ORB.hostAddr")) {
                String addr = this.getStringProperty("ORB.hostAddr");
                props.setProperty("OAIAddr", addr);
            }
            this.orbHandler = new ORBHandler(props);
            Server.logInfoMessage("Acesso ao ambiente ORB inicializado");
        }
        catch (ORBException e) {
            throw new ServerException("Imposs\u00edvel criar servidor CORBA: " + e.getMessage(), e);
        }
        try {
            this.sgaHandler = new SGAHandler(this);
            this.orbHandler.activateObject("SGAManager", (Servant)this.sgaHandler);
        }
        catch (Exception e) {
            throw new ServerException("Imposs\u00edvel criar handler de SGA's", e);
        }
        Server.logInfoMessage("Acesso ao ambiente ORB inicializado");
    }

    void createTransferRateAcquisitionThread() {
        Server.logFineMessage("Preparando a cria\u00e7\u00e3o de thread para a coleta das taxas de transfer\u00eancia em rede...");
        this.acquisitionNetDataThread = new TransferRateAcquisitionThread();
        this.acquisitionNetDataThread.setName(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "::" + "TransferRateAcquisitionThread");
        this.acquisitionNetDataThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initService() throws ServerException {
        this.initORB();
        this.messageService = MessageService.getInstance();
        this.createDataAcquisitionThread();
        this.createAuditThread();
        this.doSGALog = this.getBooleanProperty("sgaLogDynamicInfo");
        this.numberHostsLog = this.getIntProperty("sgaLogNumberHostsCluster");
        Class<SGAService> clazz = SGAService.class;
        synchronized (SGAService.class) {
            sgaCommandUpdateInterval = this.getIntProperty("sgaCommandUpdateIntervalSeconds");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.cmdExpirationInfoDelay = this.getIntProperty("cmdExpirationInfoDelay");
            this.executeCommandAsScript = this.getBooleanProperty("executeCommandAsScript");
            this.logCommandLineInfo = this.getBooleanProperty("logCommandLineInfo");
            this.createExecutionHistoricThread();
            this.timeout = this.getLongProperty("Timeout");
            String msg = this.timeout < 0L ? "Timeout na conex\u00e3o com o SGA desativado" : "Timeout para as chamadas ao SGA (seg): " + this.timeout;
            Server.logInfoMessage(msg);
            this.csfsUpdateProjectAreaDelay = this.getIntProperty("csfsUpdateProjectAreaDelay");
            Class<SGAService> clazz2 = SGAService.class;
            synchronized (SGAService.class) {
                netBenchDuration = this.getIntProperty("netBenchDuration");
                iperfTimeout = this.getIntProperty("iperfTimeout") * 1000;
                updateDataTransferRate = this.getIntProperty("updateDataTransferRate") * 1000;
                executeNetBenchmark = this.getBooleanProperty("executeNetBenchmark");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                if (executeNetBenchmark) {
                    Server.logInfoMessage("Coleta das taxas de transfer\u00eancia em rede habilitada.");
                    this.createTransferRateAcquisitionThread();
                } else {
                    Server.logInfoMessage("Coleta das taxas de transfer\u00eancia em rede desabilitada.");
                }
                return;
            }
        }
    }

    private void notifyAllUsersSGA(String sgaName, int sgaFlag) {
        List users;
        try {
            users = User.getAllUsers();
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao obter usu\u00e1rios.", e);
            return;
        }
        for (User user : users) {
            AttributesPermission sgaAdminPermission = null;
            AttributesPermission sgaNotificationPermission = null;
            try {
                sgaAdminPermission = user.getMatchAttributesPermission(SGAAdminPermission.class, sgaName);
                sgaNotificationPermission = user.getMatchAttributesPermission(SGANotificationPermission.class, sgaName);
            }
            catch (Exception e) {
                String errorMsg = String.format("Falha ao buscar as permiss\u00f5es para os usu\u00e1rios de ger\u00eancia e notifica\u00e7\u00e3o sobre servidor de execu\u00e7\u00e3o de algoritmos %s.", sgaName);
                Server.logSevereMessage(errorMsg, e);
            }
            if (!user.isAdmin() && sgaAdminPermission == null && sgaNotificationPermission == null) continue;
            SGAService.setUserId(user.getId());
            try {
                try {
                    Server.logFineMessage("Obtendo SGASet de " + sgaName);
                    SGASet set = this.getSGASet(sgaName);
                    Server.logFineMessage("SGASet obtido de " + sgaName);
                    SGANotification data = new SGANotification(this.getSenderName(), sgaFlag, set);
                    this.messageService.send(new Message((Serializable)data), 0L, user.getLogin());
                }
                catch (Exception e) {
                    Server.logSevereMessage("Falha de notifica\u00e7\u00e3o some-users: " + e.getMessage(), e);
                    SGAService.setUserId(null);
                    continue;
                }
            }
            catch (Throwable throwable) {
                SGAService.setUserId(null);
                throw throwable;
            }
            SGAService.setUserId(null);
        }
    }

    void notifyCommandEndToProject(Command command, CommandEvent event) {
        CommandWithNoExitCodeNotification notData;
        if (command == null) {
            Server.logSevereMessage("O comando " + event.getCommandId() + " n\u00e3o foi encontrado.\n");
            return;
        }
        this.finishedCmdsCount.get(event.getType()).incrementAndGet();
        StringBuilder infoMsg = new StringBuilder("[FIM DE COMANDO] CmdId[").append(event.getCommandId()).append("] ").append(event.getType().name()).append(". SGAService: ");
        CommandEvent.EventType[] eventTypeArray = CommandEvent.EventType.values();
        int n = eventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandEvent.EventType type = eventTypeArray[n2];
            infoMsg.append(" ").append(type.name()).append(": ").append(this.finishedCmdsCount.get(type).get());
            ++n2;
        }
        Server.logInfoMessage(infoMsg.toString());
        switch (event.getType()) {
            case COMPLETED: {
                notData = this.createCommandEndNotificationData(command, event.getElapsedTime(), event.getUserTime(), event.getCpuTime());
                break;
            }
            case SUCCESS: {
                notData = this.createCommandSuccessNotificationData(command, event.getElapsedTime(), event.getUserTime(), event.getCpuTime());
                break;
            }
            case NO_CODE: {
                notData = this.createCommandWithNoExitCodeNotificationData(command);
                break;
            }
            case ERROR: {
                notData = this.createCommandErrorNotificationData(command);
                break;
            }
            case LOST: {
                notData = this.createCommandLostNotificationData(command);
                break;
            }
            case KILLED: {
                notData = this.createCommandKilledNotificationData(command);
                break;
            }
            case INIT_FAILURE: {
                notData = this.createCommandFailedNotificationData(command);
                break;
            }
            default: {
                Server.logSevereMessage("Tipo de evento desconhecido: " + event.getType() + ".\n");
                return;
            }
        }
        this.messageService.sendToServer(new Message((Serializable)notData));
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(command.getProjectId());
            this.messageService.send(new Message((Serializable)notData), users);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + command.getProjectName() + " o fim da execu\u00e7\u00e3o do comando (" + command.getId() + ")", e);
        }
    }

    private CommandEndNotification createCommandEndNotificationData(Command command, Integer elapsedTimeSec, Integer userTimeSec, Integer cpuTimeSec) {
        long now = Calendar.getInstance().getTimeInMillis();
        CommandEndNotification notData = new CommandEndNotification(this.getSenderName(), (Object)command.getId(), command.getDescription(), command.getTip(), elapsedTimeSec, userTimeSec, cpuTimeSec, command.getStartTime(), now, command.getSGA().getName(), command.getProjectId(), command.getFinalizationInfo());
        return notData;
    }

    private CommandSuccessNotification createCommandSuccessNotificationData(Command command, Integer elapsedTimeSec, Integer userTimeSec, Integer cpuTimeSec) {
        long now = Calendar.getInstance().getTimeInMillis();
        CommandSuccessNotification notData = new CommandSuccessNotification(this.getSenderName(), (Object)command.getId(), command.getDescription(), command.getTip(), elapsedTimeSec, userTimeSec, cpuTimeSec, command.getStartTime(), now, command.getSGA().getName(), command.getProjectId(), command.getFinalizationInfo());
        return notData;
    }

    private CommandLostNotification createCommandLostNotificationData(Command command) {
        CommandLostNotification notData = new CommandLostNotification(this.getSenderName(), (Object)command.getId(), command.getDescription(), command.getTip(), command.getStartTime(), command.getSGA().getName(), command.getProjectId(), command.getFinalizationInfo());
        return notData;
    }

    private CommandFailedNotification createCommandFailedNotificationData(Command command) {
        CommandFailedNotification notData = new CommandFailedNotification(this.getSenderName(), (Object)command.getId(), command.getDescription(), command.getTip(), command.getStartTime(), command.getSGA().getName(), command.getProjectId(), command.getFinalizationInfo());
        return notData;
    }

    private CommandErrorNotification createCommandErrorNotificationData(Command command) {
        CommandErrorNotification notData = new CommandErrorNotification(this.getSenderName(), (Object)command.getId(), command.getDescription(), command.getTip(), command.getStartTime(), command.getSGA().getName(), command.getProjectId(), command.getFinalizationInfo());
        return notData;
    }

    private CommandWithNoExitCodeNotification createCommandWithNoExitCodeNotificationData(Command command) {
        CommandWithNoExitCodeNotification notData = new CommandWithNoExitCodeNotification(this.getSenderName(), (Object)command.getId(), command.getDescription(), command.getTip(), command.getStartTime(), command.getSGA().getName(), command.getProjectId(), command.getFinalizationInfo());
        return notData;
    }

    private CommandKilledNotification createCommandKilledNotificationData(Command command) {
        CommandKilledNotification notData = new CommandKilledNotification(this.getSenderName(), (Object)command.getId(), command.getDescription(), command.getTip(), command.getStartTime(), command.getSGA().getName(), command.getProjectId(), command.getFinalizationInfo());
        return notData;
    }

    private void mailCommandEndToProject(Command command, CommandEvent event) {
        if (command == null) {
            Server.logSevereMessage("O comando " + event.getCommandId() + " n\u00e3o foi encontrado.\n");
            return;
        }
        if (event.getType() == CommandEvent.EventType.KILLED || !command.requireMail()) {
            return;
        }
        SGA sga = command.getSGA();
        String eventTypeString = this.getString("SGAService.mail.type.command." + event.getType());
        String content = String.format(this.getString("SGAService.mail.content"), eventTypeString, sga.getName(), sga.getPlatformId(), command.getProjectName(), command.getId(), command.getDescription());
        if (event.getType() == CommandEvent.EventType.COMPLETED || event.getType() == CommandEvent.EventType.ERROR || event.getType() == CommandEvent.EventType.SUCCESS || event.getType() == CommandEvent.EventType.NO_CODE) {
            String unknown = this.getString("SGAService.value.unknown");
            Integer cpuTimeSec = event.getCpuTime();
            String cpuTimeString = cpuTimeSec != null ? FormatUtils.formatInterval((int)cpuTimeSec) : unknown;
            Integer userTimeSec = event.getUserTime();
            String userTimeString = userTimeSec != null ? FormatUtils.formatInterval((int)userTimeSec) : unknown;
            Integer elapsedTimeSec = event.getElapsedTime();
            String elapsedTimeString = elapsedTimeSec != null ? FormatUtils.formatInterval((int)elapsedTimeSec) : unknown;
            String executionTimeContent = String.format(this.getString("SGAService.mail.content.execution.time"), cpuTimeString, userTimeString, elapsedTimeString);
            content = String.valueOf(content) + executionTimeContent;
            try {
                AlgorithmConfigurator configurator = command.getCommandInfo().getConfigurator();
                if (configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.SIMPLE) {
                    SimpleAlgorithmConfigurator simpleConfigurator = (SimpleAlgorithmConfigurator)configurator;
                    List paramGroups = simpleConfigurator.getGroups();
                    ParametersReportMaker visitor = new ParametersReportMaker();
                    content = String.valueOf(content) + String.format(this.getString("SGAService.mail.content.params.title"), visitor.makeReport(paramGroups));
                }
            }
            catch (RemoteException e) {
                content = String.valueOf(content) + this.getString("SGAService.mail.content.params.error");
                Server.logSevereMessage("Ocorreu um erro na tentativa de obter o configurador do comando " + command.getId() + ".\n", e);
            }
        }
        Object userId = command.getUserId();
        try {
            this.mailUser(userId, content);
        }
        catch (Exception e) {
            Server.logSevereMessage("Imposs\u00edvel enviar mail para o usu\u00e1rio (" + userId + ") " + "por fim de comando (" + command.getId() + ")!\n", e);
        }
        String[] aditionalEmails = command.getEmailList();
        if (aditionalEmails != null) {
            String[] stringArray = aditionalEmails;
            int n = aditionalEmails.length;
            int n2 = 0;
            while (n2 < n) {
                String email = stringArray[n2];
                try {
                    this.mailUser(email, content);
                }
                catch (Exception e) {
                    Server.logSevereMessage("Imposs\u00edvel enviar mail para o endere\u00e7o (" + email + ") " + "por fim de comando (" + command.getId() + ")!\n", e);
                }
                ++n2;
            }
        }
    }

    private void mailUser(Object userId, String content) {
        MailService mailService = MailService.getInstance();
        if (!mailService.mailUserFromService(this, userId, content)) {
            Server.logSevereMessage("Falha de mail ao usu\u00e1rio [" + userId + "]: " + content);
        }
    }

    private void mailUser(String email, String content) {
        MailService mailService = MailService.getInstance();
        if (!mailService.mailFromService(this, new String[]{email}, content)) {
            Server.logSevereMessage("Falha de mail para o endere\u00e7o [" + email + "]: " + content);
        }
    }

    public synchronized boolean killCommand(String cmdId) {
        Command cmd = this.getCommand(cmdId);
        return this.killCommand(cmd);
    }

    public synchronized boolean killCommand(String sgaName, String cmdId) {
        SGA sga = this.registeredSGAs.get(sgaName);
        Command cmd = sga.getCommand(cmdId);
        return this.killCommand(cmd);
    }

    private boolean killCommand(Command cmd) {
        if (cmd == null) {
            return false;
        }
        if (!cmd.getStatus().equals((Object)CommandStatus.EXECUTING)) {
            return false;
        }
        SGA sga = cmd.getSGA();
        try {
            return this.doKill(cmd, sga);
        }
        catch (PermissionException pe) {
            throw pe;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha ao cancelar comando " + cmd.getId() + " do usu\u00e1rio " + Service.getUser().getId() + ": " + e.getMessage(), e);
            return false;
        }
    }

    private boolean doKill(Command cmd, SGA sga) throws ServerException, PermissionException {
        String cmdId = cmd.getId();
        Object commandOwnerId = cmd.getUserId();
        ProjectService projectService = ProjectService.getInstance();
        Object projectId = cmd.getProjectId();
        Object projectOwnerId = projectService.getOwnerId(projectId);
        User loggedUser = Service.getUser();
        Object loggedUserId = loggedUser.getId();
        if (!(loggedUser.isAdmin() || loggedUserId.equals(commandOwnerId) || loggedUserId.equals(projectOwnerId))) {
            throw new PermissionException();
        }
        if (!sga.killCommand(cmdId)) {
            return false;
        }
        CommandEvent event = new CommandEvent((Object)cmdId, CommandEvent.EventType.KILLED, cmd.getFinalizationInfo());
        this.notifyCommandEnd(cmd, event);
        return true;
    }

    public synchronized void killCommandAnyway(String sgaName, String cmdId) throws PermissionException {
        this.checkSGAAdministrationPermission();
        SGA sga = this.registeredSGAs.get(sgaName);
        Command cmd = sga.getCommand(cmdId);
        if (cmd == null) {
            return;
        }
        sga.killCommandAnyway(cmdId);
        CommandEvent event = new CommandEvent((Object)cmdId, CommandEvent.EventType.KILLED, cmd.getFinalizationInfo());
        this.notifyCommandEnd(cmd, event);
    }

    private boolean lockSGA(String sgaName) {
        return this.lockSGAs.add(sgaName);
    }

    private void unlockSGA(String sgaName) {
        this.lockSGAs.remove(sgaName);
    }

    public boolean registerSGA(SGAServer sgaReference, String sgaName, StaticNodeInfo[] staticNodesInfo, IntHolder updateInterval) {
        Server.logInfoMessage("Detectado pedido de registro de SGA: " + sgaName);
        updateInterval.value = sgaUpdateInterval;
        try {
            int flag;
            block20: {
                if (!this.lockSGA(sgaName)) {
                    Server.logSevereMessage("Falha de registro de SGA: " + sgaName + ". SGA j\u00e1 est\u00e1 em fase de registro.");
                    return false;
                }
                SGA sga = this.registeredSGAs.get(sgaName);
                if (sga != null && sga.getRemoteReference() != null && !sgaReference.equals(sga.getRemoteReference())) {
                    Server.logWarningMessage("Detectado SGA " + sgaName + " como j\u00e1 registrado!");
                    return false;
                }
                if (this.timeout >= 0L) {
                    try {
                        this.orbHandler.setTimeOut(sgaReference, this.timeout);
                    }
                    catch (Exception e) {
                        Server.logSevereMessage("Erro configurando o timeout do SGA: " + sgaName, e);
                    }
                }
                try {
                    if (sga == null) {
                        Server.logInfoMessage("Detectado SGA " + sgaName + " como novo!");
                        sga = new SGA(this, sgaName, sgaReference, staticNodesInfo);
                        this.registeredSGAs.put(sgaName, sga);
                        Server.logInfoMessage(String.valueOf(sgaName) + " com plataforma " + sga.getPlatformId() + " inclu\u00eddo no gerente de SGA's.");
                        flag = 0;
                        if (executeNetBenchmark) {
                            try {
                                if (sga.execNetBench() == -1) {
                                    sga.setTransferRate(-1L);
                                    break block20;
                                }
                                sga.setTransferRate(-2L);
                            }
                            catch (ServerException e) {
                                Server.logSevereMessage("Falha na determina\u00e7\u00e3o se o benchmark de rede deve ser executado para o SGA: " + sga.getName() + ".", e);
                                sga.setTransferRate(-1L);
                            }
                            break block20;
                        }
                        sga.setTransferRate(-1L);
                        break block20;
                    }
                    Server.logInfoMessage("Detectado SGA " + sgaName + " como pr\u00e9-existente!");
                    sga.updateSGA(sgaReference, staticNodesInfo);
                    Server.logInfoMessage(String.valueOf(sgaName) + " refez registro no gerente de SGA's.");
                    flag = 2;
                }
                catch (Exception e) {
                    Server.logSevereMessage("Falha de registro de SGA: " + sgaName + ". " + e.getClass() + ": " + e.getMessage(), e);
                    this.unlockSGA(sgaName);
                    return false;
                }
            }
            try {
                this.notifyAllUsersSGA(sgaName, flag);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha de notifica\u00e7\u00e3o aos usu\u00e1rios sobre registro de SGA's (" + sgaName + ").", e);
            }
        }
        finally {
            this.unlockSGA(sgaName);
        }
        return true;
    }

    public Collection<String> shutdownAllSGAs() throws PermissionException {
        this.checkSGAAdministrationPermission();
        HashSet<String> sgas_failed = new HashSet<String>();
        Server.logInfoMessage("Notificando SGAs para shutdown...");
        Enumeration<SGA> sgas = this.registeredSGAs.elements();
        while (sgas.hasMoreElements()) {
            SGA sga = sgas.nextElement();
            if (this._shutdownSGA(sga)) continue;
            sgas_failed.add(sga.getName());
        }
        return sgas_failed;
    }

    public Collection<String> restartAllSGAs() throws PermissionException {
        this.checkSGAAdministrationPermission();
        HashSet<String> sgas_failed = new HashSet<String>();
        Server.logInfoMessage("Notificando SGAs para restart...");
        Enumeration<SGA> sgas = this.registeredSGAs.elements();
        while (sgas.hasMoreElements()) {
            SGA sga = sgas.nextElement();
            if (this._restartSGA(sga)) continue;
            sgas_failed.add(sga.getName());
        }
        return sgas_failed;
    }

    public boolean shutdownSGA(String sgaName) throws PermissionException {
        this.checkSGAAdministrationPermission();
        Server.logInfoMessage("Notificando SGA " + sgaName + " para shutdown...");
        SGA sga = this.registeredSGAs.get(sgaName);
        return this._shutdownSGA(sga);
    }

    private boolean _shutdownSGA(SGA sga) {
        try {
            sga.shutdownSGA();
            this.notifyAllUsersSGA(sga.getName(), 1);
            return true;
        }
        catch (ServerException e) {
            Server.logSevereMessage(e.getMessage(), e);
            return false;
        }
    }

    public boolean restartSGA(String sgaName) throws PermissionException {
        this.checkSGAAdministrationPermission();
        Server.logInfoMessage("Notificando SGA " + sgaName + " para restart...");
        SGA sga = this.registeredSGAs.get(sgaName);
        return this._restartSGA(sga);
    }

    private boolean _restartSGA(SGA sga) {
        try {
            sga.restartSGA();
            return true;
        }
        catch (ServerException e) {
            Server.logSevereMessage(e.getMessage(), e);
            return false;
        }
    }

    public boolean commandRetrieved(String sgaName, RetrievedInfo[] cmds) {
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga != null) {
            try {
                Command[] sgaCmds;
                RetrievedInfo[] retrievedInfoArray = cmds;
                int n = cmds.length;
                int n2 = 0;
                while (n2 < n) {
                    RetrievedInfo info = retrievedInfoArray[n2];
                    Command cmd = sga.getCommand(info.cmdId);
                    if (cmd != null) {
                        Service.setUserId(cmd.getUserId());
                    }
                    Server.logInfoMessage("Informa\u00e7\u00e3o de comando recuperado (" + sgaName + "): " + info.cmdId);
                    sga.commandRetrieved(info.cmdId, info.cmdRef);
                    Service.setUserId(null);
                    ++n2;
                }
                Command[] commandArray = sgaCmds = sga.getAllCommands();
                int n3 = sgaCmds.length;
                n = 0;
                while (n < n3) {
                    Command sgaCmd;
                    Command cmd = sgaCmd = commandArray[n];
                    Service.setUserId(cmd.getUserId());
                    String cmdId = cmd.getId();
                    if (!cmd.isAlive()) {
                        Server.logSevereMessage("Comando n\u00e3o encontrado [" + sgaName + "]: " + cmdId + "!");
                        sga.lostCommand(cmdId);
                        CommandEvent event = new CommandEvent((Object)cmdId, CommandEvent.EventType.LOST, cmd.getFinalizationInfo());
                        this.notifyCommandEnd(cmd, event);
                    }
                    ++n;
                }
                return true;
            }
            finally {
                Service.setUserId(null);
            }
        }
        Server.logWarningMessage("SGA n\u00e3o registrado: " + sgaName);
        return false;
    }

    @Override
    public void shutdownService() throws ServerException {
        this.exitAcquisitionDataThread = true;
        this.exitAuditThread = true;
        if (this.acquisitionDataThread != null) {
            this.acquisitionDataThread.interrupt();
        }
        if (this.auditThread != null) {
            this.auditThread.interrupt();
        }
        if (this.acquisitionNetDataThread != null) {
            this.acquisitionNetDataThread.interrupt();
        }
        Enumeration<SGA> sgas = this.registeredSGAs.elements();
        while (sgas.hasMoreElements()) {
            SGA sga = sgas.nextElement();
            sga.stop();
        }
        try {
            if (this.orbHandler != null) {
                this.orbHandler.shutdown();
            }
            this.sgaHandler = null;
            this.orbHandler = null;
        }
        catch (ORBException e) {
            throw new ServerException("Imposs\u00edvel desativar servidor CORBA", e);
        }
    }

    public void unregisterSGA(SGAServer sgaReference, String sgaName) {
        Server.logInfoMessage("Pedido de de-registro de SGA: " + sgaName);
        SGA sga = this.registeredSGAs.get(sgaName);
        if (sga == null || sga.getRemoteReference() == null || !sgaReference.equals(sga.getRemoteReference())) {
            Server.logWarningMessage("De-registro de SGA n\u00e3o registrado: " + sgaName);
            return;
        }
        this.registeredSGAs.remove(sgaName);
    }

    private String getUserSGAGroupFilePath() throws ServerException {
        User user = Service.getUser();
        try {
            if (user == null) {
                throw new ServerException("getUserSGAGroupFilePath: Usu\u00e1rio n\u00e3o cadastrado");
            }
            String fileName = "groups.dat";
            String sep = File.separator;
            Server server = Server.getInstance();
            String persistDirPath = server.getPersistencyRootDirectoryName();
            String dirPath = String.valueOf(persistDirPath) + sep + SGA_GROUPS_SUBDIR_NAME + sep + user.getLogin();
            Server.checkDirectory(dirPath);
            String filePath = String.valueOf(dirPath) + sep + "groups.dat";
            return filePath;
        }
        catch (Exception ue) {
            throw new ServerException("getUserDirPath: Falha obtendo informa\u00e7\u00f5es do usu\u00e1rio (" + ue.getMessage() + ")");
        }
    }

    private void checkExecutionPermission(String sgaName) throws PermissionException {
        if (!this.hasExecutionPermission(sgaName)) {
            throw new PermissionException();
        }
    }

    private boolean hasExecutionPermission(String sgaName) {
        User user = Service.getUser();
        if (user == null) {
            return false;
        }
        if (user.isAdmin()) {
            return true;
        }
        AttributesPermission p = null;
        try {
            p = user.getMatchAttributesPermission(ServerExecutionPermission.class, sgaName);
        }
        catch (Exception e) {
            String errorMsg = String.format("Ocorreu um erro ao buscar a permiss\u00e3o para executar comandos no servidor %s para o usu\u00e1rio %s.", sgaName, user.getLogin());
            Server.logSevereMessage(errorMsg, e);
        }
        return p != null;
    }

    private void checkSGAAdministrationPermission() throws PermissionException {
        User user = Service.getUser();
        if (user.isAdmin()) {
            return;
        }
        Server server = Server.getInstance();
        String serverName = "local=" + server.getSystemName();
        AttributesPermission p = null;
        try {
            p = user.getMatchAttributesPermission(SGAAdminPermission.class, serverName);
        }
        catch (Exception e) {
            String errorMsg = String.format("Ocorreu um erro ao buscar a permiss\u00e3o para gerenciar o servidor de execu\u00e7\u00e3o %s para o usu\u00e1rio %s.", serverName, user.getLogin());
            Server.logSevereMessage(errorMsg, e);
        }
        if (p == null) {
            throw new PermissionException();
        }
    }

    private void createAuditThread() {
        boolean activeDump = this.getBooleanProperty("activeDump");
        if (!activeDump) {
            Server.logInfoMessage("AUDITAGEM DOS SGAs DESATIVADA! (activeDump)");
            this.auditThread = null;
            return;
        }
        Server.logInfoMessage("Grava\u00e7\u00e3o de dados dos SGAs ativa.");
        Server.logFineMessage("Preparando a cria\u00e7\u00e3o de thread de auditagem...");
        boolean ONE_SECOND = true;
        int ONE_MINUTE = 60;
        int ONE_HOUR = 3600;
        int dump = this.getIntProperty("dumpIntervalSeconds");
        if (dump < 1) {
            dump = 1;
        }
        if (dump > 3600) {
            dump = 3600;
        }
        final long sleepTimeMs = dump * 1000;
        Server.logInfoMessage("Intervalo de grava\u00e7\u00e3o dos SGAs: " + dump + " segundos.");
        this.auditThread = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        if (SGAService.this.exitAuditThread) {
                            Server.logWarningMessage("Finalizando thread de grava\u00e7\u00e3o de dados...");
                            return;
                        }
                        try {
                            SGAService.this.logAllAuditEvents();
                            Thread.sleep(sleepTimeMs);
                        }
                        catch (InterruptedException ie) {
                            Server.logWarningMessage("Grava\u00e7\u00e3o de dados do SGA interrompido!");
                        }
                    }
                }
                catch (Throwable t) {
                    String msg = new Date() + " - Erro na auditagem de SGAs:";
                    System.err.println(msg);
                    t.printStackTrace(System.err);
                    Server.logSevereMessage(msg, t);
                }
            }
        });
        this.exitAuditThread = false;
        this.auditThread.setName(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "::" + "AuditThread");
        this.auditThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataAcquisitionThread() {
        Class<SGAService> clazz = SGAService.class;
        synchronized (SGAService.class) {
            sgaWatchdogInterval = this.getIntProperty("sgaWatchdogIntervalSeconds");
            sgaUpdateInterval = this.getIntProperty("sgaUpdateIntervalSeconds");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            final long updateSleepTime = (long)sgaWatchdogInterval * 1000L;
            this.acquisitionDataThread = new Thread(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            if (SGAService.this.exitAcquisitionDataThread) {
                                Server.logWarningMessage("Finalizando thread de aquisi\u00e7\u00e3o de dados...");
                                return;
                            }
                            SGAService.this.updateAllSGAs();
                            try {
                                Thread.sleep(updateSleepTime);
                            }
                            catch (InterruptedException ie) {
                                Server.logWarningMessage("Aquisi\u00e7\u00e3o de dados do SGA interrompido!");
                            }
                        }
                    }
                    catch (Throwable t) {
                        String msg = new Date() + " - Erro na aquisi\u00e7\u00e3o de dados de SGAs:";
                        System.err.println(msg);
                        t.printStackTrace(System.err);
                        Server.logSevereMessage(msg, t);
                    }
                }
            });
            this.exitAcquisitionDataThread = false;
            this.acquisitionDataThread.setName(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "::" + "AcquisitionDataThread");
            this.acquisitionDataThread.start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExecutionHistoricThread() {
        boolean createHistoric = this.getBooleanProperty("sgaLogAlgorithmExecutionHistoric");
        if (!createHistoric) {
            Server.logInfoMessage("AUDITAGEM DE EXECU\u00c7\u00c3O DOS ALGORITMOS DESATIVADA! (sgaLogAlgorithmExecutionHistory)");
            this.historicThread = null;
            return;
        }
        Server.logInfoMessage("Grava\u00e7\u00e3o de hist\u00f3rico dos algoritmos ativa.");
        Server.logFineMessage("Preparando a cria\u00e7\u00e3o de thread de auditagem de execu\u00e7\u00e3o dos algoritmos...");
        Class<SGAService> clazz = SGAService.class;
        synchronized (SGAService.class) {
            sgaHistoricUpdateIntervalSeconds = this.getIntProperty("sgaHistoricUpdateIntervalSeconds");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            final long sleepTimeMs = sgaHistoricUpdateIntervalSeconds * 1000;
            Server.logInfoMessage("Intervalo de grava\u00e7\u00e3o do hist\u00f3rico dos algoritmos: " + sgaHistoricUpdateIntervalSeconds + " segundos.");
            this.historicThread = new Thread(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            if (SGAService.this.exitHistoricThread) {
                                Server.logWarningMessage("Finalizando thread de grava\u00e7\u00e3o de dados de hist\u00f3rico de execu\u00e7\u00e3o...");
                                return;
                            }
                            try {
                                SGAService.this.logAllAlgorithmHistoricEvents();
                                Thread.sleep(sleepTimeMs);
                            }
                            catch (InterruptedException ie) {
                                Server.logWarningMessage("Grava\u00e7\u00e3o de dados de execu\u00e7\u00e3o dos algoritmos interrompida!");
                            }
                        }
                    }
                    catch (Throwable t) {
                        String msg = new Date() + " - Erro na auditagem de execu\u00e7\u00e3o de algoritmos:";
                        Server.logSevereMessage(msg, t);
                    }
                }
            });
            this.exitHistoricThread = false;
            this.historicThread.setName(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "::" + "HistoricThread");
            this.historicThread.start();
            return;
        }
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    private void notifyCommandEnd(Command command, CommandEvent event) {
        this.collectExeResultsStats(command, event);
        this.notifyCommandEndToProject(command, event);
        this.mailCommandEndToProject(command, event);
    }

    private void collectExeResultsStats(Command command, CommandEvent event) {
        if (command == null) {
            return;
        }
        CommandFinalizationInfo finalizationInfo = event.getFinalizationInfo();
        CommandFinalizationType finalizationType = finalizationInfo.getFinalizationType();
        try {
            if (command.getCommandInfo().getConfigurator().getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
                this.incrCounter(this.flowResultCounter, finalizationType);
            } else {
                this.incrCounter(this.exeResultCounter, finalizationType);
            }
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao obter o configurador do comando " + command.getCommandInfo().getId());
        }
    }

    private void collectSGAStats(CommandInfo cmd) {
        this.incrCounter(this.sgasCounter, cmd.getSGAName());
    }

    private ServerGroupInfo[] readGroupsInfo(String groupsFilePath) throws ServerException {
        File groupsFile = new File(groupsFilePath);
        if (!groupsFile.exists() || !groupsFile.isFile()) {
            return new ServerGroupInfo[0];
        }
        Properties gprops = new Properties();
        BufferedInputStream inStream = null;
        try {
            try {
                inStream = new BufferedInputStream(new FileInputStream(groupsFile));
                gprops.load(inStream);
            }
            catch (Exception e) {
                throw new ServerException("readGroupsInfo: Falha na leitura de " + groupsFilePath + "( " + e.getMessage() + ")");
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                throw new ServerException("Erro fechando stream de leitura", e);
            }
        }
        int numProps = gprops.size();
        ServerGroupInfo[] info = new ServerGroupInfo[numProps];
        Enumeration<Object> groups = gprops.keys();
        int i = 0;
        while (i < numProps) {
            String name = (String)groups.nextElement();
            StringTokenizer sList = new StringTokenizer((String)gprops.get(name), ",");
            int size = sList.countTokens();
            String[] servers = new String[size];
            int j = 0;
            while (j < size) {
                servers[j] = sList.nextToken();
                ++j;
            }
            info[i] = new ServerGroupInfo(name, servers);
            ++i;
        }
        return info;
    }

    private void updateAllSGAs() {
        Enumeration<SGA> sgas = this.registeredSGAs.elements();
        while (sgas.hasMoreElements()) {
            SGA sga = sgas.nextElement();
            if (sga == null || !sga.isAlive()) continue;
            if (sga.getWatchDog()) {
                sga.resetWatchDog();
                this.notifyAllUsersSGA(sga.getName(), 3);
                continue;
            }
            sga.setAlive(false);
            Server.logWarningMessage("SGA " + sga.getName() + " inacess\u00edvel! - ");
            this.notifyAllUsersSGA(sga.getName(), 1);
        }
    }

    void logSGAInfo(SGAInfo[] info, String prefix) {
        if (this.doSGALog) {
            int max = this.numberHostsLog < 0 ? info.length : (info.length > this.numberHostsLog + 1 ? this.numberHostsLog + 1 : info.length);
            int i = 0;
            while (i < max) {
                this.logSGAInfo(info[i], prefix);
                ++i;
            }
        }
    }

    void logSGAMessage(String msg) {
        if (this.doSGALog) {
            Server.logInfoMessage(msg);
        }
    }

    void logSGAInfo(SGAInfo info, String prefix) {
        if (this.doSGALog) {
            String format = "{0} {1}: RAM {2,number,#.##}, Swap {3,number,#.##}, Load {4,number,#.##}/{5,number,#.##}/{6,number,#.##}";
            MessageFormat formatter = new MessageFormat(format);
            Object[] args = new Object[7];
            args[0] = prefix != null ? prefix : "";
            StringBuffer result = new StringBuffer();
            args[1] = info.getHostName();
            args[2] = new Double(info.getRAMFreeMemory());
            args[3] = new Double(info.getSwapFreeMemory());
            args[4] = new Double(info.getCPULoad1());
            args[5] = new Double(info.getCPULoad5());
            args[6] = new Double(info.getCPULoad15());
            formatter.format(args, result, (FieldPosition)null);
            Server.logInfoMessage(result.toString());
        }
    }

    private void writeGroupsInfo(String groupsFilePath, ServerGroupInfo[] info) throws ServerException {
        Properties gprops = new Properties();
        ServerGroupInfo[] serverGroupInfoArray = info;
        int n = info.length;
        int n2 = 0;
        while (n2 < n) {
            ServerGroupInfo group = serverGroupInfoArray[n2];
            String[] servers = group.getServers();
            if (servers.length < 1) break;
            StringBuilder sList = new StringBuilder(servers[0]);
            int j = 1;
            while (j < servers.length) {
                sList.append(',');
                sList.append(servers[j]);
                ++j;
            }
            gprops.put(group.getName(), sList.toString());
            ++n2;
        }
        FilterOutputStream grpFile = null;
        try {
            try {
                grpFile = new BufferedOutputStream(new FileOutputStream(groupsFilePath));
                gprops.store(grpFile, null);
            }
            catch (Exception e) {
                throw new ServerException("writeGroupsInfo: Falha na grava\u00e7\u00e3o de " + groupsFilePath + "( " + e.getMessage() + ")");
            }
        }
        finally {
            try {
                if (grpFile != null) {
                    grpFile.close();
                }
            }
            catch (IOException e) {
                Server.logSevereMessage("Erro fechando stream", e);
            }
        }
    }

    boolean setupExecutionEnvironment(Command command) {
        if (this.isCSFSExecution(command)) {
            return this.setupCSFSExecutionEnvironment(command);
        }
        return this.checkExecutionEnvironment(command);
    }

    private boolean checkExecutionEnvironment(Command command) {
        String sgaProjectFullPath;
        block5: {
            String sgaBinaryPath;
            block6: {
                SGAInfo host = this.getExecutionHost(command);
                AlgorithmConfigurator algorithmConfigurator = this.getAlgorithmConfigurator(command);
                if (algorithmConfigurator == null) {
                    return false;
                }
                Set binaryDirs = algorithmConfigurator.getBinaryDirectoriesAsArray(host.getPlatformId());
                SGA sga = command.getSGA();
                String[] projectPath = SGAService.combinePaths(command.getNode().getProjectRootDirectory(), command.getProjectPath());
                char fileSeparator = host.getFileSeparator();
                sgaProjectFullPath = FileUtils.joinPath((boolean)true, (char)fileSeparator, (String[])projectPath);
                try {
                    if (!sga.isDir(sgaProjectFullPath)) break block5;
                    String[] binaryPath = SGAService.combinePaths(command.getNode().getAlgorithmRootDirectory(), (String[])binaryDirs.iterator().next());
                    sgaBinaryPath = FileUtils.joinPath((boolean)true, (char)fileSeparator, (String[])binaryPath);
                    if (!sga.isDir(sgaBinaryPath)) break block6;
                    return true;
                }
                catch (ServerException exc) {
                    Server.logSevereMessage("Ocorreu um erro na tentativa de verificar o ambiente de execu\u00e7\u00e3o no SGA [" + sga.getName() + "] - id: " + command.getId() + ".\n", exc);
                    return false;
                }
            }
            StringBuilder msg = new StringBuilder("O SGA n\u00e3o tem acesso ao diret\u00f3rio de bin\u00e1rios '");
            msg.append(sgaBinaryPath);
            msg.append("', \n  embora tenha encontrado o diret\u00f3rio de projeto '");
            msg.append(sgaProjectFullPath);
            msg.append("'.\n  Por favor, verifique a configura\u00e7\u00e3o do ambiente.");
            Server.logSevereMessage(msg.toString());
            return false;
        }
        StringBuilder msg = new StringBuilder("O SGA n\u00e3o tem acesso ao diret\u00f3rio do projeto '");
        msg.append(sgaProjectFullPath);
        msg.append("'.\n  Por favor, verifique a configura\u00e7\u00e3o do ambiente.");
        Server.logSevereMessage(msg.toString());
        return false;
    }

    private boolean isCSFSExecution(Command command) {
        SGA sga = command.getSGA();
        String csfsHost = sga.getCSFSHost();
        String[] csfsRootDir = sga.getCSFSRootDir();
        return command.existsProject() && csfsHost != null && csfsRootDir != null;
    }

    private boolean setupCSFSExecutionEnvironment(Command command) {
        SGA sga = command.getSGA();
        CSFSService csfsService = CSFSService.getInstance();
        if (csfsService == null || !csfsService.isActive()) {
            Server.logSevereMessage("CSFS inacess\u00edvel ou inibido. SGA " + sga.getName() + " precisa deste servi\u00e7o para execu\u00e7\u00e3o.");
            return false;
        }
        AlgorithmConfigurator algorithmConfigurator = this.getAlgorithmConfigurator(command);
        if (algorithmConfigurator == null) {
            return false;
        }
        SGAInfo host = this.getExecutionHost(command);
        Set binaryDirs = algorithmConfigurator.getBinaryDirectoriesAsArray(host.getPlatformId());
        try {
            this.setCSFSExecutionPaths(command, sga.getCSFSRootDir());
            this.setupSandbox(command);
            this.saveSandboxSnapshot(command);
            this.setupBinaryDir(binaryDirs, sga.getCSFSHost(), sga.getCSFSPort());
            return true;
        }
        catch (ServerException exc) {
            Server.logSevereMessage("Ocorreu um erro na tentativa de verificar/criar um ambiente de execu\u00e7\u00e3o CSFS no SGA [" + sga.getName() + "] - id: " + command.getId() + ".\n", exc);
            return false;
        }
    }

    private String[] getCSFSSandboxPath(Command command) {
        String[] sandbox = new String[]{command.getUserId().toString(), command.getProjectName(), FileUtils.fixDirectoryName((String)command.getId())};
        return SGAService.combinePaths(CSFS_SANDBOX_ROOT_DIR, sandbox);
    }

    public void uploadScripts(Command command) throws OperationFailureException, ServerException {
        if (this.isCSFSExecution(command)) {
            String[][] commandScriptPaths;
            CSFSService csfsService = CSFSService.getInstance();
            SGA sga = command.getSGA();
            String[] csfsProjectPath = SGAService.combinePaths(csfsService.getCSFSProjectsRootPath(), command.getProjectPath());
            String[] sandboxPath = this.getCSFSSandboxPath(command);
            CommandPersistenceService persistence = CommandPersistenceService.getInstance();
            String[][] stringArray = commandScriptPaths = persistence.getCommandScripts(command.getId(), command.getProjectId());
            int n = commandScriptPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String[] scriptPath = stringArray[n2];
                String[] localScriptFile = SGAService.combinePaths(csfsProjectPath, scriptPath);
                String[] remoteScriptFile = SGAService.combinePaths(sandboxPath, scriptPath);
                csfsService.copyTo(sga.getCSFSHost(), sga.getCSFSPort(), localScriptFile, remoteScriptFile);
                ++n2;
            }
        }
    }

    static String[] combinePaths(String[] ... arrays) {
        int count = 0;
        String[][] stringArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            String[] array = stringArray[n2];
            count += array.length;
            ++n2;
        }
        String[] mergedArray = new String[count];
        int start = 0;
        String[][] stringArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            String[] array = stringArray2[n4];
            System.arraycopy(array, 0, mergedArray, start, array.length);
            start += array.length;
            ++n4;
        }
        return mergedArray;
    }

    private void saveSandboxSnapshot(Command command) throws ServerException {
        SGA sga = command.getSGA();
        CSFSService csfsService = CSFSService.getInstance();
        String[] sandboxPath = this.getCSFSSandboxPath(command);
        Map<String[], Long> sandboxInitState = csfsService.getTimestamps(sga.getCSFSHost(), sga.getCSFSPort(), sandboxPath);
        command.setSandboxSnapshot(sandboxInitState);
    }

    private void setupBinaryDir(Set<String[]> binaryDirs, String csfsHost, int csfsPort) throws ServerException {
        CSFSService csfsService = CSFSService.getInstance();
        csfsService.createDirectory(csfsHost, csfsPort, CSFS_ALGORITHMS_ROOT_DIR);
        String[] csfsAlgorithmPath = csfsService.getCSFSAlgorithmsRootPath();
        for (String[] binaryDir : binaryDirs) {
            String[] localBinDir = SGAService.combinePaths(csfsAlgorithmPath, binaryDir);
            String[] remoteBinDir = SGAService.combinePaths(CSFS_ALGORITHMS_ROOT_DIR, binaryDir);
            if (csfsService.checkExistence(csfsHost, csfsPort, binaryDir) && !this.binaryDirUpdated(localBinDir, binaryDir, csfsHost, csfsPort)) continue;
            csfsService.copyTo(csfsHost, csfsPort, localBinDir, remoteBinDir);
        }
    }

    private void setupSandbox(Command command) throws ServerException {
        SGA sga = command.getSGA();
        String csfsHost = sga.getCSFSHost();
        int csfsPort = sga.getCSFSPort();
        String[] sandboxPath = this.getCSFSSandboxPath(command);
        CSFSService csfsService = CSFSService.getInstance();
        csfsService.createDirectory(csfsHost, csfsPort, sandboxPath);
        String[] csfsFullProjectPath = SGAService.combinePaths(csfsService.getCSFSProjectsRootPath(), command.getProjectPath());
        AlgorithmConfigurator algorithmConfigurator = this.getAlgorithmConfigurator(command);
        Set inputFiles = algorithmConfigurator.getInputFiles();
        for (FileParameterValue file : inputFiles) {
            String[] inputFilePath = file.getPathAsArray();
            String[] localInputFile = SGAService.combinePaths(csfsFullProjectPath, inputFilePath);
            String[] remoteInputFile = SGAService.combinePaths(sandboxPath, inputFilePath);
            csfsService.copyTo(csfsHost, csfsPort, localInputFile, remoteInputFile);
        }
        Set inputDirs = algorithmConfigurator.getInputDirectories();
        for (FileParameterValue dir : inputDirs) {
            String[] dirPath = dir.getPathAsArray();
            String[] localDirectory = SGAService.combinePaths(csfsFullProjectPath, dirPath);
            String[] remoteDirectory = SGAService.combinePaths(sandboxPath, dirPath);
            csfsService.copyTo(csfsHost, csfsPort, localDirectory, remoteDirectory);
        }
        Set outputDirs = algorithmConfigurator.getOutputDirectories();
        for (FileParameterValue file : outputDirs) {
            String[] outputDirPath = file.getPathAsArray();
            String[] remoteOutputPath = SGAService.combinePaths(sandboxPath, outputDirPath);
            csfsService.createDirectory(csfsHost, csfsPort, remoteOutputPath);
        }
        Set outputFiles = algorithmConfigurator.getOutputFiles();
        for (FileParameterValue file : outputFiles) {
            String[] outputFilePath = file.getPathAsArray();
            if (outputFilePath.length <= 1) continue;
            String[] outputDirPath = new String[outputFilePath.length - 1];
            System.arraycopy(outputFilePath, 0, outputDirPath, 0, outputFilePath.length - 1);
            String[] remoteOutputDirPath = SGAService.combinePaths(sandboxPath, outputDirPath);
            csfsService.createDirectory(csfsHost, csfsPort, remoteOutputDirPath);
        }
        Set stdouts = algorithmConfigurator.getStandardOutputFiles();
        for (FileParameterValue file : stdouts) {
            String[] stdoutPath = file.getPathAsArray();
            String[] localStdoutFile = SGAService.combinePaths(csfsFullProjectPath, stdoutPath);
            String[] remoteStdoutFile = SGAService.combinePaths(sandboxPath, stdoutPath);
            csfsService.copyTo(csfsHost, csfsPort, localStdoutFile, remoteStdoutFile);
        }
    }

    private void setCSFSExecutionPaths(Command command, String[] remoteRootPath) {
        String[] remoteAlgorithmRootPath = SGAService.combinePaths(remoteRootPath, CSFS_ALGORITHMS_ROOT_DIR);
        String[] sandboxPath = this.getCSFSSandboxPath(command);
        command.setProjectRootPath(remoteRootPath);
        command.setAlgorithmRootPath(remoteAlgorithmRootPath);
        command.setSandbox(sandboxPath);
        command.setProjectPath(sandboxPath);
    }

    private SGAInfo getExecutionHost(Command command) {
        String hostName = command.getNode().getHostName();
        SGA sga = command.getSGA();
        if (hostName == null) {
            return sga.getInfo(0);
        }
        return sga.getInfo(hostName);
    }

    private AlgorithmConfigurator getAlgorithmConfigurator(Command command) {
        AlgorithmConfigurator algorithmConfigurator = null;
        try {
            CommandInfo commandInfo = command.getCommandInfo();
            if (commandInfo != null) {
                algorithmConfigurator = commandInfo.getConfigurator();
            }
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Ocorreu um erro na tentativa de obter o configurador do comando " + command.getId() + ".\n", e);
            return null;
        }
        return algorithmConfigurator;
    }

    void handleCommandInitFailure(Command command) {
        String cmdId = command.getId();
        CommandEvent event = new CommandEvent((Object)cmdId, CommandEvent.EventType.INIT_FAILURE, command.getFinalizationInfo());
        this.notifyCommandEnd(command, event);
    }

    private boolean binaryDirUpdated(String[] localBinaryDir, String[] remoteBinaryDir, String csfsHost, int csfsPort) throws ServerException {
        CSFSService csfsService = CSFSService.getInstance();
        if (csfsService == null) {
            throw new ServerException("CSFSService n\u00e3o encontrado");
        }
        Map<String[], Long> localBinaryDirs = csfsService.getTimestamps(localBinaryDir);
        Map<String[], Long> remoteBinaryDirs = csfsService.getTimestamps(csfsHost, csfsPort, remoteBinaryDir);
        if (localBinaryDirs.size() != remoteBinaryDirs.size()) {
            csfsService.remove(csfsHost, csfsPort, remoteBinaryDir);
            return true;
        }
        Set<Map.Entry<String[], Long>> remoteTimestamps = remoteBinaryDirs.entrySet();
        for (Map.Entry<String[], Long> timestamps : remoteTimestamps) {
            String[] file = timestamps.getKey();
            Long remoteTime = timestamps.getValue();
            Long localTime = localBinaryDirs.get(file);
            if (localTime != null && remoteTime >= localTime) continue;
            csfsService.remove(csfsHost, csfsPort, remoteBinaryDir);
            return true;
        }
        return false;
    }

    boolean clearExecutionEnvironment(Command command) {
        SGA sga = command.getSGA();
        String csfsHost = sga.getCSFSHost();
        int csfsPort = sga.getCSFSPort();
        String[] sandbox = command.getSandbox();
        CSFSService csfsService = CSFSService.getInstance();
        if (!command.existsProject() || csfsService == null || csfsHost == null || sandbox == null) {
            return true;
        }
        try {
            Map<String[], Long> sandboxInitState = command.getSandboxSnapshot();
            Map<String[], Long> sandboxFinalState = csfsService.getTimestamps(csfsHost, csfsPort, sandbox);
            this.updateProjectArea(command, sandboxInitState, sandboxFinalState);
        }
        catch (ServerException exc) {
            Server.logSevereMessage("Falha na recupera\u00e7\u00e3o de dados do sandbox", exc);
            return false;
        }
        try {
            csfsService.remove(csfsHost, csfsPort, sandbox);
        }
        catch (ServerException exc) {
            Server.logSevereMessage("Falha na remocao de dados do sandbox", exc);
        }
        return true;
    }

    private void updateProjectArea(Command command, Map<String[], Long> sandboxInit, Map<String[], Long> sandboxFinal) throws ServerException {
        SGA sga = command.getSGA();
        CSFSService csfsService = CSFSService.getInstance();
        if (csfsService == null) {
            String cmdId = command.getId();
            String errorMsg = "O CSFSService nao foi localizadodurante a sincronizacao do sandbox.\n";
            Server.logSevereMessage(String.valueOf(errorMsg) + "\tCausa: Falha na constru\u00e7\u00e3o do comando: " + "\n\tSGA [" + sga.getName() + "] - id: " + cmdId + ".\n\tErro: " + errorMsg + ".\n");
            sga.failCommand(cmdId, FailureFinalizationType.CSFS_SERVICE_UNAVAILABLE);
        } else {
            try {
                Thread.sleep(this.csfsUpdateProjectAreaDelay);
            }
            catch (InterruptedException e) {
                Server.logSevereMessage("Tempo de espera do CSFS interrompido!");
            }
            String csfsHost = sga.getCSFSHost();
            int csfsPort = sga.getCSFSPort();
            String[] sandbox = command.getSandbox();
            Set<Map.Entry<String[], Long>> entrySet = sandboxFinal.entrySet();
            for (Map.Entry<String[], Long> entry : entrySet) {
                String[] remoteFilePath = entry.getKey();
                long finalTime = entry.getValue();
                Long originalTimeLong = sandboxInit.get(remoteFilePath);
                if (originalTimeLong == null || finalTime > originalTimeLong) {
                    String[] relativeFilePath = Arrays.copyOfRange(remoteFilePath, sandbox.length, remoteFilePath.length);
                    String[] localFilePath = SGAService.combinePaths(csfsService.getCSFSProjectsRootPath(), command.getProjectPath(), relativeFilePath);
                    csfsService.copyFrom(csfsHost, csfsPort, remoteFilePath, localFilePath);
                }
                sandboxInit.remove(remoteFilePath);
            }
            if (!sandboxInit.isEmpty()) {
                Server.logWarningMessage("Ooops! sandbox shrunk! command.getId()=" + command.getId());
            }
        }
    }

    public String getCommandsPersistencyDirectoryName() throws OperationFailureException {
        try {
            Server srv = Server.getInstance();
            String directory = String.valueOf(srv.getPersistencyRootDirectoryName()) + File.separator + COMMANDS_DIR;
            Server.checkDirectory(directory);
            return directory;
        }
        catch (ServerException e) {
            throw new OperationFailureException((Throwable)e);
        }
    }

    public static void createService() throws ServerException {
        new SGAService();
    }

    protected SGAService() throws ServerException {
        super("SGAService");
        ClientRemoteLocator.sgaService = this;
        this.registeredSGAs = new Hashtable();
        this.lockSGAs = Collections.synchronizedSet(new HashSet());
        CommandEvent.EventType[] eventTypeArray = CommandEvent.EventType.values();
        int n = eventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandEvent.EventType type = eventTypeArray[n2];
            this.finishedCmdsCount.put(type, new AtomicLong(0L));
            ++n2;
        }
    }

    public Map<CommandFinalizationType, Integer> getExeResultsStats(boolean flowResults) throws RemoteException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        return Collections.unmodifiableMap(flowResults ? this.flowResultCounter : this.exeResultCounter);
    }

    public Map<String, Integer> getSGAsStats() throws RemoteException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        return Collections.unmodifiableMap(this.sgasCounter);
    }

    class ParametersReportMaker {
        private final String emptyValueTemplate;
        private final String singleValueTemplate;
        private final String multiValueTemplate;
        private final String valueTemplate;

        ParametersReportMaker() {
            this.emptyValueTemplate = SGAService.this.getString("SGAService.mail.content.param.value.0");
            this.singleValueTemplate = SGAService.this.getString("SGAService.mail.content.param.value.1");
            this.multiValueTemplate = SGAService.this.getString("SGAService.mail.content.param.value.n");
            this.valueTemplate = SGAService.this.getString("SGAService.value");
        }

        public String makeReport(List<ParameterGroup> groups) {
            StringBuilder reportBuilder = new StringBuilder();
            this.report(reportBuilder, groups);
            return reportBuilder.toString();
        }

        private void report(StringBuilder reportBuilder, Collection<ParameterGroup> groups) {
            for (ParameterGroup group : groups) {
                this.report(reportBuilder, group);
            }
        }

        private void report(StringBuilder reportBuilder, Parameter<?> param) {
            if (param instanceof ParameterGroup) {
                this.report(reportBuilder, (ParameterGroup)param);
            } else if (param instanceof BooleanParameter) {
                this.report(reportBuilder, (BooleanParameter)param);
            } else if (param instanceof FileParameter) {
                this.report(reportBuilder, (FileParameter)param);
            } else if (param instanceof ListParameter) {
                this.report(reportBuilder, (ListParameter)param);
            } else if (param instanceof InputFileListParameter) {
                this.report(reportBuilder, (InputFileListParameter)param);
            } else if (param instanceof TableParameter) {
                this.report(reportBuilder, (TableParameter)param);
            } else if (param instanceof SimpleParameter) {
                this.report(reportBuilder, (SimpleParameter)param);
            }
        }

        private void report(StringBuilder reportBuilder, ParameterGroup group) {
            for (Parameter param : group.getParameters()) {
                this.report(reportBuilder, param);
                this.report(reportBuilder, group.getGroups());
            }
        }

        private void report(StringBuilder reportBuilder, BooleanParameter param) {
            String value = SGAService.this.getString("SGAService.param.value." + param.getValue());
            this.writeParamValue(reportBuilder, (SimpleParameter<?>)param, value);
        }

        private void report(StringBuilder reportBuilder, FileParameter param) {
            FileParameterValue file = (FileParameterValue)param.getValue();
            String value = file == null ? null : file.getPath();
            this.writeParamValue(reportBuilder, (SimpleParameter<?>)param, value);
        }

        private void report(StringBuilder reportBuilder, ListParameter<?> param) {
            List paramValues = (List)param.getValue();
            if (paramValues == null) {
                this.writeParamValue(reportBuilder, (SimpleParameter<?>)param, null);
            } else {
                String value2;
                String valueSeparator = ", ";
                StringBuilder sb = new StringBuilder();
                for (String value2 : paramValues) {
                    if (value2 == null) continue;
                    if (sb.length() > 0) {
                        sb.append(valueSeparator);
                    }
                    sb.append('\"').append((Object)value2).append('\"');
                }
                value2 = sb.toString();
                this.writeParamValue(reportBuilder, (SimpleParameter<?>)param, value2);
            }
        }

        private void report(StringBuilder reportBuilder, InputFileListParameter param) {
            ArrayList<String> values = new ArrayList<String>();
            List files = (List)param.getValue();
            if (files != null) {
                for (FileParameterValue file : files) {
                    if (file == null) continue;
                    values.add(file.getPath());
                }
            }
            this.writeParamValues(reportBuilder, (SimpleParameter<?>)param, (List<String>)values);
        }

        private void report(StringBuilder reportBuilder, TableParameter param) {
            String valueSeparator = ", ";
            String emptyValue = "";
            ArrayList<String> values = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < param.getRowCount()) {
                sb.append(i + 1).append(") ");
                int j = 0;
                while (j < param.getColumnCount()) {
                    String value;
                    Object itemValue;
                    if (j > 0) {
                        sb.append(", ");
                    }
                    if ((itemValue = param.getItemValue(i, j)) instanceof Boolean) {
                        boolean booleanValue = (Boolean)itemValue;
                        value = SGAService.this.getString("SGAService.param.value." + booleanValue);
                        sb.append(value);
                    } else {
                        Column column = (Column)param.getColumns().get(j);
                        value = column.getItemValueAsText(itemValue);
                        value = value == null ? "" : value;
                        sb.append('\"').append(value).append('\"');
                    }
                    ++j;
                }
                values.add(sb.toString());
                sb.delete(0, sb.length());
                ++i;
            }
            this.writeParamValues(reportBuilder, (SimpleParameter<?>)param, (List<String>)values);
        }

        private void report(StringBuilder reportBuilder, SimpleParameter<?> param) {
            String value = param.getValueAsText();
            this.writeParamValue(reportBuilder, param, value);
        }

        private void writeParamValues(StringBuilder reportBuilder, SimpleParameter<?> param, List<String> values) {
            String label = param.getLabel();
            if (values == null || values.size() == 0) {
                reportBuilder.append(String.format(this.emptyValueTemplate, label));
            } else {
                reportBuilder.append(String.format(this.multiValueTemplate, label));
                for (String value : values) {
                    reportBuilder.append(String.format(this.valueTemplate, value));
                }
            }
            reportBuilder.append("\n");
        }

        private void writeParamValue(StringBuilder reportBuilder, SimpleParameter<?> param, String value) {
            String label = param.getLabel();
            if (value == null) {
                reportBuilder.append(String.format(this.emptyValueTemplate, label));
            } else {
                reportBuilder.append(String.format(this.singleValueTemplate, label, value));
            }
            reportBuilder.append("\n");
        }
    }

    private class TransferRateAcquisitionThread
    extends Thread {
        private TransferRateAcquisitionThread() {
        }

        @Override
        public void run() {
            while (true) {
                FindTransferRate transferThread;
                Enumeration sgas = SGAService.this.registeredSGAs.elements();
                while (sgas.hasMoreElements()) {
                    SGA sga = (SGA)sgas.nextElement();
                    try {
                        if (sga.execNetBench() != 0) continue;
                        transferThread = new FindTransferRate(sga, netBenchDuration);
                        transferThread.setName(String.valueOf(this.getClass().getSimpleName()) + "::" + "FindTransferRateThread");
                        transferThread.start();
                        try {
                            transferThread.join(iperfTimeout);
                        }
                        catch (InterruptedException e) {
                            Server.logSevereMessage("Falha na coleta da taxa de transfer\u00eancia de dados na rede para o SGA: " + sga.getName(), e);
                            sga.setTransferRate(-1L);
                        }
                    }
                    catch (ServerException e) {
                        Server.logSevereMessage("Falha na determina\u00e7\u00e3o se o benchmark de rede deve ser executado para o SGA: " + sga.getName() + ".", e);
                        sga.setTransferRate(-1L);
                    }
                }
                try {
                    Thread.sleep(updateDataTransferRate);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                transferThread = null;
                Object var2_2 = null;
            }
        }
    }
}

