package csbase.server.services.loginservice;


/**
 *  Representa um listener para o servio de login.
 *
 */
public interface LoginServiceListener {

  /**
   * Informa que uma sesso foi criada
   * @param login Login do usurio
   * @param sessionKey Chave da sesso do usurio
   * @param time Hora em que ocorreu o evento representado em milisegundos
   */
  public void sessionCreated(String login, Object sessionKey, long time);

  /**
   * Informa que um usurio est efetando um logout. Nesse momento a sesso do usurio ainda no foi removida.
   * @param login Login do usurio
   * @param sessionKey Chave da sesso do usurio
   * @param systemName Nome do sistema definido pelo usurio ou <code>NULL</code> se no tiver sido definido.
   * @param time Hora em que ocorreu o evento representado em milisegundos
   */
  public void userLoggingOut(String login, Object sessionKey, String systemName, long time);

  /**
   * Informa que a conexo com um usurio foi perdida
   * @param login Login do usurio que perdeu a conexo
   * @param sessionKey Chave da sesso do usurio
   * @param systemName Nome do sistema definido pelo usurio ou <code>NULL</code> se no tiver sido definido.
   * @param time Hora em que ocorreu o evento representado em milisegundos
   */
  public void connectionLost(String login, Object sessionKey, String systemName, long time);

  /**
   * Informa que o nome do sistema foi definido
   * @param login Login do usurio
   * @param sessionKey Chave da sesso do usurio
   * @param systemName Nome do sistema definido pelo usurio
   * @param time Hora em que ocorreu o evento representado em milisegundos
   */
  public void systemNameSet(String login, Object sessionKey, String systemName, long time);

}
