/**
 * $Id$
 */
package csbase.server.services.projectservice.v1_01;

import tecgraf.openbus.data_service.core.v1_01.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_01.DataDescription;
import tecgraf.openbus.data_service.core.v1_01.DataNotFound;
import tecgraf.openbus.data_service.core.v1_01.DataView;
import tecgraf.openbus.data_service.core.v1_01.IDataServicePOA;
import tecgraf.openbus.data_service.core.v1_01.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_01.ServiceFailure;
import tecgraf.openbus.data_service.core.v1_01.UnsupportedView;
import tecgraf.openbus.data_service.core.v1_02.IDataServiceOperations;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.v1_02.DataValidation;

/**
 * 
 * 
 * @author Tecgraf
 */
public class IDataServiceServant extends IDataServicePOA {

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription getDataDescription(byte[] fKey) throws ServiceFailure,
    DataAccessDenied, DataNotFound, InvalidDataKey {
    try {
      IDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();

      try {
        DataValidation.checkUser(OpenBusService.getInstance()
          .getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

        byte[] fKeyV1_02;
        try {
          fKeyV1_02 = DataBridge.convertDataKeyToV1_02(fKey);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
          throw new ServiceFailure(e.fMessage);
        }

        tecgraf.openbus.data_service.core.v1_02.DataDescription dataDescriptionV1_02 =
          service.getDataDescription(fKeyV1_02);

        return DataBridge.convertDataDescriptionToV1_01(dataDescriptionV1_02);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        try {
          throw new DataAccessDenied(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
        try {
          throw new DataNotFound(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
        try {
          throw new InvalidDataKey(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
    }
    catch (RuntimeException e) {
      String msg =
        "Erro na chamada do mtodo getDataDescription: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataView getDataView(byte[] fKey, String fViewInterface)
    throws UnsupportedView, ServiceFailure, DataAccessDenied, DataNotFound,
    InvalidDataKey {
    try {
      IDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();

      try {
        DataValidation.checkUser(OpenBusService.getInstance()
          .getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

        byte[] fKeyV1_02;
        String fViewInterfaceV1_02;

        try {
          fKeyV1_02 = DataBridge.convertDataKeyToV1_02(fKey);
          fViewInterfaceV1_02 =
            DataBridge.convertInterfaceNameToV1_02(fViewInterface);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
          throw new ServiceFailure(e.fMessage);
        }
        catch (UnsupportedView e) {
          e.fKeys = new byte[][] { fKey };
          throw e;
        }

        tecgraf.openbus.data_service.core.v1_02.DataView dataViewV1_02 =
          service.getDataView(fKeyV1_02, fViewInterfaceV1_02);

        return DataBridge.convertDataViewToV1_01(dataViewV1_02);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.UnsupportedView e) {
        try {
          throw new UnsupportedView(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        try {
          throw new DataAccessDenied(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
        try {
          throw new DataNotFound(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
        try {
          throw new InvalidDataKey(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }

    }
    catch (RuntimeException e) {
      String msg = "Erro na chamada do mtodo getDataView: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataView[] getDataViewSeq(byte[][] fKeys, String fViewInterface)
    throws UnsupportedView, ServiceFailure, DataAccessDenied, DataNotFound,
    InvalidDataKey {
    try {
      IDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();
      try {
        DataValidation.checkUser(OpenBusService.getInstance()
          .getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

        byte[][] fKeysV1_02;
        String fViewInterfaceV1_02;

        try {
          fKeysV1_02 = DataBridge.convertDataKeySeqToV1_02(fKeys);
          fViewInterfaceV1_02 =
            DataBridge.convertInterfaceNameToV1_02(fViewInterface);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
          throw new ServiceFailure(e.fMessage);
        }

        tecgraf.openbus.data_service.core.v1_02.DataView[] dataViewSeqV1_02 =
          service.getDataViewSeq(fKeysV1_02, fViewInterfaceV1_02);

        return DataBridge.convertDataViewSeqToV1_01(dataViewSeqV1_02);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.UnsupportedView e) {
        try {
          throw new UnsupportedView(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        try {
          throw new DataAccessDenied(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
        try {
          throw new DataNotFound(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
        try {
          throw new InvalidDataKey(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
    }
    catch (RuntimeException e) {
      String msg =
        "Erro na chamada do mtodo getDataViewSeq: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }
}
