package csbase.server.services.algorithmservice;

import java.util.Hashtable;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Extenso modificvel de um AlgorithmInfo.
 *
 * @author Ana
 * @version $Revision: 172515 $
 */
class ModifiableAlgorithmInfo extends AlgorithmInfo {

  /**
   * Remove uma verso
   *
   * @param id .
   */
  @Override
  public void deleteVersion(Object id) {
    super.deleteVersion(id);
  }

  /**
   * Inclui uma verso
   *
   * @param id .
   * @param vInfo .
   */
  @Override
  public void includeVersion(AlgorithmVersionId id, AlgorithmVersionInfo vInfo) {
    super.includeVersion(id, vInfo);
  }

  /**
   * Obtem um objeto no modificvel com as informaes.
   *
   * @return informaes do algoritmo
   */
  public AlgorithmInfo toAlgorithmInfo() {
    return new AlgorithmInfo(getId(), getName(), getDirectory(),
      getAlgorithmRepositoryPath(), getPropertyValues(), getAllVersionInfo());
  }

  /**
   * {@inheritDoc}
   */
  public void rename(String newName) {
    super.rename(newName);
  }


  /**
   * Construtor de um ModifiableAlgorithmInfo.
   *
   * @param id identificador do algorimo
   * @param name nome do algoritmo
   * @param dir diretrio do algoritmo
   * @param algorithmRepositoryPath Caminho para o repositrio de algoritmos
   * @param atributeValues valor dos atributos estendidos
   */
  public ModifiableAlgorithmInfo(String id, String name, String dir,
    String algorithmRepositoryPath, Hashtable<String, String> atributeValues) {
    super(id, name, dir, algorithmRepositoryPath, atributeValues);
  }

}
