/**
 * $Id$
 */
package csbase.server.services.sharedobjectservice.v1_00;

import java.util.Properties;

import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.openbusservice.OpenBusServiceFacet;
import csbase.server.services.openbusservice.OpenBusServiceOffer;
import tecgraf.openbus.data_service.core.v1_02.UnstructuredDataViewFactory;
import tecgraf.openbus.data_service.core.v1_02.UnstructuredDataViewHelper;
import tecgraf.openbus.data_service.sharedobjects.v1_00.SharedObjectDataViewFactory;
import tecgraf.openbus.data_service.sharedobjects.v1_00.SharedObjectDataViewHelper;
import tecgraf.openbus.data_service.sharedobjects.v1_00.SharedObjectServiceHelper;

/**
 * Esta classe representa a ofertad do servio de shared objects no barramento.
 * Ela usa ISharedObjectServiceServant como faceta
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class SharedObjectServiceOffer implements OpenBusServiceOffer {

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  public void registerFactories() {
    org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB) OpenBusService
      .getInstance().getORB();
    orb.register_value_factory(UnstructuredDataViewHelper.id(),
      new UnstructuredDataViewFactory());
    orb.register_value_factory(SharedObjectDataViewHelper.id(),
      new SharedObjectDataViewFactory());
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  public OpenBusServiceFacet[] getFacets() {
    ISharedObjectServiceServant sharedObjectServiceServant =
      new ISharedObjectServiceServant();
    return new OpenBusServiceFacet[] { new OpenBusServiceFacet(
      "sharedobjectservice_v1_0", SharedObjectServiceHelper.id(),
      sharedObjectServiceServant) };
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  public Properties getProperties() {
    return null;
  }

}
