/*
 * FileCrypto.java
 *
 * $Author$
 * $Revision$  - $Date$
 */
package csbase.server.services.administrationservice;

import java.io.*;
import java.security.*;
import java.security.spec.*;
import java.util.*;

import javax.crypto.*;
import javax.crypto.spec.*;

/**
 * A classe <code>FileCrypto</code> oferece mtodos para criptografar e
 * descriptografar arquivos a partir de uma senha.
 */
public class FileCrypto {
  private static final String ALGORITHM = "PBEWithMD5AndDES";
  private SecretKey key;

  // Teste
  public static void main(String[] args) {
    try {
      Vector v = new Vector();
      String password = args[0];
      String t = "Este e um objeto qualquer";
      v.add(t);
      t = "Este e um outro objeto";
      v.add(t);
      t = "Este e o ultimo objeto";
      v.add(t);
      System.out.println("Codificando:");
      System.out.println((String)v.get(0));
      System.out.println((String)v.get(1));
      System.out.println((String)v.get(2));
      byte[] c1 = encrypt(password, (String)v.get(0));
      byte[] c2 = encrypt(password, (String)v.get(1));
      byte[] c3 = encrypt(password, (String)v.get(2));
      System.out.println("Criptografado. Senha usada:" + args[0]);
      System.out.println("Strings criptografadas:");
      System.out.println(new String(c1));
      System.out.println(new String(c2));
      System.out.println(new String(c3));
      System.out.println("-----");
      System.out.println("Decodificando:");
      String s1 = decrypt(password, c1);
      String s2 = decrypt(password, c2);
      String s3 = decrypt(password, c3); 
      System.out.println(s1);
      System.out.println(s2);
      System.out.println(s3);
    }
    catch (Exception e) {
      System.out.println("Erro:" + e);
      e.printStackTrace();
    }
  }

  /**
   * Gera um objeto Cipher (usado nas operaes de criptografia), a partir de
   * uma senha.
   *
   * @param password senha utilizada na gerao de chave de cripto.
   * @param mode define o mode de operao do cipher (criptografar ou
   *        descriptografar)
   *
   * @return .
   *
   * @throws NoSuchAlgorithmException .
   * @throws NoSuchPaddingException .
   * @throws InvalidKeyException .
   * @throws InvalidKeySpecException .
   * @throws InvalidAlgorithmParameterException .
   */
  protected static Cipher generateCipher(String password, int mode)
    throws NoSuchAlgorithmException, NoSuchPaddingException, 
      InvalidKeyException, InvalidKeySpecException, 
      InvalidAlgorithmParameterException {
    final byte[] salt =
    {
      (byte)0xac, (byte)0xba, (byte)0xc2, (byte)0x1d, (byte)0x33, (byte)0x42,
      (byte)0xab, (byte)0x12
    };
    final int iterations = 2;

    // Gera uma chave a partir da senha
    PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, iterations);
    PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
    SecretKeyFactory keyFac = SecretKeyFactory.getInstance(ALGORITHM);
    SecretKey key = keyFac.generateSecret(pbeKeySpec);

    // Gera o cipher
    Cipher cipher = Cipher.getInstance(ALGORITHM);
    cipher.init(mode, key, pbeParamSpec);
    return cipher;
  }

  /**
   * Gera uma String criptografada, a partir de uma senha.
   *
   * @param password - a senha utilizada 
   * @param word a String a ser criptografada.
   *
   * @return A String criptografada
   *
   * @throws NoSuchAlgorithmException falha especfica de encriptao.
   * @throws NoSuchPaddingException falha especfica de encriptao.
   * @throws InvalidKeyException falha especfica de encriptao.
   * @throws InvalidKeySpecException falha especfica de encriptao.
   * @throws InvalidAlgorithmParameterException falha especfica de encriptao.
   * @throws InvalidClassException falha especfica de encriptao.
   * @throws NotSerializableException falha especfica de encriptao.
   * @throws IllegalBlockSizeException falha especfica de encriptao.
   * @throws BadPaddingException falha especfica de encriptao.
   */
  public static byte[] encrypt(String password, String word)
    throws NoSuchAlgorithmException, NoSuchPaddingException, 
      InvalidKeyException, InvalidKeySpecException, 
      InvalidAlgorithmParameterException, InvalidClassException, 
      NotSerializableException, IllegalBlockSizeException,
      BadPaddingException{
    Cipher cipher = generateCipher(password, Cipher.ENCRYPT_MODE);
    byte[] b = word.getBytes();
    b = cipher.doFinal(b);
    return b;
  }

  /**
   * Recupera uma String criptografada.
   *
   * @param password - a senha utilizada 
   * @param word a String a ser criptografada.
   *
   * @return a String criptografada 
   *
   * @throws NoSuchAlgorithmException falha especfica de decriptao.
   * @throws NoSuchPaddingException falha especfica de decriptao.
   * @throws InvalidKeyException falha especfica de decriptao.
   * @throws InvalidKeySpecException falha especfica de decriptao.
   * @throws InvalidAlgorithmParameterException falha especfica de decriptao.
   * @throws IllegalBlockSizeException falha especfica de decriptao.
   * @throws BadPaddingException falha especfica de decriptao.
   * @throws ClassNotFoundException falha especfica de decriptao.
   * @throws InvalidClassException falha especfica de decriptao.
   * @throws StreamCorruptedException falha especfica de decriptao.
   * @throws OptionalDataException falha especfica de decriptao.
   * @throws FileNotFoundException falha especfica de decriptao.
   */
  public static String decrypt(String password, byte[] word)
    throws NoSuchAlgorithmException, NoSuchPaddingException, 
      InvalidKeyException, InvalidKeySpecException, 
      InvalidAlgorithmParameterException, IllegalBlockSizeException, 
      BadPaddingException, ClassNotFoundException, InvalidClassException, 
      StreamCorruptedException, OptionalDataException, FileNotFoundException 
      {
    Vector v = null;
    Cipher cipher = generateCipher(password, Cipher.DECRYPT_MODE);
    byte[] result = cipher.doFinal(word);
    return new String(result);
  }
}
