/*
 * KillServerService.java $Author$ $Revision$ - $Date:
 * 2008-02-14 15:00:23 -0200 (Thu, 14 Feb 2008) $
 */
package csbase.server.services.killserverservice;

import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.remote.KillServerServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.ServiceManager;

/**
 * A classe <code>KillServerService</code> foi criada apenas como um facilitador
 * para os testes automatizados; permite derrubar o servidor programaticamente.
 */
public class KillServerService extends Service implements
  KillServerServiceInterface {

  /**
   * Obtm a instncia do servio
   * 
   * @return a instncia do servio
   */
  public static KillServerService getInstance() {
    return (KillServerService) getInstance(SERVICE_NAME);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void shutdown() throws PermissionException {
    if (!Service.getUser().isAdmin()) {
      throw new PermissionException();
    }
    try {
      ServiceManager.getInstance().shutdownAllServices();
    }
    catch (ServerException se) {
      throw new ServiceFailureException(se.getMessage(), se);
    }
    Server.getInstance().shutdown();
  }

  /**
   * Trmino do servio.
   */
  @Override
  public void shutdownService() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean has2Update(Object arg, Object event) {
    return true;
  }

  /**
   * Inicializao do servio.
   * 
   * @throws ServerException se ocorrer um erro na inicializao
   */
  @Override
  public void initService() throws ServerException {
  }

  /**
   * Constri a instncia do servio.
   * 
   * @throws ServerException caso ocorra falha na inicializao
   */
  public static void createService() throws ServerException {
    new KillServerService();
  }

  /**
   * Constri a instncia do servio.
   * 
   * @throws ServerException caso ocorra falha na inicializao
   */
  protected KillServerService() throws ServerException {
    super(SERVICE_NAME);
  }
}
