package csbase.server.services.opendreamsservice.opendreams.v1_9;

import tecgraf.openbus.DRMAA.v1_9.AlreadyActiveSessionException;
import tecgraf.openbus.DRMAA.v1_9.AuthorizationException;
import tecgraf.openbus.DRMAA.v1_9.DeniedByDrmException;
import tecgraf.openbus.DRMAA.v1_9.DrmCommunicationException;
import tecgraf.openbus.DRMAA.v1_9.ExitTimeoutException;
import tecgraf.openbus.DRMAA.v1_9.InternalException;
import tecgraf.openbus.DRMAA.v1_9.InvalidArgumentException;
import tecgraf.openbus.DRMAA.v1_9.InvalidContactStringException;
import tecgraf.openbus.DRMAA.v1_9.InvalidJobException;
import tecgraf.openbus.DRMAA.v1_9.InvalidJobTemplateException;
import tecgraf.openbus.DRMAA.v1_9.JobControlAction;
import tecgraf.openbus.DRMAA.v1_9.JobInfo;
import tecgraf.openbus.DRMAA.v1_9.JobState;
import tecgraf.openbus.DRMAA.v1_9.JobTemplate;
import tecgraf.openbus.DRMAA.v1_9.NoActiveSessionException;
import tecgraf.openbus.DRMAA.v1_9.Version;

/**
 * Implementa a idl <code>Session</code> do DRMAA.
 * 
 * @author Tecgraf PUC-Rio
 * 
 */
public abstract class Session extends tecgraf.openbus.DRMAA.v1_9.SessionPOA {

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract JobInfo _wait(String jobName, long timeout)
    throws AuthorizationException, ExitTimeoutException, InternalException,
    InvalidJobException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract String contact();

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void control(String jobName, JobControlAction operation)
    throws NoActiveSessionException, AuthorizationException,
    InvalidArgumentException, InvalidJobException, DrmCommunicationException,
    InternalException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract JobTemplate createJobTemplate()
    throws AuthorizationException, NoActiveSessionException, InternalException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void deleteJobTemplate(JobTemplate jobTemplate)
    throws InvalidJobTemplateException, AuthorizationException,
    NoActiveSessionException, InternalException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract String drmaaImplementation();

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract String drmsInfo();

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void exit() throws AuthorizationException,
    NoActiveSessionException, InternalException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void init(String contactString)
    throws AlreadyActiveSessionException, InternalException,
    AuthorizationException, InvalidContactStringException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract JobState jobStatus(String jobName)
    throws AuthorizationException, InternalException, InvalidJobException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract String[] runBulkJobs(JobTemplate jobTemplate, int beginIndex,
    int endIndex, int step) throws InvalidArgumentException, InternalException,
    AuthorizationException, DeniedByDrmException, InvalidJobTemplateException,
    NoActiveSessionException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract String runJob(JobTemplate jobTemplate)
    throws InternalException, AuthorizationException, DeniedByDrmException,
    InvalidJobTemplateException, NoActiveSessionException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void synchronize(String[] jobList, long timeout,
    boolean dispose) throws AuthorizationException, ExitTimeoutException,
    InternalException, InvalidJobException;

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract Version version();
}
