/**
 * $Id: Validation.java 140813 2013-05-10 15:15:06Z fpina $
 */

package csbase.server.services.diagnosticservice.monitors;

import java.util.Locale;

import csbase.logic.diagnosticservice.ValidationStatus;

/**
 * Validao para ser feita pelo monitor ao obter o estado de um recurso.
 * 
 * @author Tecgraf
 */
public interface Validation {
  /**
   * Faz a validao.
   * 
   * @param locale o Locale para traduo dos textos
   * @return o estado da validao
   */
  public ValidationStatus check(Locale locale);

  /**
   * Obtm o identificador dessa validao.
   * 
   * @return o identificador
   */
  public String id();

  /**
   * Obtm a lista de identificadores de validao dos quais esse depende. Essa
   * validao somente  executada se todas as validaes dependentes tiverem
   * sido executadas com sucesso. Se no houver dependncia, retorna
   * {@code null}.
   * 
   * @return uma lista contendo os identificadores de validao requeridos para
   *         que essa validao execute ou {@code null} caso no haja
   *         dependncia de outras validaes .
   */
  public String[] requires();
}
