/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice.engine;

import csbase.logic.diagnosticservice.ResourceException;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.StatusCode;
import csbase.server.services.diagnosticservice.engine.UpdateHandler;
import csbase.server.services.diagnosticservice.monitors.Monitor;
import csbase.server.services.diagnosticservice.monitors.ProactiveMonitor;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Engine {
    private static Locale locale = Locale.getDefault();
    private ExecutorService executor;
    private Map<String, Monitor> monitors = new Hashtable<String, Monitor>();
    private Map<String, Status> monitorStatus = new Hashtable<String, Status>();

    public Engine() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void setLocale(Locale locale) {
        Engine.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(Monitor monitor) throws ResourceException {
        Map<String, Status> map = this.monitorStatus;
        synchronized (map) {
            if (ProactiveMonitor.class.isInstance(monitor)) {
                ((ProactiveMonitor)ProactiveMonitor.class.cast(monitor)).registerEngine(new UpdateHandlerImpl(monitor.getResourceName()));
            }
            if (this.monitorStatus.containsKey(monitor.getResourceName())) {
                throw new ResourceException("O recurso " + monitor.getResourceName() + " j\u00e1 est\u00e1 sendo monitorado");
            }
            this.monitorStatus.put(monitor.getResourceName(), new Status(monitor.getResourceName(), StatusCode.INITIATING));
            this.monitors.put(monitor.getResourceName(), monitor);
        }
    }

    public Status[] getAllStatus(final Locale locale) throws ResourceException {
        Callable<Void> worker = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Monitor monitor : Engine.this.monitors.values()) {
                    Engine.this.monitorStatus.put(monitor.getResourceName(), monitor.checkResource(locale));
                }
                return null;
            }
        };
        Future<Void> future = this.executor.submit(worker);
        try {
            future.get();
            return this.monitorStatus.values().toArray(new Status[0]);
        }
        catch (Exception e) {
            throw new ResourceException("Erro na verifica\u00e7\u00e3o dos recursos", e);
        }
    }

    public Status getStatus(final String resourceName, final Locale locale) throws ResourceException {
        Callable<Status> worker = new Callable<Status>(){

            @Override
            public Status call() throws Exception {
                Monitor monitor = (Monitor)Engine.this.monitors.get(resourceName);
                Status status = monitor.checkResource(locale);
                Engine.this.monitorStatus.put(monitor.getResourceName(), status);
                return status;
            }
        };
        Future<Status> future = this.executor.submit(worker);
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new ResourceException("Erro na verifica\u00e7\u00e3o do recurso " + resourceName, e);
        }
    }

    private class UpdateHandlerImpl
    implements UpdateHandler {
        private String resourceName;

        private UpdateHandlerImpl(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public void updateStatus(Status status) {
            Engine.this.monitorStatus.put(this.resourceName, status);
        }
    }
}

