package csbase.server.services.diagnosticservice.monitors.disk;

import java.util.Locale;

import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.logic.diskusageservice.DiskOccupation;
import csbase.remote.DiskUsageServiceInterface;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.Validation;
import csbase.server.services.diskusageservice.DiskUsageService;

/**
 * Validao da ocupao de disco.
 */
public class DiskOcupationValidation implements Validation {
  /** Nome que identifica a validao */
  public static final String NAME = "DiskOcupationValidation";

  /**
   * {@inheritDoc}
   */
  @Override
  public ValidationStatus check(Locale locale) {
    DiskOccupation serverDiskOccupation =
      DiskUsageService.getInstance().getAreaOccupation(
        DiskUsageServiceInterface.DIR_SERVER_ID);
    if (serverDiskOccupation.getUsedSpacePerc() >= serverDiskOccupation.alertLimit) {
      return new ValidationStatus(StatusCode.ERROR,
        MessageTranslator.getString(
          "server.disksmonitor.available.space.warning",
          new String[] { String.valueOf(serverDiskOccupation.alertLimit) },
          locale));
    }
    if (serverDiskOccupation.getUsedSpacePerc() >= serverDiskOccupation.warningLimit) {
      return new ValidationStatus(StatusCode.WARNING,
        MessageTranslator.getString(
          "server.disksmonitor.available.space.warning",
          new String[] { String.valueOf(serverDiskOccupation.alertLimit) },
          locale));
    }
    return new ValidationStatus(StatusCode.OK, MessageTranslator.getString(
      "server.disksmonitor.available.space.success",
      new String[] { String.valueOf(serverDiskOccupation.alertLimit) }, locale));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String id() {
    return NAME;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String[] requires() {
    return null;
  }
}