package csbase.server.services.administrationservice;

import java.util.List;

import csbase.logic.Platform;
import csbase.logic.PlatformInfo;

/**
 * Interface para acesso a dados de plataforma. A criao de objetos que
 * implementam essa interface  responsabilidade da fbrica de DAOs do servio
 * de administrao ({@link AdministrationDAOFactory}}).
 * 
 * @author Jorge Alexandre
 * 
 */
public interface PlatformDAO {
  /**
   * Recupera uma plataforma da fonte de dados pelo seu identificador.
   * 
   * @param id identificador da plataforma.
   * @return referncia para a plataforma.
   * @throws DAOException se ocorrer algum problema na consulta a fonte de
   *         dados.
   */
  Platform readPlatform(Object id) throws DAOException;

  /**
   * Recupera todos as plataforma que existem na fonte de dados.
   * 
   * @return uma referncia para a lista com as plataforma.
   * @throws DAOException se ocorrer algum problema na consulta a fonte de
   *         dados.
   */
  List<Platform> readAllPlatforms() throws DAOException;

  /**
   * Persiste a paltaforma na fonte de dados.
   * 
   * @param info informaes de plataforma que sero persistida.
   * @return uma referncia para a plataforma persistida contendo o seu
   *         identificador.
   * @throws DAOException se ocorrer algum problema na incluso da plataforma na
   *         fonte de dados.
   */
  Platform createPlatform(PlatformInfo info) throws DAOException;

  /**
   * Modifica uma plataforma na fonte de dados.
   * 
   * @param id identificador da plataforma.
   * @param info informaes que sero modificadas.
   * @return uma referncia para a plataforma modificada.
   * @throws DAOException se ocorrer algum problema na modificao da plataforma
   *         na fonte de dados.
   */
  Platform modifyPlatform(Object id, PlatformInfo info) throws DAOException;

  /**
   * Exclui uma plataforma na fonte de dados.
   * 
   * @param id identificador da plataforma.
   * @throws DAOException se ocorrer algum problema na excluso da plataforma na
   *         fonte de dados.
   */
  void deletePlatform(Object id) throws DAOException;
}
