/**
 * $Id: ProactiveMonitor.java 140813 2013-05-10 15:15:06Z fpina $
 */

package csbase.server.services.diagnosticservice.monitors;

import csbase.server.services.diagnosticservice.engine.Engine;
import csbase.server.services.diagnosticservice.engine.UpdateHandler;

/**
 * Interface que representa um monitor pro-ativo. Monitores deste tipo notificam
 * o {@link Engine}, no qual eles esto registrado, de alguma mudana de estado.
 * 
 * @author Tecgraf
 */
public interface ProactiveMonitor extends Monitor {

  /**
   * Registra o monitor em um {@link Engine}.
   * 
   * @param handler {@link UpdateHandler} no qual o monitor ir se registrar
   */
  public void registerEngine(UpdateHandler handler);
}
