package csbase.server.services.restservice;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Filter request para CORs
 *
 * @author Tecgraf/PUC-Rio
 */
public final class CorsServletFilter implements Filter {
  /**
   * {@inheritDoc}
   */
  @Override
  public void init(FilterConfig filterConfig) throws ServletException {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void doFilter(ServletRequest servletRequest,
    ServletResponse servletResponse, FilterChain filterChain)
      throws IOException, ServletException {

    HttpServletResponse response = (HttpServletResponse) servletResponse;

    HttpServletRequest request = (HttpServletRequest) servletRequest;

    response.setHeader("Access-Control-Allow-Origin", request.getHeader(
      "Origin"));
    response.setHeader("Access-Control-Allow-Credentials", "true");
    response.setHeader("Access-Control-Allow-Methods",
      "POST, GET, PUT, HEAD, OPTIONS, DELETE");
    response.setHeader("Access-Control-Allow-Headers",
      "Authorization, Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers");

    if (request.getMethod().equals("OPTIONS")) {
      response.setStatus(HttpServletResponse.SC_OK);
      return;
    }

    filterChain.doFilter(servletRequest, servletResponse);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void destroy() {
  }
}