/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sgaservice;

import csbase.server.Server;
import csbase.server.services.sgaservice.ORBException;
import java.util.Properties;
import java.util.Set;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import sgaidl.SGAServer;

public class ORBHandler
extends Thread {
    private ORB orb = null;
    private POA rootPOA = null;
    private POA persistentPOA = null;
    private boolean isActive;

    private void init(Properties props) throws ORBException {
        props.setProperty("jacorb.connection.client.disconnect_after_systemexception", "false");
        Set<java.lang.Object> keySet = props.keySet();
        for (java.lang.Object key : keySet) {
            String value = props.getProperty((String)key);
            Server.logInfoMessage("Propriedade ORB: " + key + " = " + value);
        }
        String serverName = props.getProperty("jacorb.implname");
        try {
            String[] args = null;
            this.orb = ORB.init(args, (Properties)props);
            this.rootPOA = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
            Policy[] policies = new Policy[]{this.rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), this.rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
            this.persistentPOA = this.rootPOA.create_POA(serverName + "POA", this.rootPOA.the_POAManager(), policies);
            for (int i = 0; i < policies.length; ++i) {
                policies[i].destroy();
            }
            this.persistentPOA.the_POAManager().activate();
            this.start();
        }
        catch (UserException e) {
            throw new ORBException("Erro na inicializa\u00e7\u00e3o de servidor CORBA", e);
        }
    }

    public void activateObject(String objectID, Servant object) throws ORBException {
        if (!this.isActive) {
            throw new ORBException("Servidor CORBA desativado");
        }
        try {
            this.persistentPOA.activate_object_with_id(objectID.getBytes(), object);
        }
        catch (UserException e) {
            throw new ORBException("Erro na ativa\u00e7\u00e3o de um objeto CORBA", e);
        }
    }

    @Override
    public void run() {
        Server.logFineMessage("Thread iniciada: servidor");
        this.orb.run();
        this.orb.destroy();
        Server.logFineMessage("Thread terminada: servidor");
    }

    public void shutdown() throws ORBException {
        if (!this.isActive) {
            throw new ORBException("Servidor CORBA desativado");
        }
        this.orb.shutdown(false);
        this.isActive = false;
    }

    void setTimeOut(SGAServer ref, long timeout) throws Exception {
        RelativeRoundtripTimeoutPolicy p = new RelativeRoundtripTimeoutPolicy(10000000L * timeout);
        ref._set_policy_override(new Policy[]{p}, SetOverrideType.ADD_OVERRIDE);
    }

    public ORBHandler(Properties props) throws ORBException {
        this.init(props);
        this.isActive = true;
    }
}

