/*
 * $Id$
 */
package csbase.server.services.projectservice;

import java.util.Arrays;

/**
 * Representa um caminho de arquivo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class UpdatableFileLocation {
  /**
   * O identificador do projeto ao qual o arquivo pertence.
   */
  private Object projectId;

  /**
   * O caminho do arquivo.
   */
  private String[] path;

  /**
   * Constri um caminho de arquivo.
   * 
   * @param projectId O identificador do projeto.
   * @param path O caminho do arquivo.
   */
  UpdatableFileLocation(Object projectId, String[] path) {
    this.projectId = projectId;
    this.path = path;
  }

  /**
   * Obtm o identificador do projeto ao qual o arquivo pertence.
   * 
   * @return O identificador do projeto ao qual o arquivo pertence.
   */
  public Object getProjectId() {
    return this.projectId;
  }

  /**
   * Obtm o caminho do arquivo.
   * 
   * @return O caminho do arquivo.
   */
  public String[] getPath() {
    return this.path;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;

    }
    if (!obj.getClass().equals(UpdatableFileLocation.class)) {
      return false;
    }
    UpdatableFileLocation fileLocation = (UpdatableFileLocation) obj;
    if (!this.projectId.equals(fileLocation.projectId)) {
      return false;
    }
    return Arrays.equals(this.path, fileLocation.path);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return this.projectId.hashCode() + Arrays.hashCode(this.path);
  }
}