package csbase.server.services.schedulerservice;

import java.io.Serializable;
import java.util.Comparator;

import csbase.logic.SGASet;

/**
 * Comparador dos SGAs pela carga de CPU.
 */
public class SGASetCPUComparator implements Comparator<SGASet>, Serializable {

  /**
   * Compara as porcentagens de processamento livres de dois SGAs.
   * 
   * @param o1 conjunto de SGAs
   * @param o2 outro conjunto de SGAs
   * @return -1 quando a porcentagem de processamento livre do SGA1 for maior
   *         que a do SGA2. 0 quando a porcentagem de processamento livre do
   *         SGA1 for igual a do SGA2. 1 quando a porcentagem de processamento
   *         livre do SGA1 for menor que a do SGA2.
   */
  public int compare(SGASet o1, SGASet o2) {
    if (o1.getCPULoad1() < o2.getCPULoad1())
      return -1;
    if (o1.getCPULoad1() > o2.getCPULoad1())
      return 1;
    return 0;
  }

}
