/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice.monitors.openbus;

import csbase.logic.diagnosticservice.ResourceException;
import csbase.logic.diagnosticservice.Status;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.AbstractMonitor;
import csbase.server.services.diagnosticservice.monitors.openbus.ConnectionValidation;
import csbase.server.services.diagnosticservice.monitors.openbus.DuplicatedOfferValidation;
import csbase.server.services.diagnosticservice.monitors.openbus.OfferIdValidation;
import csbase.server.services.diagnosticservice.monitors.openbus.OpenbusServiceValidation;
import csbase.server.services.diagnosticservice.monitors.openbus.RegistryServiceValidation;
import csbase.server.services.openbusservice.OpenBusService;
import java.util.Locale;
import java.util.Properties;
import scs.core.ComponentId;

public class ServiceOfferMonitor
extends AbstractMonitor {
    private ComponentId component;
    private boolean propertiesChecked = false;

    public ServiceOfferMonitor(ComponentId component) throws ResourceException {
        super(component.name);
        this.component = component;
        this.addValidation(new OpenbusServiceValidation());
        this.addValidation(new ConnectionValidation());
        this.addValidation(new RegistryServiceValidation());
        this.addValidation(new OfferIdValidation(component));
        this.addValidation(new DuplicatedOfferValidation(component));
    }

    @Override
    public synchronized Status checkResource(Locale locale) throws ResourceException {
        if (!this.propertiesChecked) {
            this.propertiesChecked = true;
            this.addProperty(MessageTranslator.getString("server.offermonitor.offer.name.label", locale), this.component.name, "component.name em scs.core.ComponentId");
            this.addProperty(MessageTranslator.getString("server.offermonitor.offer.platform.label", locale), this.component.platform_spec, "platform_spec em scs.core.ComponentId");
            this.addProperty(MessageTranslator.getString("server.offermonitor.offer.major.version.label", locale), String.valueOf(this.component.major_version), "major_version em scs.core.ComponentId");
            this.addProperty(MessageTranslator.getString("server.offermonitor.offer.minor.version.label", locale), String.valueOf(this.component.minor_version), "minor_version em scs.core.ComponentId");
            this.addProperty(MessageTranslator.getString("server.offermonitor.offer.patch.version.label", locale), String.valueOf(this.component.patch_version), "patch_version em scs.core.ComponentId");
            String offerId = OpenBusService.getInstance().getRegisteredComponentBusId(this.component);
            this.addProperty(MessageTranslator.getString("server.offermonitor.offer.id.label", locale), String.valueOf(offerId), "identificador da oferta retornada no registro");
            Properties properties = OpenBusService.getInstance().getRegisteredComponentProperties(this.component);
            int i = 0;
            for (Object key : properties.keySet()) {
                this.addProperty(MessageTranslator.getString("server.offermonitor.property.label", new String[]{String.valueOf(++i)}, locale), properties.getProperty((String)key), (String)key);
            }
            String[] facets = OpenBusService.getInstance().getRegisteredComponentFacets(this.component);
            i = 0;
            for (String facet : facets) {
                this.addProperty(MessageTranslator.getString("server.offermonitor.facet.label", new String[]{String.valueOf(++i)}, locale), facet, null);
            }
        }
        return super.checkResource(locale);
    }
}

