package csbase.server.services.restservice.client;

import java.util.Locale;

import csbase.remote.ClientRemoteLocator;
import csbase.server.Server;
import csbase.server.ServerEntryPointImpl;
import csbase.server.services.restservice.RestService;
import ibase.rest.api.client.v1.adapter.ClientService;
import ibase.rest.api.client.v1.adapter.UnauthorizedException;
import ibase.rest.model.client.v1.UrlToken;

/**
 * Implementao do adaptador CSBase para um servio de autenticao.
 *
 * @author Tecgraf/PUC-Rio
 */
public class ClientServiceImpl implements ClientService {

  /**
   * {@inheritDoc}
   */
  @Override
  public UrlToken getClientPreLoginURL(String restToken, Locale locale,
    Boolean desktopVisible) throws UnauthorizedException {
    final ServerEntryPointImpl entryPoint = (ServerEntryPointImpl) Server
      .getInstance().getEntryPoint();
    UrlToken urlToken = entryPoint.preLogin2WebWithRestToken(restToken, locale,
      desktopVisible);
    if (urlToken == null) {
      throw new UnauthorizedException(RestService.getInstance().getString(
        "RestService.invalid.token.error"));
    }
    return urlToken;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getClientHttpServerURL(String clientToken, Locale locale)
    throws UnauthorizedException {
    RestService restService = RestService.getInstance();
    String clientHttpServer = restService.getClientHttpServer(clientToken);
    if (clientHttpServer == null) {
      throw new UnauthorizedException(RestService.getInstance().getString(
        "RestService.invalid.token.error"));
    }
    return clientHttpServer;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setLocale(Locale locale) {
    ClientRemoteLocator.administrationService.setLocale(locale);
  }
}
