package csbase.server.services.sgaservice;

import csbase.exception.CSBaseException;

/**
 * Representa uma falha durante um procedimento de obteno do cdigo de sada
 * de um algoritmo executado.
 * 
 * @author Tecgraf
 */
public class ExitCodeNotFoundException extends CSBaseException {

  /**
   * Constri uma exceo sem descrio nem causa associadas.
   */
  public ExitCodeNotFoundException() {
    super();
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param message a descrio do erro
   */
  public ExitCodeNotFoundException(String message) {
    super(message);
  }

  /**
   * Constri uma exceo contendo a causa/exceo original.
   * 
   * @param exception a exceo original
   */
  public ExitCodeNotFoundException(Throwable exception) {
    super(exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   * 
   * @param message a descrio do erro
   * @param exception a exceo original
   */
  public ExitCodeNotFoundException(String message, Throwable exception) {
    super(message, exception);
  }
}
