/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.filetransferservice;

import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import java.util.ArrayList;
import java.util.List;

public class FileTransferRequestQueue {
    private final List<FileTransferRequest> waitList = new ArrayList<FileTransferRequest>();
    private final List<FileTransferRequest> runList = new ArrayList<FileTransferRequest>();
    private final List<FileTransferRequest> endList = new ArrayList<FileTransferRequest>();

    private void addList(User user, List<FileTransferRequest> inList, List<FileTransferRequest> outList) {
        for (FileTransferRequest request : inList) {
            if (user == null) {
                outList.add(request);
                continue;
            }
            FileTransferConnection connection = request.getConnection();
            Object requestUserId = connection.getUserId();
            Object userId = user.getId();
            if (!userId.equals(requestUserId)) continue;
            outList.add(request);
        }
    }

    synchronized FileTransferRequest getRequestFromId(String id) {
        for (FileTransferRequest rq : this.waitList) {
            if (!rq.getId().equals(id)) continue;
            return rq;
        }
        for (FileTransferRequest rq : this.runList) {
            if (!rq.getId().equals(id)) continue;
            return rq;
        }
        for (FileTransferRequest rq : this.endList) {
            if (!rq.getId().equals(id)) continue;
            return rq;
        }
        return null;
    }

    synchronized List<FileTransferRequest> getAllRequests(User user) {
        ArrayList<FileTransferRequest> list = new ArrayList<FileTransferRequest>();
        this.addList(user, this.waitList, list);
        this.addList(user, this.runList, list);
        this.addList(user, this.endList, list);
        return list;
    }

    synchronized void putToWaitList(FileTransferRequest request) {
        this.waitList.add(request);
    }

    synchronized void moveFromWaitToRunList(String requestId) {
        FileTransferRequest request = this.delFromList(this.waitList, requestId);
        if (request != null) {
            this.waitList.remove(request);
            this.runList.add(request);
        }
    }

    synchronized void moveToEndedList(String requestId) {
        FileTransferRequest request = null;
        request = this.delFromList(this.waitList, requestId);
        if (request != null) {
            this.waitList.remove(request);
            this.endList.add(request);
            return;
        }
        request = this.delFromList(this.runList, requestId);
        if (request != null) {
            this.runList.remove(request);
            this.endList.add(request);
            return;
        }
    }

    private FileTransferRequest delFromList(List<FileTransferRequest> list, String requestId) {
        FileTransferRequest toRemove = null;
        for (FileTransferRequest rq : list) {
            if (!rq.getId().equals(requestId)) continue;
            toRemove = rq;
            break;
        }
        if (toRemove != null && list.contains(toRemove)) {
            list.remove(toRemove);
            return toRemove;
        }
        return null;
    }

    synchronized int getNumRunningRequests() {
        return this.runList.size();
    }

    synchronized FileTransferRequest pickWaitingRequest() {
        if (this.waitList.size() > 0) {
            return this.waitList.get(0);
        }
        return null;
    }

    synchronized void removeFromAllLists(FileTransferRequest request) {
        String requestId = request.getId();
        this.delFromList(this.runList, requestId);
        this.delFromList(this.waitList, requestId);
        this.delFromList(this.endList, requestId);
    }
}

