package csbase.server.services.administrationservice;

/**
 * A classe <code>DAOException</code> representa uma exceo ocorrida dentro
 * de um DAO do servio de administrao.
 */
public class DAOException extends Exception {

  /**
   * Informao sobre a operao que gerou a exceo. Usado para facilitar a
   * deteco de problemas de acesso a dados.
   */
  private String operationInfo;

  /**
   * Constri uma exceo contendo a descrio do erro, a causa/exceo original
   * e a consulta que gerou a exceo.
   * 
   * @param message a descrio do erro.
   * @param cause a exceo original.
   * @param operationInfo informao sobre a operao que gerou a exceo.
   */
  public DAOException(String message, Throwable cause, String operationInfo) {
    super(message, cause);
    this.operationInfo = operationInfo;
  }

  /**
   * Constri uma exceo contendo sua descrio e a consulta que gerou a
   * exceo.
   * 
   * @param message a descrio do erro.
   * @param operationInfo informao sobre a operao que gerou a exceo.
   */
  public DAOException(String message, String operationInfo) {
    super(message);
    this.operationInfo = operationInfo;
  }

  /**
   * Constri uma exceo contendo a causa/exceo original e a consulta que
   * gerou a exceo.
   * 
   * @param cause a exceo original.
   * @param operationInfo informao sobre a operao que gerou a exceo.
   */
  public DAOException(Throwable cause, String operationInfo) {
    super(cause);
    this.operationInfo = operationInfo;
  }

  /**
   * Constri uma exceo contendo a causa/exceo original e sem a consulta que
   * gerou a exceo.
   * 
   * @param cause a exceo original.
   */
  public DAOException(Throwable cause) {
    this(cause, null);
  }

  /**
   * Sobrescrevendo para incluir a informao sobre a operao que gerou a
   * exceo na mensagem.
   * 
   * @return A mensagem de descrio do erro.
   */
  public String getMessage() {
    String message = super.getMessage();
    if (null != operationInfo) {
      message += "\n\n" + operationInfo + "\n";
    }
    return message;
  }
}
