package csbase.server.services.restservice;

import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;

/**
 * Classe utilizada para retirar o NULL do json
 *
 * @author Tecgraf/PUC-Rio
 */
@Provider
@Produces(MediaType.APPLICATION_JSON)
public class CSJsonProvider extends JacksonJaxbJsonProvider {
  /**
   * Mapeador de json
   */
  private final ObjectMapper objectMapper;

  /**
   * Construtor padrao
   */
  public CSJsonProvider() {
    objectMapper = new ObjectMapper();
    objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    super.setMapper(objectMapper);
  }
}