/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice.heuristic;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.heuristic.ImpossibleAllocationException;
import csbase.server.services.schedulerservice.heuristic.InvalidSGASetException;
import csbase.server.services.schedulerservice.heuristic.ResourceControllerInterface;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Allocation
implements Cloneable,
Comparable<Allocation> {
    private Map<CommandInfo, SGASet> allocationMap = new HashMap<CommandInfo, SGASet>();
    private List<SGASet> simulatedServers = new LinkedList<SGASet>();
    private List<CommandInfo> remainingCommands = new LinkedList<CommandInfo>();
    private boolean isFeasible;
    private ResourceControllerInterface manager;
    private HashMap<String, SGASet> originalServers;

    public Allocation(Map<CommandInfo, SGASet> allocationMap, List<SGASet> simulatedServers, List<CommandInfo> remainingCommands, boolean isFeasible, ResourceControllerInterface manager, HashMap<String, SGASet> originalServers) {
        this.allocationMap.putAll(allocationMap);
        this.simulatedServers.addAll(simulatedServers);
        this.remainingCommands.addAll(remainingCommands);
        this.isFeasible = isFeasible;
        this.manager = manager;
        this.originalServers = originalServers;
    }

    private Map<CommandInfo, SGASet> createAllocationMapCopy() {
        HashMap<CommandInfo, SGASet> map = new HashMap<CommandInfo, SGASet>();
        map.putAll(this.allocationMap);
        return map;
    }

    public boolean isFeasible() {
        return this.isFeasible;
    }

    public Map<CommandInfo, SGASet> getFeasibleAllocationMap() {
        return this.isFeasible ? this.createAllocationMapCopy() : null;
    }

    public Map<CommandInfo, SGASet> getPartialAllocationMap() {
        return this.createAllocationMapCopy();
    }

    public List<SGASet> getServersSimulations() {
        LinkedList<SGASet> states = new LinkedList<SGASet>();
        states.addAll(this.simulatedServers);
        return states;
    }

    public List<CommandInfo> getRemainingCommands() {
        LinkedList<CommandInfo> cmds = new LinkedList<CommandInfo>();
        cmds.addAll(this.remainingCommands);
        return cmds;
    }

    public void unsetAllocation(CommandInfo cmd) {
        SGASet originalPreviousSGA = this.allocationMap.get(cmd);
        if (originalPreviousSGA != null) {
            this.allocationMap.remove(cmd);
            SGASet previousSGA = null;
            for (SGASet sga : this.simulatedServers) {
                if (sga.getName() != originalPreviousSGA.getName()) continue;
                previousSGA = sga;
                break;
            }
            this.simulatedServers.remove(previousSGA);
            this.simulatedServers.add(this.manager.undoResourceConsumptionSimulation(cmd, previousSGA));
            this.remainingCommands.remove(cmd);
            this.isFeasible = false;
        }
    }

    public SGASet setAllocation(CommandInfo cmd, SGASet server) throws ImpossibleAllocationException, InvalidSGASetException {
        if (!this.simulatedServers.contains(server)) {
            throw new InvalidSGASetException(server, this);
        }
        this.unsetAllocation(cmd);
        if (server != null) {
            LinkedList<SGASet> candidates = new LinkedList<SGASet>();
            candidates.add(server);
            if (this.manager.getServersThatMeetsRequirements(cmd, candidates).isEmpty()) {
                throw new ImpossibleAllocationException(cmd, server, this);
            }
            this.allocationMap.put(cmd, this.originalServers.get(server.getName()));
            this.simulatedServers.remove(server);
            SGASet updatedServerState = this.manager.simulateResourceConsumption(cmd, server);
            this.simulatedServers.add(updatedServerState);
            this.remainingCommands.remove(cmd);
            if (this.remainingCommands.isEmpty()) {
                this.isFeasible = true;
            }
            return updatedServerState;
        }
        return null;
    }

    public List<SGASet> getPossibleChanges(CommandInfo cmd) {
        List<SGASet> candidates = this.manager.getServersThatMeetsRequirements(cmd, this.simulatedServers);
        SGASet originalCurrentSGA = this.allocationMap.get(cmd);
        if (originalCurrentSGA != null) {
            SGASet currentSGA = null;
            for (SGASet sga : candidates) {
                if (sga.getName() != originalCurrentSGA.getName()) continue;
                currentSGA = sga;
                break;
            }
            if (currentSGA != null) {
                candidates.remove(currentSGA);
            }
        }
        return candidates;
    }

    public List<CommandInfo> getPossibleChanges(SGASet server) {
        LinkedList<CommandInfo> candidates = new LinkedList<CommandInfo>();
        candidates.addAll(this.remainingCommands);
        candidates.addAll(this.allocationMap.keySet());
        for (CommandInfo cmd : this.allocationMap.keySet()) {
            if (this.allocationMap.get(cmd) != server) continue;
            candidates.remove(cmd);
        }
        return this.manager.getPossibleCommands(candidates, server);
    }

    public Allocation clone() {
        return new Allocation(this.allocationMap, this.simulatedServers, this.remainingCommands, this.isFeasible, this.manager, this.originalServers);
    }

    public List<CommandInfo> getCurrentlyAllocatedCommands(SGASet server) {
        LinkedList<CommandInfo> cmds = new LinkedList<CommandInfo>();
        for (CommandInfo cmd : this.allocationMap.keySet()) {
            if (this.allocationMap.get(cmd).getName() != server.getName()) continue;
            cmds.add(cmd);
        }
        return cmds;
    }

    public SGASet getServerState(String serverName) {
        for (SGASet server : this.simulatedServers) {
            if (server.getName() != serverName) continue;
            return server;
        }
        return null;
    }

    @Override
    public final int compareTo(Allocation other) {
        if (this.isFeasible == other.isFeasible) {
            return 0;
        }
        if (this.isFeasible) {
            return 1;
        }
        return -1;
    }
}

