/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.server.Server;
import csbase.server.ServerException;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.StringTokenizer;

public class FileSystem {
    public static final String PROPERTIES_DIR = "properties";

    public static long getFreeSpace(String path) {
        try {
            FileStore store = Files.getFileStore(Paths.get(path, new String[0]));
            return store.getUsableSpace();
        }
        catch (Exception e) {
            String fmt = "Erro obtendo espa\u00e7o livre de disco em: %s";
            String err = String.format("Erro obtendo espa\u00e7o livre de disco em: %s", path);
            Server.logSevereMessage(err, e);
            return -1L;
        }
    }

    public static long getTotalSpace(String path) {
        try {
            FileStore store = Files.getFileStore(Paths.get(path, new String[0]));
            return store.getTotalSpace();
        }
        catch (Exception e) {
            String fmt = "Erro obtendo espa\u00e7o total de disco em: %s";
            String err = String.format("Erro obtendo espa\u00e7o total de disco em: %s", path);
            Server.logSevereMessage(err, e);
            return -1L;
        }
    }

    public static boolean moveRegularFile(File from, File to) {
        Server.logInfoMessage("FileSystem.moveRegularFile:  de: " + from.getAbsolutePath() + "  para: " + to.getAbsolutePath());
        if (!from.exists()) {
            Server.logSevereMessage("FileSystem.moveRegularFile: arquivo origem n\u00e3o existe: " + from.getAbsolutePath());
            return false;
        }
        if (!FileSystem.copyFile(from, to)) {
            return false;
        }
        if (from.delete()) {
            return true;
        }
        Server.logSevereMessage("FileSystem.moveRegularFile: Erro removendo arquivo origem: " + from.getAbsolutePath());
        return false;
    }

    public static boolean move(File from, File to) {
        File newChildFile;
        if (!from.isDirectory()) {
            return FileSystem.moveRegularFile(from, to);
        }
        if (!to.mkdirs()) {
            Server.logSevereMessage("FileSystem.move: Erro na criando diret\u00f3rio(s) : " + to.getAbsolutePath());
            return false;
        }
        File[] children = from.listFiles();
        boolean success = true;
        for (int i = 0; i < children.length && (success = FileSystem.move(children[i], newChildFile = new File(to, children[i].getName()))); ++i) {
        }
        if (success) {
            if (from.delete()) {
                return true;
            }
            Server.logSevereMessage("FileSystem.move: Erro removendo diret\u00f3rio origem: " + from.getAbsolutePath());
        }
        return success;
    }

    public static boolean copyFile(File from, File to) {
        Path source = Paths.get(from.getAbsolutePath(), new String[0]);
        Path target = Paths.get(to.getAbsolutePath(), new String[0]);
        Server.logInfoMessage(String.format("FileSystem.copyFile: de '%s' para '%s'", source, target));
        String cmd = String.format("FileSystem:copyFile: Erro copiando arquivo (%s %s)", source, target);
        try {
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Server.logSevereMessage(cmd, e);
            return false;
        }
        return true;
    }

    public static boolean copyDir(File from, File to) {
        Path source = Paths.get(from.getAbsolutePath(), new String[0]);
        Path target = Paths.get(to.getAbsolutePath(), new String[0]);
        Server.logInfoMessage(String.format("FileSystem.copyDir: de '%s' para '%s'", source, target));
        String cmd = String.format("FileSystem:copyDir: Erro copiando diret\u00f3rio (%s %s)", source, target);
        try {
            Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new CopyDirectory(source, target));
        }
        catch (IOException e) {
            Server.logSevereMessage(cmd, e);
            return false;
        }
        return true;
    }

    public static void removeFile(File file, boolean removeRoot) throws Exception {
        File[] children;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (children = file.listFiles()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                FileSystem.removeFile(children[i], true);
            }
        }
        if (removeRoot && !file.delete()) {
            throw new Exception("Falha na remo\u00e7\u00e3o de " + file.getPath());
        }
    }

    public static final boolean enableExecutionPermission(String filePath) throws ServerException {
        if (filePath == null) {
            throw new IllegalArgumentException("filePath == null");
        }
        if (filePath.equals("")) {
            throw new IllegalArgumentException("filePath est\u00e1 vazia");
        }
        try {
            return new File(filePath).setExecutable(true, false);
        }
        catch (Exception e) {
            throw new ServerException("Erro ao mudar execu\u00e7\u00e3o do arquivo '" + filePath + "'", e);
        }
    }

    private static String[] createCommandArray(String cmd, String ... args) {
        StringTokenizer cmdTokenizer = new StringTokenizer(cmd);
        int numTokens = cmdTokenizer.countTokens();
        String[] cmdArray = new String[args.length + numTokens];
        int i = 0;
        while (i < numTokens) {
            cmdArray[i++] = cmdTokenizer.nextToken();
        }
        System.arraycopy(args, 0, cmdArray, i, args.length);
        return cmdArray;
    }

    public static class CopyDirectory
    extends SimpleFileVisitor<Path> {
        private Path source;
        private Path target;

        public CopyDirectory(Path source, Path target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Server.logFineMessage("Copying " + this.source.relativize(file));
            Files.copy(file, this.target.resolve(this.source.relativize(file)), new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) throws IOException {
            block2: {
                Path targetDirectory = this.target.resolve(this.source.relativize(directory));
                try {
                    Server.logFineMessage("Copying " + this.source.relativize(directory));
                    Files.copy(directory, targetDirectory, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException e) {
                    if (Files.isDirectory(targetDirectory, new LinkOption[0])) break block2;
                    throw e;
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

