/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice;

import csbase.exception.ParseException;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.RestServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.restservice.CSBaseLoggerHandler;
import csbase.server.services.restservice.CSBaseRequestFilter;
import csbase.server.services.restservice.CSBaseResourceConfig;
import csbase.server.services.restservice.CSBaseResponseFilter;
import csbase.server.services.restservice.CSBaseRuntimeExceptionMapper;
import csbase.server.services.restservice.CSJsonProvider;
import csbase.server.services.restservice.CorsServletFilter;
import csbase.server.services.restservice.websocket.messenger.CSBaseMessenger;
import csbase.server.services.restservice.websocket.notificationcenter.CSBaseNotificationCenter;
import ibase.common.DAOFactory;
import ibase.common.ServiceAdapter;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class RestService
extends Service
implements RestServiceInterface {
    private HttpServer httpServer;
    private SecretKey privateKey;
    private boolean clientDevMode;
    private final Map<String, String> clientHttpServers;

    protected RestService() throws ServerException {
        super("RestService");
        ClientRemoteLocator.restService = this;
        this.setEnabled(this.getBooleanProperty("enabled"));
        this.clientDevMode = this.getBooleanProperty("client.developer.mode");
        this.clientHttpServers = new HashMap<String, String>();
    }

    @Override
    protected void initService() throws ServerException {
        this.loadPrivateKey();
        String[] packages = this.loadPackages();
        this.loadDAOFactories();
        RestService.buildSwagger(packages);
        final Map<Class<? extends Factory<ServiceAdapter>>, Class<?>> factories = this.loadAdapterFactories();
        final Map<Class<?>, Class<?>> injectionClasses = this.loadInjectionClasses();
        CSBaseResourceConfig config = new CSBaseResourceConfig(packages);
        config.register(new AbstractBinder(){

            protected void configure() {
                factories.forEach((k, v) -> this.bindFactory((Class)k).to((Type)v));
            }
        });
        config.register(new AbstractBinder(){

            protected void configure() {
                injectionClasses.forEach((k, v) -> this.bind((Class)k).to((Type)v));
            }
        });
        config.register(ApiListingResource.class);
        config.register(SwaggerSerializers.class);
        config.register(CSBaseRequestFilter.class);
        config.register(CSBaseResponseFilter.class);
        config.register(MultiPartFeature.class);
        config.register(CSJsonProvider.class);
        config.register(JacksonFeature.class);
        config.register(new CSBaseRuntimeExceptionMapper());
        try {
            this.httpServer = this.createHttpServer();
            ServletContainer container = new ServletContainer((ResourceConfig)config);
            WebappContext context = new WebappContext("WebappContext", "/v1");
            ServletRegistration registration = context.addServlet("ServletContainer", (Servlet)container);
            registration.addMapping(new String[]{"/*"});
            FilterRegistration corsFilter = context.addFilter("CorsFilter", (Filter)new CorsServletFilter());
            corsFilter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
            this.httpServer.getListener("grizzly").registerAddOn((AddOn)new WebSocketAddOn());
            WebSocketEngine.getEngine().register("", "/messenger", (WebSocketApplication)new CSBaseMessenger());
            WebSocketEngine.getEngine().register("", "/notification", (WebSocketApplication)new CSBaseNotificationCenter());
            this.httpServer.start();
            context.deploy(this.httpServer);
            CLStaticHttpHandler staticHttpHandler = new CLStaticHttpHandler(CSBaseResourceConfig.class.getClassLoader(), new String[]{"swagger-ui/", "docs/"});
            this.httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHttpHandler, new String[]{"/docs"});
        }
        catch (Exception e) {
            throw new ServerException(e);
        }
    }

    private HttpServer createHttpServer() throws Exception {
        boolean secure = this.getBooleanProperty("SSL.enable");
        URI url = RestService.getBaseURI(secure, this.getIntProperty("service.port"));
        NetworkListener listener = new NetworkListener("grizzly", url.getHost(), url.getPort());
        HttpServer server = HttpServer.createSimpleServer((String)(url.getScheme() + url.getHost()), (int)url.getPort());
        if (secure) {
            this.logInfoMessage("--- Servidor HTTP com SSL habilitado");
            listener.setSecure(secure);
            SSLEngineConfigurator sslEngineConfigurator = this.createSSLConfig();
            listener.setSSLEngineConfig(sslEngineConfigurator);
        }
        server.addListener(listener);
        return server;
    }

    public void unregisterClientHttpServer(String token) {
        this.clientHttpServers.remove(token);
    }

    public boolean isClientDeveloperMode() {
        return this.clientDevMode;
    }

    public void registerClientHttpServer(String token, String httpServerURL) {
        this.clientHttpServers.put(token, httpServerURL);
    }

    public String getClientHttpServer(String token) {
        return this.clientHttpServers.get(token);
    }

    private static URI getBaseURI(boolean secure, int port) {
        String protocol = secure ? "https" : "http";
        return UriBuilder.fromUri((String)(protocol + "://0.0.0.0")).port(port).path("/").build(new Object[0]);
    }

    private SSLEngineConfigurator createSSLConfig() throws Exception {
        String keystore = this.getStringProperty("SSL.keystore");
        String keystorePass = this.getStringProperty("SSL.keystore_password");
        SSLContextConfigurator sslContextConfigurator = new SSLContextConfigurator();
        sslContextConfigurator.setKeyStoreFile(keystore);
        sslContextConfigurator.setKeyStorePass(keystorePass);
        SSLEngineConfigurator result = new SSLEngineConfigurator(sslContextConfigurator.createSSLContext(), false, false, false);
        return result;
    }

    private void loadPrivateKey() throws ServerException {
        String privateKeyFilePath = this.getStringProperty("private.key.file");
        try {
            this.privateKey = this.readKeyFromFile(privateKeyFilePath);
        }
        catch (Exception e) {
            throw new ServerException(e);
        }
    }

    private String[] loadPackages() throws ServerException {
        List<String> classList = this.getStringListProperty("resources.service.class");
        ArrayList<String> packages = new ArrayList<String>();
        for (String c : classList) {
            try {
                Class<?> cl = Class.forName(c);
                packages.add(cl.getPackage().getName());
                Logger.getLogger(cl.getSimpleName()).addHandler(new CSBaseLoggerHandler());
            }
            catch (ClassNotFoundException e) {
                throw new ServerException("A classe configurada em resources.service.class precisam estar dispon\u00edvel", e);
            }
        }
        return packages.toArray(new String[0]);
    }

    private Map<Class<? extends Factory<ServiceAdapter>>, Class<?>> loadAdapterFactories() throws ServerException {
        List<String> factorys = this.getStringListProperty("adapter.service.factory");
        HashMap factories = new HashMap();
        for (int i = 0; i < factorys.size(); ++i) {
            try {
                Class<?> factoryClass = Class.forName(factorys.get(i));
                Type[] genericInterfaces = factoryClass.getGenericInterfaces();
                ParameterizedType genericType = (ParameterizedType)genericInterfaces[0];
                Type type = genericType.getActualTypeArguments()[0];
                Class<?> interfaceClass = Class.forName(type.getTypeName());
                factories.put(factoryClass, interfaceClass);
                continue;
            }
            catch (Throwable e) {
                throw new ServerException(e);
            }
        }
        return factories;
    }

    private Map<Class<?>, Class<?>> loadInjectionClasses() throws ServerException {
        List<String> injectionClasses = this.getStringListProperty("injection.class");
        List<String> injectionTypes = this.getStringListProperty("injection.type");
        HashMap repositories = new HashMap();
        for (int i = 0; i < injectionClasses.size(); ++i) {
            try {
                Class<?> repositoryClass = Class.forName(injectionClasses.get(i));
                Class<?> interfaceClass = Class.forName(injectionTypes.get(i));
                repositories.put(repositoryClass, interfaceClass);
                continue;
            }
            catch (Throwable e) {
                throw new ServerException(e);
            }
        }
        return repositories;
    }

    private void loadDAOFactories() {
        String index;
        int i = 1;
        while (this.hasProperty("RestService.dao.service.factory.".concat(index = String.valueOf(i)))) {
            String factoryClassName = this.getStringProperty("dao.service.factory.".concat(index));
            try {
                Class<?> factoryClass = Class.forName(factoryClassName);
                Class<?> interfaceClass = factoryClass.getInterfaces()[0];
                DAOFactory factory = (DAOFactory)DAOFactory.class.cast(factoryClass.newInstance());
                if (this.hasProperty("RestService.dao.service.properties.".concat(index))) {
                    Properties properties = this.getExternalPropertyFile("dao.service.properties.".concat(index));
                    factory.setProperties(properties);
                }
                ServiceAdapter.addDAOFactory(interfaceClass, (DAOFactory)factory);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
    }

    private static void buildSwagger(String[] packageNames) {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setVersion("1.0.0");
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String p : packageNames) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(p.trim());
            ++i;
        }
        beanConfig.setResourcePackage(builder.toString());
        beanConfig.setScan(true);
        beanConfig.setBasePath("/v1");
    }

    @Override
    protected void shutdownService() throws ServerException {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.shutdown();
        }
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    public static void createService() throws ServerException {
        new RestService();
    }

    public static RestService getInstance() {
        return (RestService)RestService.getInstance("RestService");
    }

    public String createToken(String subject, Map<String, Object> attributes, Date expirationDate, Date issuedDate) {
        if (issuedDate == null) {
            issuedDate = new Date();
        }
        Claims claims = Jwts.claims();
        if (subject != null) {
            claims.setSubject(subject);
        }
        if (attributes != null) {
            claims.putAll(attributes);
        }
        String token = Jwts.builder().setClaims(claims).setExpiration(expirationDate).setIssuedAt(issuedDate).signWith(SignatureAlgorithm.HS512, (Key)this.privateKey).compact();
        return token;
    }

    public String parserToken(String token, Map<String, Object> outAttributes) throws ParseException {
        String subject = null;
        try {
            long lastSeconds;
            AdministrationService adminService;
            User user;
            Claims claims = (Claims)Jwts.parser().setSigningKey((Key)this.privateKey).parseClaimsJws(token).getBody();
            subject = claims.getSubject();
            if (outAttributes != null) {
                outAttributes.putAll((Map<String, Object>)claims);
                outAttributes.put("exp", claims.getExpiration());
                outAttributes.put("iat", claims.getIssuedAt());
            }
            if ((user = (adminService = AdministrationService.getInstance()).getUser(subject)) == null) {
                throw new ParseException(this.getFormattedString("RestService.user.not.found", new Object[]{subject}));
            }
            Date tokenIssued = claims.getIssuedAt();
            long lastPasswordUpdate = user.getLastPasswordUpdate();
            if (lastPasswordUpdate == -1L) {
                return subject;
            }
            Date lastUpdate = new Date(user.getLastPasswordUpdate());
            long issueSeconds = tokenIssued.getTime() / 1000L;
            if (issueSeconds - (lastSeconds = lastUpdate.getTime() / 1000L) < 0L) {
                throw new ParseException(this.getString("RestService.invalid.token.error"));
            }
        }
        catch (Exception e) {
            throw new ParseException(this.getString("RestService.invalid.token.error"));
        }
        return subject;
    }

    public String getExternalURL() {
        return this.getStringProperty("external.url");
    }

    public void logSevereMessage(String msg, Throwable t) {
        Server.logSevereMessage(msg, t);
    }

    public void logInfoMessage(String msg) {
        Server.logInfoMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretKey readKeyFromFile(String privateKeyFileName) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        try (FileInputStream fis = new FileInputStream(privateKeyFileName);){
            FileChannel channel = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
            int size = channel.read(buffer);
            if (size != (int)channel.size()) {
                throw new IOException("N\u00e3o foi poss\u00edvel ler todo o arquivo.");
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(buffer.array(), "HmacSHA512");
            return secretKeySpec;
        }
    }
}

