/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CommandInfo;
import csbase.logic.FailureFinalizationType;
import csbase.logic.Priority;
import csbase.logic.SGASet;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.schedulerservice.PercCPUPolicy;
import csbase.server.services.schedulerservice.PriorityQueue;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.SchedulerResourcesController;
import csbase.server.services.schedulerservice.SchedulerService;
import csbase.server.services.sgaservice.SGAService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;

public class Scheduler {
    private Thread schedulerThread;
    private boolean exitSchedulerThread;
    private final PriorityQueue commandQueue;
    private final SchedulerService service;
    private final SGAService sgaService;
    private final HashMap<String, Long> recentUsedServers;
    private final int sgaQuarantine;
    private final long queueProcessingInterval;
    private final int MaxSubmissionRetries;
    private SchedulerPolicyInterface schedPolicyInterface;
    private final String schedPolicyName;
    private static SchedulerResourcesController schedulerResourcesController;

    protected Scheduler(PriorityQueue commandQueue, long queueProcessingInterval, int submissionRetries, int sgaQuarantine, String schedPolicyName, boolean resourcesControl, String backupFilePath) {
        this.commandQueue = commandQueue;
        this.queueProcessingInterval = queueProcessingInterval;
        this.MaxSubmissionRetries = submissionRetries;
        this.sgaQuarantine = sgaQuarantine;
        this.schedPolicyName = schedPolicyName;
        this.sgaService = SGAService.getInstance();
        this.service = SchedulerService.getInstance();
        this.recentUsedServers = new HashMap();
        schedulerResourcesController = new SchedulerResourcesController(resourcesControl, backupFilePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandInfo preProcessCommand(CommandInfo cmd) {
        try {
            Service.setUserId(cmd.getUserId());
            switch (cmd.getStatus()) {
                case EXECUTING: 
                case DOWNLOADING: 
                case FINISHED: 
                case SYSTEM_FAILURE: {
                    this.commandQueue.remove(cmd.getId());
                    return null;
                }
                case SCHEDULED: {
                    if (this.MaxSubmissionRetries > 0 && cmd.getSubmissionAttempts() >= this.MaxSubmissionRetries) {
                        this.commandQueue.remove(cmd.getId());
                        this.service.failCommand(cmd, FailureFinalizationType.MAX_SUBMISSION_RETRIES_REACHED);
                        try {
                            Server.logWarningMessage("Comando retirado da fila por excesso de tentativas de submiss\u00e3o. Plataforma " + cmd.getPlatformFilter() + " ID: " + cmd.getId() + "Algoritmo " + cmd.getConfigurator().getAlgorithmName());
                            return null;
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    cmd.incSubmissionAttempts();
                    if (cmd.getSubmissionAttempts() > 1) {
                        this.service.notifyReschedule(cmd);
                    }
                    CommandInfo commandInfo = cmd;
                    return commandInfo;
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            Service.setUserId(null);
        }
    }

    /*
     * Exception decompiling
     */
    private CommandInfo processCommand(CommandInfo cmd, SGASet sga) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 9[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CommandInfo posProcessCommand(CommandInfo cmd) {
        try {
            if (cmd.getPriority() == Priority.ROOT) {
                Service.setUserId(cmd.getUserId());
                this.commandQueue.remove(cmd.getId());
                Server.logWarningMessage("Falha ao disparar comando com prioridade ROOT. N\u00e3o foi encontrado um SGA dispon\u00edvel para atender a plataforma " + cmd.getPlatformFilter() + " do algoritmo usado no comando: " + cmd.getId());
                this.service.failCommand(cmd, FailureFinalizationType.NO_SGA_AVAILABLE_TO_ROOT_COMMAND);
                CommandInfo commandInfo = null;
                return commandInfo;
            }
        }
        catch (Exception exception) {
        }
        finally {
            Service.setUserId(null);
        }
        return cmd;
    }

    protected void startScheduler() {
        this.loadSchedulerPolicy();
        this.schedulerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Scheduler.this.exitSchedulerThread) {
                    List<CommandInfo> cmds = Scheduler.this.commandQueue.getAndWaitForCommands();
                    List cmdsToSchedule = cmds.stream().filter(c -> Scheduler.this.preProcessCommand(c) != null).collect(Collectors.toList());
                    if (cmdsToSchedule.isEmpty()) {
                        Server.logFineMessage("N\u00e3o h\u00e1 comandos para processar. Fila em sleep.");
                        Scheduler.this.commandQueue.sleep(Scheduler.this.queueProcessingInterval);
                        continue;
                    }
                    Map allocation = Scheduler.this.allocateSGA(cmdsToSchedule);
                    int numOfCmdsScheduled = 0;
                    if (allocation != null) {
                        numOfCmdsScheduled = (int)cmdsToSchedule.stream().filter(c -> Scheduler.this.processCommand(c, (SGASet)allocation.get(c)) != null).filter(c -> Scheduler.this.posProcessCommand(c) != null).count();
                    }
                    int numOfRemaningCmds = cmdsToSchedule.size() - numOfCmdsScheduled;
                    if (Scheduler.this.commandQueue.size() <= 0 || Scheduler.this.commandQueue.size() != numOfRemaningCmds) continue;
                    Server.logFineMessage("Ainda h\u00e1 comandos para processar. Fila em sleep.");
                    Scheduler.this.commandQueue.sleep(Scheduler.this.queueProcessingInterval);
                }
            }
        });
        this.schedulerThread.setName(this.getClass().getSimpleName() + "::SchedulerThread");
        this.schedulerThread.start();
    }

    private Map<CommandInfo, SGASet> allocateSGA(List<CommandInfo> cmds) {
        Vector<String> sgasNames = this.sgaService.getAllSGANames();
        List<String> serversFiltered = this.filterQuarantaineSGAs(sgasNames);
        if (serversFiltered == null || serversFiltered.isEmpty()) {
            return null;
        }
        LinkedList<SGASet> sgasSetsFiltered = new LinkedList<SGASet>();
        for (String name : serversFiltered) {
            sgasSetsFiltered.add(this.sgaService.getSGASet(name));
        }
        this.clearQuarantine();
        return this.schedPolicyInterface.chooseServer(cmds, sgasSetsFiltered);
    }

    protected void stopScheduler() {
        this.exitSchedulerThread = true;
    }

    private SchedulerPolicyInterface loadSchedulerPolicy() {
        try {
            Class<?> c = Class.forName(this.schedPolicyName);
            this.schedPolicyInterface = (SchedulerPolicyInterface)c.newInstance();
        }
        catch (Exception e) {
            this.schedPolicyInterface = new PercCPUPolicy();
            Server.logSevereMessage(String.format("Erro ao ativar a pol\u00edtica de escalonamento %s.", this.schedPolicyName), e);
        }
        Server.logInfoMessage("Classe de escalonamento instanciada: " + this.schedPolicyInterface.getClass().getName() + ".java.");
        return this.schedPolicyInterface;
    }

    private void clearQuarantine() {
        Iterator<Long> iterator = this.recentUsedServers.values().iterator();
        while (iterator.hasNext()) {
            Long quarantineExpirationTime = iterator.next();
            long now = System.currentTimeMillis();
            if (now - quarantineExpirationTime <= (long)this.sgaQuarantine) continue;
            iterator.remove();
        }
    }

    private List<String> filterQuarantaineSGAs(List<String> sgaNames) {
        if (sgaNames == null) {
            return null;
        }
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String sgaName : sgaNames) {
            if (this.isInQuarantine(sgaName)) continue;
            filteredList.add(sgaName);
        }
        return filteredList.isEmpty() ? null : filteredList;
    }

    private boolean isInQuarantine(String sgaName) {
        if (!this.recentUsedServers.containsKey(sgaName)) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.sgaQuarantine > 0 && now - this.recentUsedServers.get(sgaName) <= (long)this.sgaQuarantine) {
            return true;
        }
        this.recentUsedServers.remove(sgaName);
        return false;
    }

    public static SchedulerResourcesController getSchedulerResourcesController() {
        return schedulerResourcesController;
    }
}

