/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice.monitors.openbus;

import csbase.logic.diagnosticservice.ResourceException;
import csbase.logic.diagnosticservice.Status;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.AbstractMonitor;
import csbase.server.services.diagnosticservice.monitors.openbus.BusVersionValidation;
import csbase.server.services.diagnosticservice.monitors.openbus.ConnectionValidation;
import csbase.server.services.diagnosticservice.monitors.openbus.OpenbusServiceValidation;
import csbase.server.services.diagnosticservice.monitors.openbus.RegistryServiceValidation;
import csbase.server.services.openbusservice.OpenBusService;
import java.util.Locale;

public class OpenbusMonitor
extends AbstractMonitor {
    private String host;
    private int port;

    public OpenbusMonitor() throws ResourceException {
        super("openbus");
        this.addValidation(new OpenbusServiceValidation());
        if (OpenBusService.getInstance().isEnabled()) {
            this.addValidation(new ConnectionValidation());
            this.addValidation(new RegistryServiceValidation());
            this.host = OpenBusService.getInstance().getBusInfo().getHost();
            this.port = OpenBusService.getInstance().getBusInfo().getPort();
            this.addValidation(new BusVersionValidation(this.host, this.port));
        }
    }

    @Override
    public synchronized Status checkResource(Locale locale) throws ResourceException {
        this.cleanProperties();
        this.addProperty(MessageTranslator.getString("server.openbusmonitor.host.label", locale), String.valueOf(this.host), "OpenBusService.ACS.hostAddr");
        this.addProperty(MessageTranslator.getString("server.openbusmonitor.port.label", locale), String.valueOf(this.port), "OpenBusService.ACS.port");
        this.addProperty(MessageTranslator.getString("server.openbusmonitor.entity.label", locale), OpenBusService.getInstance().getEntityName(), "OpenBusService.entity.name");
        this.addProperty(MessageTranslator.getString("server.openbusmonitor.private.key.label", locale), OpenBusService.getInstance().getPrivateKeyFilePath(), "OpenBusService.private.key.file ");
        return super.checkResource(locale);
    }
}

