/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.logic.SecureKey;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.projectservice.FileLockInterface;
import java.lang.ref.WeakReference;

class ExclusiveFileLock
implements FileLockInterface {
    Object id;
    private boolean serverRequested;
    private WeakReference<SecureKey> sessionKeyRef;

    ExclusiveFileLock(SecureKey skey, Object id) {
        this.id = id;
        if (skey == null) {
            this.serverRequested = true;
        } else {
            this.sessionKeyRef = new WeakReference<SecureKey>(skey);
            this.serverRequested = false;
        }
    }

    @Override
    public int getLockRefCount(SecureKey sessionKey) {
        SecureKey sKey;
        if (this.serverRequested ? sessionKey == null : this.sessionKeyRef != null && (sKey = (SecureKey)this.sessionKeyRef.get()) != null && sKey.equals((Object)sessionKey)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getLockRefCount() {
        if (this.hasExpired()) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean hasExpired() {
        if (this.serverRequested) {
            return false;
        }
        if (this.sessionKeyRef == null) {
            return true;
        }
        Object sessionKey = this.sessionKeyRef.get();
        return sessionKey == null || LoginService.getInstance().getUserByKey(sessionKey) == null;
    }

    @Override
    public FileLockInterface.LockStatus checkLockStatus(SecureKey sessionKey) {
        return this.checkLockStatus(sessionKey.toString());
    }

    @Override
    public boolean newLocker(SecureKey skey, Object lockId) {
        if (!this.hasExpired()) {
            return false;
        }
        this.id = lockId;
        if (skey == null) {
            this.serverRequested = true;
        } else {
            this.sessionKeyRef = new WeakReference<SecureKey>(skey);
            this.serverRequested = false;
        }
        return true;
    }

    @Override
    public boolean removeLocker(Object lockId) {
        if (!this.id.equals(lockId)) {
            return false;
        }
        this.serverRequested = false;
        this.sessionKeyRef = null;
        return true;
    }

    @Override
    public boolean isShared() {
        return false;
    }

    @Override
    public FileLockInterface.LockStatus checkLockStatus(String sessionKey) {
        if (this.serverRequested) {
            if (sessionKey == null) {
                return FileLockInterface.LockStatus.LOCKED_BY_USER;
            }
        } else {
            if (this.sessionKeyRef == null) {
                return FileLockInterface.LockStatus.UNLOCKED;
            }
            SecureKey ref = (SecureKey)this.sessionKeyRef.get();
            if (ref == null) {
                return FileLockInterface.LockStatus.EXPIRED;
            }
            if (ref.toString().equals(sessionKey)) {
                return FileLockInterface.LockStatus.LOCKED_BY_USER;
            }
        }
        return FileLockInterface.LockStatus.LOCKED_BY_OTHERS;
    }

    Object getId() {
        return this.id;
    }
}

