/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.notificationservice;

import csbase.logic.Notification;
import csbase.logic.User;
import csbase.logic.UserNotification;
import csbase.remote.NotificationServiceInterface;
import csbase.remote.RemoteEvent;
import csbase.remote.RemoteObserver;
import csbase.remote.RemoteObserverNotifierInterface;
import csbase.remote.RemoteObserversNotificationManager;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.notificationservice.NotificationContainer;
import csbase.server.services.notificationservice.NotificationServiceExecutor;
import csbase.server.services.notificationservice.NotificationServiceThreadFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class NotificationService
extends Service
implements NotificationServiceInterface,
RemoteObserverNotifierInterface {
    private NotificationContainer container = null;
    private boolean exitCleanThread = false;
    private Thread cleanThread = null;
    private boolean exitBackupThread = false;
    private Thread backupThread = null;
    private boolean exitStatsThread = false;
    private Thread statsThread = null;
    private NotificationServiceExecutor executor = null;
    private final Hashtable<Object, RemoteObserversNotificationManager> usersObservers = new Hashtable();

    public static NotificationService getInstance() {
        return (NotificationService)NotificationService.getInstance("NotificationService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addObserver(RemoteObserver observer, Object userId) {
        RemoteObserversNotificationManager uobs;
        if (observer == null || userId == null) {
            return;
        }
        Hashtable<Object, RemoteObserversNotificationManager> hashtable = this.usersObservers;
        synchronized (hashtable) {
            uobs = this.usersObservers.get(userId);
            if (uobs == null) {
                uobs = new RemoteObserversNotificationManager((RemoteObserverNotifierInterface)this, Server.getInstance().getDefaultLocale());
                this.usersObservers.put(userId, uobs);
            }
        }
        uobs.addObserver(observer);
        this.notifyUserObservers(userId);
    }

    protected final boolean has2Update(Object arg, Object event) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean deleteObserver(RemoteObserver observer, Object userId) {
        if (observer == null || userId == null) {
            return false;
        }
        Hashtable<Object, RemoteObserversNotificationManager> hashtable = this.usersObservers;
        synchronized (hashtable) {
            RemoteObserversNotificationManager uobs = this.usersObservers.get(userId);
            if (uobs != null) {
                boolean result = uobs.deleteObserver(observer);
                if (uobs.isEmpty()) {
                    this.usersObservers.remove(userId);
                }
                return result;
            }
        }
        return false;
    }

    private void setupExecutor() {
        boolean gatherStats = this.getBooleanProperty("generateStats");
        int maxThreads = this.getIntProperty("maxThreads");
        long keepAlive = this.getIntProperty("keepAliveMinutes");
        Server.logInfoMessage("[gatherStats]: " + gatherStats);
        Server.logInfoMessage("[maxThreads]: " + maxThreads);
        Server.logInfoMessage("[keepAlive]: " + (keepAlive *= 60000L) + "ms");
        this.executor = new NotificationServiceExecutor(gatherStats, maxThreads, maxThreads, keepAlive, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new NotificationServiceThreadFactory());
        this.executor.allowCoreThreadTimeOut(true);
        if (gatherStats) {
            this.createStatsThread();
        }
    }

    @Override
    public final void initService() throws ServerException {
        this.setupExecutor();
        this.readBackup();
        this.createBackupThread();
        this.createCleanThread();
    }

    public final void notifyTo(Object[] userIds, String content, boolean mustPopUp, boolean volFlag) {
        if (content == null) {
            throw new IllegalArgumentException("content == null");
        }
        String sender = NotificationService.getUser().getLogin();
        this.notifyTo(userIds, (Notification)new UserNotification(sender, content, mustPopUp, volFlag));
    }

    public void notifyTo(Object[] userIds, Notification notification) {
        if (userIds == null) {
            this.notifyAllUsers(notification);
        } else {
            for (int i = 0; i < userIds.length; ++i) {
                this.notifyUser(userIds[i], notification);
            }
        }
    }

    private void notifyAllUsers(Notification notification) {
        if (!this.isActive()) {
            return;
        }
        try {
            List users = User.getAllUsers();
            for (User user : users) {
                this.notifyUser(user.getId(), notification);
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de notifica\u00e7\u00e3o all-users.", e);
        }
    }

    private void notifyUser(Object userId, Notification notification) {
        if (!this.isActive()) {
            return;
        }
        try {
            this.insertUserNotification(userId, notification);
            this.notifyUserObservers(userId);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de notifica\u00e7\u00e3o. De: " + notification.getSender() + " Para: " + userId + " - Falha: " + e.getMessage());
        }
    }

    @Override
    public final void shutdownService() {
        Server.logInfoMessage("Finalizando executor de updates...");
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        Server.logInfoMessage("Finalizando threads...");
        this.exitStatsThread = true;
        this.exitBackupThread = true;
        this.exitCleanThread = true;
        if (this.statsThread != null) {
            this.statsThread.interrupt();
        }
        if (this.backupThread != null) {
            this.backupThread.interrupt();
        }
        if (this.cleanThread != null) {
            this.cleanThread.interrupt();
        }
        this.statsThread = null;
        this.backupThread = null;
        this.cleanThread = null;
        Server.logInfoMessage("Gravando mensagens n\u00e3o entregues em backup...");
    }

    private String getBackupFileName() {
        String BACKUP_FILENAME = "backup.dat";
        try {
            Server server = Server.getInstance();
            String sep = File.separator;
            String pName = server.getPersistencyRootDirectoryName();
            String dName = pName + sep + "notifications";
            Server.checkDirectory(dName);
            return dName + sep + "backup.dat";
        }
        catch (Throwable t) {
            Server.logSevereMessage("Falha de aquisi\u00e7\u00e3o de backup:" + t.getMessage());
            return "backup.dat";
        }
    }

    private void cleanNotifications(long days) {
        if (this.container == null) {
            return;
        }
        if (this.container.clean(days)) {
            Server.logFineMessage("Limpeza de mensagens realiza com sucesso.");
        } else {
            Server.logSevereMessage("Falha de limpeza de mensagens");
        }
    }

    private void writeStats() {
        long wmaxrt = this.executor.getWeightedMaxRuntime();
        Server.logFineMessage("Tempo m\u00e1ximo por notifica\u00e7\u00e3o: " + wmaxrt + "ms");
        long wminrt = this.executor.getWeightedMinRuntime();
        Server.logFineMessage("Tempo m\u00ednimo por notifica\u00e7\u00e3o: " + wminrt + "ms");
        long amaxrt = this.executor.getAbsoluteMaxRuntime();
        Server.logFineMessage("Tempo m\u00e1ximo por thread de notifica\u00e7\u00f5es: " + amaxrt + "ms");
        long aminrt = this.executor.getAbsoluteMinRuntime();
        Server.logFineMessage("Tempo m\u00ednimo por thread de notifica\u00e7\u00f5es: " + aminrt + "ms");
        int execs = this.executor.getExecutions();
        Server.logFineMessage("N\u00famero de notifica\u00e7\u00f5es enviadas: " + execs);
        int faults = this.executor.getFaults();
        Server.logFineMessage("N\u00famero de falhas na estat\u00edstica acima: " + faults);
        int active = this.executor.getActiveCount();
        Server.logFineMessage("N\u00famero de notifica\u00e7\u00f5es sendo enviadas agora: " + active);
        int maxsize = this.executor.getLargestPoolSize();
        Server.logFineMessage("Tamanho m\u00e1ximo atingido pelo pool: " + maxsize);
        int size = this.executor.getPoolSize();
        Server.logFineMessage("Tamanho atual do pool: " + size);
    }

    private void createStatsThread() {
        long statsIntervalMinutes = this.getIntProperty("statsIntervalMinutes");
        Server.logInfoMessage("[statsIntervalMinutes]: " + statsIntervalMinutes + " min.");
        final long sleepTime = statsIntervalMinutes * 60L * 1000L;
        this.statsThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!NotificationService.this.exitStatsThread) {
                    try {
                        NotificationService.this.writeStats();
                        NotificationService.this.executor.reset();
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        Server.logInfoMessage("Gera\u00e7\u00e3o de estat\u00edsticas interrompida!");
                    }
                }
                Server.logInfoMessage("Finalizando thread de grava\u00e7\u00e3o de estat\u00edsticas...");
            }
        });
        this.exitStatsThread = false;
        this.statsThread.setName(((Object)((Object)this)).getClass().getSimpleName() + "::StatsThread");
        this.statsThread.start();
    }

    private void createBackupThread() {
        int TEN_MINUTES = 10;
        long backupIntervalMinutes = this.getIntProperty("backupIntervalMinutes");
        if (backupIntervalMinutes < 10L) {
            backupIntervalMinutes = 10L;
        }
        Server.logInfoMessage("[backupIntervalMinutes]: " + backupIntervalMinutes + " min.");
        final long sleepTime = backupIntervalMinutes * 60L * 1000L;
        this.backupThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!NotificationService.this.exitBackupThread) {
                    try {
                        NotificationService.this.writeBackup();
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        Server.logWarningMessage("Grava\u00e7\u00e3o de backups interrompido!");
                        NotificationService.this.writeBackup();
                    }
                }
                Server.logWarningMessage("Finalizando thread de grava\u00e7\u00e3o de backups...");
            }
        });
        this.exitBackupThread = false;
        this.backupThread.setName(((Object)((Object)this)).getClass().getSimpleName() + "::BackupThread");
        this.backupThread.start();
    }

    private void createCleanThread() {
        int TEN_DAYS = 10;
        int cleanDays = this.getIntProperty("cleanIntervalDays");
        if (cleanDays < 10) {
            cleanDays = 10;
        }
        Server.logFineMessage("[cleanIntervalDays] = " + cleanDays);
        int TEN_SECONDS = 10;
        int volSeconds = this.getIntProperty("volatileIntervalSeconds");
        if (volSeconds <= 0) {
            volSeconds = 10;
        }
        Server.logFineMessage("[volatileIntervalSeconds] = " + volSeconds);
        long daysToMili = 86400000L;
        long secToMili = 1000L;
        final long sleepTime = (long)volSeconds * secToMili;
        final long delta = (long)cleanDays * daysToMili;
        Server.logInfoMessage("Intervalo de limpeza: " + cleanDays + " dias.");
        this.cleanThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!NotificationService.this.exitCleanThread) {
                    try {
                        NotificationService.this.cleanNotifications(delta);
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        Server.logWarningMessage("Limpeza de mensagens interrompida!");
                    }
                }
                Server.logFineMessage("Finalizando thread de limpeza...");
            }
        });
        this.exitCleanThread = false;
        this.cleanThread.setName(((Object)((Object)this)).getClass().getSimpleName() + "::CleanThread");
        this.cleanThread.start();
    }

    private void notifyRemoteObservers(Object userId, RemoteObserversNotificationManager uobs, ArrayList<Notification> notifications) {
        this.executor.setExecutionWeight(uobs.numObservers());
        uobs.notifyObservers((RemoteObserverNotifierInterface)this, notifications.toArray(new RemoteEvent[0]));
    }

    private void insertUserNotification(Object usrId, Notification notif) {
        if (this.container != null) {
            this.container.insertUserNotification(usrId, notif);
        }
    }

    private void notifyUserObservers(final Object userId) {
        if (this.container == null) {
            return;
        }
        if (!this.container.userHasNotifications(userId)) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RemoteObserversNotificationManager uobs;
                Hashtable hashtable = NotificationService.this.usersObservers;
                synchronized (hashtable) {
                    uobs = (RemoteObserversNotificationManager)NotificationService.this.usersObservers.get(userId);
                    if (uobs == null || uobs.isEmpty()) {
                        return;
                    }
                }
                ArrayList<Notification> notifs = NotificationService.this.container.retrieveUserNotifications(userId);
                if (notifs != null && !notifs.isEmpty()) {
                    NotificationService.this.notifyRemoteObservers(userId, uobs, notifs);
                }
            }
        };
        this.executor.execute(runnable);
    }

    private void readBackup() {
        String backupFileName = this.getBackupFileName();
        File backupFile = new File(backupFileName);
        String backupFilePath = backupFile.getAbsolutePath();
        Server.logInfoMessage("Iniciando recupera\u00e7\u00e3o de backup de: " + backupFilePath);
        if (!backupFile.exists()) {
            String msg = "N\u00e3o foi encontrado arquivo de backup de notifica\u00e7\u00f5es: ";
            Server.logWarningMessage("N\u00e3o foi encontrado arquivo de backup de notifica\u00e7\u00f5es: " + backupFilePath);
            this.container = new NotificationContainer();
            return;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(backupFile)));
            this.container = (NotificationContainer)in.readObject();
            in.close();
            Server.logInfoMessage("Notifica\u00e7\u00f5es recuperadas de: " + backupFilePath);
        }
        catch (InvalidClassException ce) {
            this.container = new NotificationContainer();
            String err = "N\u00e3o foi poss\u00edvel fazer recupera\u00e7\u00e3o de backup. ";
            String cause = "Vers\u00e3o de container n\u00e3o compat\u00edvel com arquivo: ";
            Server.logWarningMessage("N\u00e3o foi poss\u00edvel fazer recupera\u00e7\u00e3o de backup. Vers\u00e3o de container n\u00e3o compat\u00edvel com arquivo: " + backupFilePath);
        }
        catch (Exception e) {
            this.container = new NotificationContainer();
            Server.logSevereMessage("Falha de recupera\u00e7\u00e3o de backup: " + backupFilePath, e);
        }
    }

    private void writeBackup() {
        String bkp = this.getBackupFileName();
        if (this.container != null) {
            File dataFile = new File(bkp);
            if (this.container.dumpContainer(dataFile)) {
                Server.logFineMessage("Feito backup de notifica\u00e7\u00f5es em: " + bkp);
            } else {
                Server.logSevereMessage("Falha de grava\u00e7\u00e3o de backup de notifica\u00e7\u00f5es.");
            }
        }
    }

    public static void createService() throws ServerException {
        new NotificationService();
    }

    protected NotificationService() throws ServerException {
        super("NotificationService");
    }
}

